C**** WRTBMY
c
      subroutine wrtbmy( ierr, fipin, subin, ascin, hpin, 
     &                                      tecin, iyrin, popin, emiss )
c
c-----------------------------------------------------------------------
c
c    writes one data record to the output by-model-year data file which will be read by
c    the reporting utility.
c
c    Argument description:
c     Outputs:
c       ierr    I  error flag
c     Inputs:
c       fipin   C  FIPS code
c       subin   C  subregion code
c       ascin   C  SCC code
c       hpin    R  HP category
c       tecin   C  technology type name
c       iyrin   I  model year
c       popin   R  population
c       emiss   R  array of emissions
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      07/20/98  --mmj--  original development (started w/wrtdat)
c      10/19/98  --mmj--  included spillage emissions as separate entry
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4    ierr
      character*5  fipin
      character*5  subin
      character*10 ascin
      character*10 tecin
      real*4       hpin
      integer*4    iyrin
      real*4       popin
      real*4       emiss(MXPOL)
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c  strmin   I   returns the length of a string (min of 1)
c
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local parameters:
c-----------------------------------------------------------------------
c
c  COMMA   C   parameter for the comma character
c
      character*1 COMMA
c
      parameter( COMMA = ',' )
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*400 line
      integer*4     ilen, i
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      line = ' '
c
c   --- write the data to line ---
c
      write(line,9000,ERR=7000) fipin, COMMA,
     &                          subin, COMMA, 
     &                          ascin, COMMA,
     &                          INT(hpin), COMMA,
     &                          tecin, COMMA,
     &                          iyrin, COMMA,
     &                          popin
c
c   --- calculate SPILLAGE as a function of REFUELING ---
c
c     if( emiss(IDXSPL) .GT. 0. ) then
c        if( emiss(IDXDIS) .GT. 0. ) then
c            emiss(IDXDIS) = emiss(IDXDIS) + emiss(IDXSPL)
c        else
c            emiss(IDXDIS) = emiss(IDXSPL)
c        endif
c     endif
c
      do 10 i=IDXTHC,IDXRST
         ilen = strmin(line) + 1
         write(line(ilen:),9001,ERR=7000) COMMA,emiss(i)
   10 continue
c
c     do 20 i=IDXRLS,IDXRST
c        ilen = strmin(line) + 1
c        write(line(ilen:),9001,ERR=7000) COMMA,emiss(i)
c  20 continue
c
c   --- write the entire line to output file ---
c
      write(IOWBMY,'(2A)',ERR=7000) line(:strmin(line)), COMMA
c
c   --- set error code to succes and return ----
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)') 
     &                 'ERROR:  Writing to the by-model-year file ',
     &                                           bmyfl(:strmin(bmyfl))
      write(IOWMSG,'(/,1X,3A)') 
     &                 'ERROR:  Writing to the by-model-year file ',
     &                                           bmyfl(:strmin(bmyfl))
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format(6A,I5,3A,I4,A,E15.8)
 9001 format(A,E15.8)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
