C     Last change:  GK   22 Sep 1998    6:18 pm
C**** RMCHRVMX
c
      subroutine rmchrvmx( ierr )
c
c-----------------------------------------------------------------------
c
c    reads MARINE vessel mix packet
c    during execution of the commercial marine module of the NONROAD program.
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/22/97  --gkohlbach-- cloned from rmexhcru.for for the marine model
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdcmr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4     ierr
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin  I   returns the actual length of a string (min of 1)
c   fndchr  I   returns the index of string in array of strings
c   fndkey
c
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*(4*MXSTR) line
      character*20        keywrd, keyin
      integer*4           irec, jerr
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 0
c
c   --- call routine to find the /VESSEL CHARACTERISTICS/ packet ----
c
      keywrd = '/VESSEL CHARACTERISTICS/'
      call fndkey( jerr, IORVSL, keywrd )
      if( jerr .NE. ISUCES ) then
          ierr = IFAIL
          goto 9999
      endif
c
c   --- read a record as a character string --- 
c
  111 continue
      read(IORVSL,8002,ERR=7000,END=7000) line
      call mspinit()
c
c   --- check for the end keyword ---
c
      keyin = line(1:10)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 222
c
c   --- not the end so increment record count
c
      irec = irec + 1
c
c   --- parse the line
c    +- read SCC
c
      vmxscc(irec) = line(1:10)
      call lftjst( vmxscc(irec) )
      call low2up( vmxscc(irec) )
c
c    +- read vessel fraction
c
      read(line(11:18),'(F8.0)',ERR=7001) vmxfrc(irec)
c
c    +- read size class group 1
c
      read(line(19:26),'(F8.0)',ERR=7001) vmxsiz(1,irec)
c
c    +- read size class group 2
c
      read(line(27:34),'(F8.0)',ERR=7001) vmxsiz(2,irec)
c
c    +- read size class group 3
c
      read(line(35:42),'(F8.0)',ERR=7001) vmxsiz(3,irec)
c
c    +- read size class group 4
c
      read(line(43:50),'(F8.0)',ERR=7001) vmxsiz(4,irec)
c
c    +- read size class group 5
c
      read(line(51:58),'(F8.0)',ERR=7001) vmxsiz(5,irec)
c
c    +- read size class group 6
c
      read(line(59:66),'(F8.0)',ERR=7001) vmxsiz(6,irec)
c
c   --- get the next record ---
c
      goto 111
c
c   --- finished reading file ---
c
  222 continue
      ierr = ISUCES
      nvmxrc = irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot open ',
     &           emfcfl, ', the marine emission factors file.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot open ',
     &           emfcfl, ', the marine emission factors file.'
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &               'Error reading /VESSEL CHARACTERISTICS/ packet. ',
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &               'Error reading /VESSEL CHARACTERISTICS/ packet. ',
     &                               'Line read: ',line(:strmin(line))
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 8001 format(20(:,F10.0))
 8002 format(A132)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
