C**** RDSPIL
c
      subroutine rdspil( ierr,
     &                   iounit, fname )
c
c-----------------------------------------------------------------------
c
c    reads the spillage emisisons factors file and stores the data in common
c    block to be used by the NONROAD program.  
c
c    Argument declaration.
c     Inputs: 
c       iounit  I  unit number of file to read
c       fname   I  file name of file to read
c     Outputs:
c       ierr    I  error flag
c       
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4     ierr
      integer*4     iounit
      character*(*) fname
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin  I   returns the actual length of a string (min of 1)
c   fndchr  I   returns the index of string in array of strings
c
      integer*4 strmin
      integer*4 fndchr
c
c-----------------------------------------------------------------------
c    Local parameters:
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*(4*MXSTR) line
      character*20        keywrd, keyin
      character*10        tectmp
      character*9         modtmp
      character*4         indtmp
      integer*4           irec, i
      integer*4           jerr
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 0
c
c  ---- find the /EMSFAC/ keyword ----
c
      keywrd = '/EMSFAC/'
      call fndkey( jerr, iounit, keywrd )
      if( jerr .NE. ISUCES ) goto 7007
c
c   --- read a record as a character string --- 
c
  111 continue
      irec = irec + 1
      read(iounit,8000,ERR=7000,END=7008) line
      call spinit()
c
c   --- look for /END/ keyword ---
c
      keyin = line(1:20)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 222
c
c   --- parse data fields ---
c
          nsplar = nsplar + 1
          if ( nsplar .GT. MXSPL)  goto 7002
          ascspl(nsplar) = line(1:10)
c
          modtmp = line(12:20)
          call lftjst( modtmp )
          call low2up( modtmp )
          if ( modtmp .NE. PUMP .AND. modtmp .NE. CNTR )  goto 7003
          modspl(nsplar) = modtmp

          indtmp = line(22:25)
          call lftjst( indtmp )
          call low2up( indtmp )
          if ( indtmp .NE. TNKTYP .AND. indtmp .NE. HP )  goto 7006
          indspl(nsplar) = indtmp
c
          read(line(27:31),'(F5.0)',ERR=7004) splpcb(nsplar)
          read(line(33:37),'(F5.0)',ERR=7004) splpce(nsplar)
c
          tectmp = line(39:48)
          if( tectmp .EQ. '          ' )  goto 7005
          call lftjst( tectmp )
          call low2up( tectmp )
          tecspl(nsplar) = tectmp
c
c   --- get the next record ---
c
      goto 111
c
c  --- entire file read ---
c
  222 continue
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A,I5)',ERR=9999) 
     &                      'ERROR:  Reading emission factor file ',
     &                        fname(:strmin(fname)),' at record ',irec
      write(IOWMSG,'(/,1X,3A,I5)',ERR=9999) 
     &                      'ERROR:  Reading emission factor file ',
     &                        fname(:strmin(fname)),' at record ',irec
      goto 9999
c
 7002 continue
      write(IOWSTD,'(/,1X,A,I8,/,9X,2A)',ERR=9999) 
     &   'ERROR:  Number of distinct emission factors exceed max ',
     &     MXSPL,'in file ', fname(:strmin(fname))
      write(IOWMSG,'(/,1X,A,I8,/,9X,2A)',ERR=9999) 
     &   'ERROR:  Number of distinct emission factors exceed max ',
     &     MXSPL,'in file ', fname(:strmin(fname))
      goto 9999
c
 7003 continue
      write(IOWSTD,'(/,1X,2A,/,9X,2A)',ERR=9999) 
     &            'ERROR: Invalid refueling mode specified in ',
     &                    fname(:strmin(fname)), 'Line read: ',
     &                                       line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,9X,2A)',ERR=9999) 
     &            'ERROR: Invalid refueling mode specified in ',
     &                    fname(:strmin(fname)), 'Line read: ',
     &                                       line(:strmin(line))
      goto 9999
c
 7004 continue
      write(IOWSTD,'(/,1X,2A,/,9X,2A)',ERR=9999) 
     &                 'ERROR:  Reading emission factor file ',
     &                         fname(:strmin(fname)),'Line read: ',
     &                                               line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,9X,2A)',ERR=9999) 
     &                 'ERROR:  Reading emission factor file ',
     &                         fname(:strmin(fname)),'Line read: ',
     &                                               line(:strmin(line))
      goto 9999
c
 7005 continue
      write(IOWSTD,'(/,1X,A,/,9X,2A,/,9X,2A)',ERR=9999) 
     &        'ERROR:  Missing or invalid tech type ',
     &            'in emissions factors file ',fname(:strmin(fname)),
     &                           'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,A,/,9X,2A,/,9X,2A)',ERR=9999) 
     &        'ERROR:  Missing or invalid tech type ',
     &            'in emissions factors file ',fname(:strmin(fname)),
     &                           'Line read: ',line(:strmin(line))
      goto 9999
c
 7006 continue
      write(IOWSTD,'(/,1X,2A,/,9X,2A)',ERR=9999) 
     &            'ERROR: Invalid range indicator specified in ',
     &                    fname(:strmin(fname)), 'Line read: ',
     &                                       line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,9X,2A)',ERR=9999) 
     &            'ERROR: Invalid range indicator specified in ',
     &                    fname(:strmin(fname)), 'Line read: ',
     &                                       line(:strmin(line))
      goto 9999
c
 7007 continue
      write(IOWSTD,'(/,1X,4A)',ERR=9999) 'ERROR:  Cannot find ',
     &                                   keywrd(:strmin(keywrd)),
     &                      ' packet of emission factors file ',
     &                                   fname(:strmin(fname))
      write(IOWMSG,'(/,1X,4A)',ERR=9999) 'ERROR:  Cannot find ',
     &                                   keywrd(:strmin(keywrd)),
     &                      ' packet of emission factors file ',
     &                                   fname(:strmin(fname))
      goto 9999
c
 7008 continue
      write(IOWSTD,'(/,1X,A,/,9X,2A)',ERR=9999)
     &     'ERROR:  Unexpected end-of-file reached reading ',
     &        'emission factors file ', fname(:strmin(fname))
      write(IOWMSG,'(/,1X,A,/,9X,2A)',ERR=9999)
     &     'ERROR:  Unexpected end-of-file reached reading ',
     &        'emission factors file ', fname(:strmin(fname))
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
