C     Last change:  GK    2 Oct 1998    1:11 pm
C**** RDMARTRP
c
      subroutine rdmartrp(ierr)
c
c-----------------------------------------------------------------------
c
c    read the marine trip activity data file and store data in arrays.
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c     Inputs:
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      08/01/97  --gfkohlbach --  original development
c      09/14/98  --gfkohlbach
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdcmr.inc'
      include 'nonrdio.inc'
      include 'nonrdalo.inc'
      include 'nonrdreg.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4         ierr
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin   I   returns the actual length of a string (minimum of 1)
c
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local parameters:
c-----------------------------------------------------------------------
c
c   MXIREC  I  maximum number of records in a state file
c
c      integer*4 MXIREC
c
c      parameter( MXIREC = 100000 )
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*132     line
      character*(MXSTR) fname
      character*20      keywrd
      character*20      keyin
      integer*4         jerr, irec
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 0
      ntacrc = 0
c
c   --- open the file that will be used for the data ----
c
      open(file=trpact,unit=IORTRP,ERR=7002,status='UNKNOWN')
c
c   --- look for the packet ----
c
      keywrd = '/MARINE TRIP ACTIVITY/'
      call fndkey( jerr, IORTRP, keywrd )
      if( jerr .NE. ISUCES ) goto 7000
c
c   --- read a record as a character string --- 
c
  111 continue
      read(IORTRP,8002,ERR=7000,END=7000) line
      call mspinit()
      irec = irec + 1
c
c   --- check for the end keyword ---
c
      keyin = line(1:10)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 222
c
c   --- parse the line
c    +- read tacpor  =   Port ID Code
      tacpor(irec) = line(1:5)
c    +- read tacscc  =   SCC
      tacscc(irec) = line(7:16)
c    +- read tachot  =   Hotelling Flag
      tachot(irec) = line(37:39)
c    +- read tactrp  =   activity in trips per year
      read(line(40:45),'(I6)',ERR=7001) tactrp(irec)
c    +- read tacyr   =   reference year
      read(line(47:50),'(I4)',ERR=7001) tacyr(irec)
c
c   --- increment the record counter
c
      ntacrc = ntacrc + 1
c
c   --- get the next record ---
c
      goto 111
c
c   --- finished reading file ---
c
  222 continue
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot find: ',
     &       keywrd(:strmin(keywrd)),' packet of the options file.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot find: ',
     &       keywrd(:strmin(keywrd)),' packet of the options file.'
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,3A,I8)',ERR=9999)
     &                     'ERROR:  Reading marine trip activity file ',
     &                        fname(:strmin(fname)),' at record: ',irec
      write(IOWMSG,'(/,1X,3A,I8)',ERR=9999)
     &                     'ERROR:  Reading marine trip activity file ',
     &                        fname(:strmin(fname)),' at record: ',irec
      goto 9999
c
 7002 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Error opening ',
     &                 'marine trip activity file',fname(:strmin(fname))
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Error opening ',
     &                 'marine trip activity file',fname(:strmin(fname))
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A20,A)
 8002 format(A132)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      close(IORTRP)
      return
      end
