C     Last change:  GK   22 Sep 1998    6:18 pm
C**** RDMARPOR
c
      subroutine rdmarpor( ierr )
c
c-----------------------------------------------------------------------
c
c    reads the MARINE PORTS section of the options file and stores
c    the data in common block to be used by the commercial marine module
c    of the NONROAD program.
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/01/93  --gmw--  original development
c      09/21/97  --gkohlbach-- cloned from rdage.for for marine model
c      08/21/98  --gkohlbach-- added logic to check that county code for
c                 each port in /MARINE PORTS/ packet is also being
c                 processed by the regular model.
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdcmr.inc'
      include 'nonrdreg.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4     ierr
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin  I   returns the actual length of a string (min of 1)
c   fndchr  I   returns the index of a string in an array of strings
c
      integer*4 strmin
      integer*4 fndchr
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*(4*MXSTR) line
      character*20        keywrd, keyin
      character*5         fiptmp
      integer*4           irec, jerr, idxfip
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 0
c
c   --- call routine to find the /MARINE PORTS/ packet ----
c
      keywrd = '/MARINE PORTS/'
      call fndkey( jerr, IORUSR, keywrd )
      if( jerr .NE. ISUCES ) then
          ierr = ISUCES
          goto 9999
      endif
c
c   --- read a record as a character string --- 
c
  111 continue
      read(IORUSR,8002,ERR=7000,END=7000) line
      call mspinit()
c
c   --- check for the end keyword ---
c
      keyin = line(1:10)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 333
c
c   --- parse the line
c    +- read FIPS county code
c
      fiptmp=line(1:5)
      call low2up( fiptmp )
      call lftjst( fiptmp )
c
c    +- check that fips code is also included in the core model.
c       If not a county, it could be a state.
c
      idxfip = fndchr( fiptmp,5,fipcod,NCNTY)
      if( idxfip .LE. 0 ) then
      	idxfip=fndchr(fiptmp,5,statcd,NSTATE)
          if( idxfip .LE. 0 ) then
c         warn of invalid FIPS code
            write(IOWSTD,'(/,1X,3A)',ERR=9999) 'WARNING: An invalid ',
     &        'state code has been requested for marine:  ',fiptmp
            write(IOWMSG,'(/,1X,3A)',ERR=9999) 'WARNING: An invalid ',
     &        'state code has been requested for marine:  ',fiptmp
            goto 111
          endif
c         warn of not selected FIPS code
          if( .NOT. lstacd(idxfip) ) then
            write(IOWSTD,'(/,1X,4A)',ERR=9999) 'WARNING: state code ',
     &      'not selected by regular model has been requested ',
     &      'for marine:  ',fiptmp
            write(IOWMSG,'(/,1X,4A)',ERR=9999) 'WARNING: state code ',
     &      'not selected by regular model has been requested ',
     &      'for marine:  ',fiptmp
            goto 111
          endif
      elseif( .NOT. lfipcd(idxfip) ) then
c     warn of not selected FIPS code
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'WARNING: county code not ',
     &  'selected by regular model has been requested for marine:  ',
     &        fiptmp
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'WARNING: county code not ',
     &  'selected by regular model has been requested for marine:  ',
     &        fiptmp
         goto 111
      endif
c
c    +- fips code is ok so increment index, store marine fipcode,
c          and set corresponding element of logic array to true.
c
      irec = irec + 1
      marfip(irec)=fiptmp
      lporcd(irec)=.TRUE.
      call low2up( marfip(irec) )
      call lftjst( marfip(irec) )
c
c    +- read representative port code
c
      marpor(irec)=line(7:11)
      call low2up( marpor(irec) )
      call lftjst( marpor(irec) )
c
c    +- read scaling factor
c
      read(line(13:22),'(F10.0)',ERR=7001) marsca(irec)
c
c   --- get the next record ---
c
      goto 111
c
c   --- finished reading file ---
c
  333 continue
      ierr = ISUCES
      nmarpr = irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(//,1X,3A)',ERR=9999) 'ERROR:  Reading ',
     &           keywrd(:strmin(keywrd)),' packet of options file.'
      write(IOWMSG,'(//,1X,3A)',ERR=9999) 'ERROR:  Reading ',
     &           keywrd(:strmin(keywrd)),' packet of options file.'
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,2A,I10,/,1X,2A)',ERR=9999)
     &                      'ERROR:  Reading /MARINE PORTS/ packet. ',
     &                        'at record: ',irec,
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,I10,/,1X,2A)',ERR=9999)
     &                      'ERROR:  Reading /MARINE PORTS/ packet. ',
     &                        'at record: ',irec,
     &                               'Line read: ',line(:strmin(line))
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 8001 format(20(:,F10.0))
 8002 format(A132)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
