C**** RDACT
c
      subroutine rdact( ierr )
c
c-----------------------------------------------------------------------
c
c    Reads the activity file and stores the data in common
c    block to be used by the EPA Nonroad program
c
c    Argument declaration.
c     Outputs:
c       ierr  I error flag
c     Inputs:
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/01/93  --gmw--  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdusr.inc'
      include 'nonrdact.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin  I   returns the actual length of a string (minimum of 1)
c   chkasc  L   returns true if SCC code is needed for current run
c
      integer*4 strmin
      logical*4 chkasc
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*(2*MXSTR) line
      character*20        keywrd, keyin
      character*40        eqptmp
      character*15        strtmp
      character*10        asctmp, unitmp, acttmp, tectmp, subtmp
      integer*4           idigit, iend, irec, i, jerr, idxtmp
      real*4              hpcmin, hpcmax, lodtmp, tnktmp
      real*4              hpcavg
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 1
      nactrc = 0
c
c   --- open the file ----
c
      open(IORACT,file=actfl,ERR=7006,status='UNKNOWN')
      rewind(IORACT)
c
c  ---- find the /ACTIVITY/ keyword ----
c
      keywrd = '/ACTIVITY/'
      call fndkey( jerr, IORACT, keywrd )
      if( jerr .NE. ISUCES ) goto 7004
c
c   --- read a record as a character string --- 
c
  111 continue
      read(IORACT,8000,ERR=7000,END=7005) line
      call spinit()
      irec = irec + 1
c
c   --- look for /END/ keyword ---
c
      keyin = line(1:20)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 222
c
c   --- make sure the SCC code is needed ---
c
      asctmp = line(1:10)
      if( .NOT. chkasc( asctmp ) ) goto 111
c
c   --- parse the character string ----
c
      eqptmp = line(12:51)
      subtmp = line(52:56)
      tectmp = line(57:66)
      read(line(67:71),'(F5.0)',ERR=7001) hpcmin
      read(line(72:76),'(F5.0)',ERR=7001) hpcmax
      hpcavg = (hpcmin + hpcmax)/2.0
      read(line(77:81),'(F5.0)',ERR=7001) lodtmp
      read(line(82:86),'(F5.0)',ERR=7001) tnktmp
      call lftjst( subtmp )
      call low2up( subtmp )
      call lftjst( tectmp )
      call low2up( tectmp )
c
c  --- check the units string ---
c
      unitmp = line(87:96)
      call lftjst( unitmp )
      call low2up( unitmp )
      if( (unitmp .EQ. KEYHRD .OR. unitmp .EQ. KEYGLD) .AND. 
     &                                     ismtyp .NE. IDXTYP) goto 7002
      if( unitmp .EQ. KEYHRY ) then
         idxtmp = IDXHRY 
      else if( unitmp .EQ. KEYHRD ) then
         idxtmp = IDXHRD 
      else if( unitmp .EQ. KEYGLY ) then
         idxtmp = IDXGLD 
      else if( unitmp .EQ. KEYGLD ) then
         idxtmp = IDXGLD 
      else
         goto 7007
      endif 
c
c   --- get activity value ---
c
      acttmp = '          '
      idigit = 1
      iend = 106
      do 10 i=97,iend
         if(line(i:i) .NE. ',' .AND. line(i:i) .NE. ' ') then
             acttmp(idigit:idigit) = line(i:i)
             idigit = idigit + 1
         endif
   10 continue
      call rgtjst( acttmp )
c
c   --- get starts value ----
c
      strtmp = ' '
      idigit = 1
      iend = 116
      do 20 i=107,iend
         if(line(i:i) .NE. ',' ) then
             strtmp(idigit:idigit) = line(i:i)
             idigit = idigit + 1
         endif
   20 continue
      call rgtjst( strtmp )
c
c   --- put data in common arrays ---
c
      nactrc = nactrc + 1
      if( nactrc .GT. MXACTR ) goto 7003
      ascact(nactrc) = asctmp
      subact(nactrc) = subtmp
      tecact(nactrc) = tectmp
      hpcact(1,nactrc) = hpcmin
      hpcact(2,nactrc) = hpcmax
      faclod(nactrc) = lodtmp
      iactun(nactrc) = idxtmp
      tnkvol(nactrc) = tnktmp
      read(acttmp,'(F10.0)',ERR=7001) actlev(nactrc)
      read(strtmp,'(F15.0)',ERR=7001) starts(nactrc)
c
c   --- get next record ---
c
      goto 111
c
c   --- finished reading file, close it and return ---
c
  222 continue
      close(IORACT)
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A,I6)',ERR=9999) 
     &          'ERROR:  Reading activity file: ',actfl(:strmin(actfl)),
     &                                               ' at record: ',irec
      write(IOWMSG,'(/,1X,3A,I6)',ERR=9999) 
     &          'ERROR:  Reading activity file: ',actfl(:strmin(actfl)),
     &                                               ' at record: ',irec
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,3A,I6,/,9X,A,/,A)',ERR=9999)
     &                      'ERROR:  Reading activity file: ',
     &                        actfl(:strmin(actfl)),' at record: ',irec,
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,3A,I6,A,/,A)',ERR=9999)
     &                      'ERROR:  Reading activity file: ',
     &                        actfl(:strmin(actfl)),' at record: ',irec,
     &                               'Line read: ',line(:strmin(line))
      goto 9999
c
 7002 continue
      write(IOWSTD,'(/,1X,4A)',ERR=9999) 
     &      'ERROR:  Invalid units type --> ',line(87:96),
     &         ' <-- found in activity file: ',actfl(:strmin(actfl))
      write(IOWSTD,'(9X,4A)',ERR=9999) 'Cannot have daily units when ',
     &                              'doing a ',SUMTOT,' simulation.'
      write(IOWMSG,'(/,1X,4A)',ERR=9999) 
     &      'ERROR:  Invalid units type --> ',line(87:96),
     &         ' <-- found in activity file: ',actfl(:strmin(actfl))
      write(IOWMSG,'(9X,4A)',ERR=9999) 'Cannot have daily units when ',
     &                              'doing a ',SUMTOT,' simulation.'
      goto 9999
c
 7003 continue
      write(IOWSTD,'(/,1X,4A,I10)',ERR=9999) 'ERROR:  Number of ',
     &              'records in activity file ',actfl(:strmin(actfl)),
     &                                       ' exceeds max: ',MXACTR   
      write(IOWMSG,'(/,1X,4A,I10)',ERR=9999) 'ERROR:  Number of ',
     &              'records in activity file ',actfl(:strmin(actfl)),
     &                                       ' exceeds max: ',MXACTR   
      goto 9999
c
 7004 continue
      write(IOWSTD,'(/,1X,4A)',ERR=9999) 'ERROR:  Cannot find ',
     &                                   keywrd(:strmin(keywrd)),
     &               ' packet of activity data file ',
     &                                   actfl(:strmin(actfl))
      write(IOWMSG,'(/,1X,4A)',ERR=9999) 'ERROR:  Cannot find ',
     &                                   keywrd(:strmin(keywrd)),
     &               ' packet of activity data file ',
     &                                   actfl(:strmin(actfl))
      goto 9999
c
 7005 continue
      write(IOWSTD,'(/,1X,4A)',ERR=9999)
     &     'ERROR:  Unexpected end-of-file reached reading ',
     &        'activity data file ',actfl(:strmin(actfl))
      write(IOWMSG,'(/,1X,4A)',ERR=9999)
     &     'ERROR:  Unexpected end-of-file reached reading ',
     &        'activity data file ',actfl(:strmin(actfl))
      goto 9999
c
 7006 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999) 'ERROR: Opening file ',
     &                                           actfl(:strmin(actfl))
      write(IOWMSG,'(/,1X,2A)',ERR=9999) 'ERROR: Opening file ',
     &                                           actfl(:strmin(actfl))
      goto 9999
c
 7007 continue
      write(IOWSTD,'(/,1X,3A,/,9X,2A,5X,A)',ERR=9999)
     &       'ERROR:  Invalid units type --> ',line(87:96),
     &                          ' <-- specified in activity file.',
     &                                       'Source: ',asctmp,eqptmp
      write(IOWMSG,'(/,1X,3A,/,9X,2A,5X,A)',ERR=9999)
     &       'ERROR:  Invalid units type --> ',line(87:96),
     &                          ' <-- specified in activity file.',
     &                                       'Source: ',asctmp,eqptmp
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
