c**** PRCNAT
c
      subroutine prcnat(ierr,icurec,asccod,idxsta,growth)
c
c-----------------------------------------------------------------------
c  
c   This routine does the processing for the nation to state allocation
c   of populations and the application of all of the emission factors
c   and seasonality factors.
c      Argument descriptions:
c        Outputs:
c          ierr    I   error code
c        Inputs:
c          icurec  I   record number of current record
c          asccod  C   SCC code of current record
c          idxsta  I   index of the state 
c          growth  R   growth value (-9 means not yet calulated)
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      05/20/97  --gmw-- original developnent
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdreg.inc'
      include 'nonrdefc.inc'
      include 'nonrdeqp.inc'
      include 'nonrdalo.inc'
      include 'nonrdgrw.inc'
      include 'nonrdact.inc'
      include 'nonrdusr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4    ierr
      character*10 asccod
      integer*4    idxsta
      real*4       growth
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   fndasc   I   returns the best match of an SCC code in an array
c   fndact   I   returns the index of record in activity arrays
c   fndgxf   I   returns the index of the record in growth Xref arrays
c   fndrfm   I   returns the index of the refueling mode
c   fndtch   I   returns the index of the technology type
c   dailyf   R   returns a month/day/hour adjustment factor
c   unitcf   R   returns unit conversion factor
c
      integer*4 fndasc
      integer*4 fndact
      integer*4 fndgxf
      integer*4 fndrfm
      integer*4 fndtch
      real*4    dailyf
      real*4    unitcf
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*10 tecnam(MXTECH)
      character*9  rfmode(MXTECH)
      character*5  subcur
      character*4  indcur
      integer*4    jerr, i, idxasc, icurec, j
      integer*4    idxact(MXTECH,NSTATE), idxgrw(NCNTY), nyrlif, idxyr
      integer*4    iyear, idxtch, idxspc, ndays, iyr
      integer*4    idxunt(MXPOL,MXTECH), idxref, idxall
      real*4       popsta(NSTATE), grwsta(NSTATE), grwtmp
      real*4       modfrc(MXAGYR), actadj(MXAGYR), modpop(MXAGYR)
      real*4       modscp(MXAGYR), detage(MXAGYR), stradj(MXAGYR)
      real*4       emsfac(MXAGYR,MXPOL,MXTECH), emsday(MXPOL)
      real*4       thisfc, fulcsm, hplev, bsfc(MXAGYR,MXTECH)
      real*4       tplfac(NSTATE), tpltmp, poptot, acttot, strtot
      real*4       hpval, adjems(MXPOL), emstmp, detrat
      real*4       tank(MXTECH), denful, tecfrc(MXTECH), emiss, cvttmp
      real*4       popbmy, actbmy, fulbmy, emsbmy(MXPOL), emsthc
      real*4       adetcf(MXPOL,MXTECH), bdetcf(MXPOL,MXTECH)
      real*4       detcap(MXPOL,MXTECH)
      logical*4    luse, lwrote
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c ---- initialize the error code ---
c
      ierr = IFAIL
      iyear = iepyr
      subcur = ' '
c
c  --- find HP level for this HP category ---
c
      hpval = avghpc(icurec)
      if( hpval .LE. hpclev(1) ) then
         hplev = hpclev(1)
      else if( hpval .GT. hpclev(MXHPC) ) then
         hplev = 9999
      else
         hplev = -9.
         do 10 i=2,MXHPC
           if( hplev .LT. 0. .AND. hpval .LT. hpclev(i) ) 
     &                                               hplev = hpclev(i)
   10    continue
      endif
c
c  --- if the population is zero, just write the records and return ---
c
      do 20 i=1,MXPOL
        emsday(i) = 0.
   20 continue
      if( popeqp(icurec) .LE. 0. ) then
         do 30 i=1,NSTATE
            if( lstacd(i) ) call wrtdat(jerr,statcd(i),subcur,
     &                                 asccod,hplev,0.,0.,0.,emsday)
            if( jerr .NE. ISUCES ) goto 9999 
   30    continue
         ierr = ISUCES 
         goto 9999
      endif
c 
c ---- get the allocation coefficients for this SCC code,
c      if not found, error ---
c
      idxasc = fndasc( asccod, ascalo, nalorc )
      if( idxasc .LE. 0 ) goto 7000
c
c   --- initialize the population arrays to zero ----
c
      do 40 i=1,NSTATE
         popsta(i) = 0.
 40   continue
c
c  ---- if this is a national record, call routine to calculate 
c       the populations in each state based on national 
c       to state allocation ---
c
      if( idxsta .LE. 0 ) then
         nnatrc = nnatrc + 1
         call alosta(jerr,popsta,grwsta,
     &                  icurec,popeqp(icurec),idxasc,luse,growth)
         if( jerr .NE. ISUCES ) goto 9999
c
c  --- if this is a state record, just assign all population to
c      this state ----
c
      else
         popsta(idxsta) = popeqp(icurec)
         grwsta(idxsta) = 1.0
         nstarc(idxsta) = nstarc(idxsta) + 1
      endif 
c
c  --- call routine to find the number of technology types for this
c      piece of equipment ---
c
      idxtch = fndtch(asccod,hpval,iyear)
      if( idxtch .LE. 0 ) then
        write(IOWMSG,'(/,1X,3A,1X,F7.1)',ERR=9999) 'WARNING:  Could ',
     &            'not find any technology fractions for equipment: '
         write(IOWMSG,'(10X,A,10X,A)',ERR=9999) 'SCC code','Average HP'
         write(IOWMSG,'(10X,A,7X,F7.1)',ERR=9999) asccod,hpval
         write(IOWMSG,'(8X,A)',ERR=9999) 'Skipping...'
         call chkwrn(jerr,IDXWTC)
         if( jerr .NE. ISUCES ) goto 9999
         ierr = ISKIP
         goto 9999
      endif
c
c   --- find the fuel density, used for fuel consumption calc ---
c
      denful = 1.0
      if( ifuel .EQ. IDXGS2 .OR. ifuel .EQ. IDXGS4 ) then
         denful = DENGAS
      else if( ifuel .EQ. IDXCNG ) then
         denful = DENCNG
      else if( ifuel .EQ. IDXLPG ) then
         denful = DENLPG
      else if( ifuel .EQ. IDXDSL ) then
         denful = DENDSL
      endif
c
c   --- loop over states and load some local arrays for each state ---
c
      lwrote = .FALSE.
      do 50 idxsta=1,NSTATE
c
c   --- loop over technology types, looking for activity data ---
c
         do 60 i=1,ntech(idxtch)
            tecnam(i) = tectyp(idxtch,i)
            tecfrc(i) = tchfrc(idxtch,i)
            idxact(i,idxsta) = fndact( asccod, statcd(idxsta), 
     &                          tecnam(i), avghpc(icurec) )
            if( idxact(i,idxsta) .LE. 0 ) then
                write(IOWMSG,9000,ERR=9999) 
     &           'WARNING:  Could not find any activity data for: ',
     &                       'County','SCC','Tech','HP range',
     &                               statcd(idxsta),asccod,tecnam(i),
     &                               hprang(1,icurec),hprang(2,icurec)
                call chkwrn(jerr,IDXWAC)
                if( jerr .NE. ISUCES ) goto 9999
                do 70 j=1,MXPOL
                    emsday(j) = RMISS
   70           continue
                call wrtdat(jerr,statcd(idxsta),subcur,asccod,
     &                                   hplev,RMISS,RMISS,RMISS,emsday)
                if( jerr .NE. ISUCES ) goto 9999
                goto 50
             endif
  60     continue
  50  continue
c            
c  --- loop over years ----
c
      do 80 iyr=iyear-MXAGYR+1,iyear
c
c --- compute relative index -- backwards from absolute year loop ---
c
         idxyr = iyear - iyr + 1
c
c --- get the tech fractions for this year ---
c
         idxtch = fndtch(asccod,hpval,iyr)
         do 81 i=1,ntech(idxtch)
            tecnam(i) = tectyp(idxtch,i)
            tecfrc(i) = tchfrc(idxtch,i)
   81    continue
c
c   --- call routine to calculate the emission factors for this
c       equipment type ---
c
         call emfclc( jerr, emsfac, bsfc, idxunt, adetcf, bdetcf, 
     &                  detcap, asccod, tecnam, ntech(idxtch), tecfrc, 
     &                                              iyr, idxyr, icurec)
         if( jerr .NE. ISUCES ) goto 9999
   80 continue
c
c   --- call routine to calculate the adjustment factors for the
c       emission factors for this equipment type ---
c
      call emsadj( adjems, asccod )
c
c   --- loop over states and load some local arrays for each state ---
c
      do 90 idxsta=1,NSTATE
c
c  --- skip if this state is not requested or if doing national
c      record and state has specific records skip it ---
c
         if( .NOT. lstacd(idxsta) ) goto 90
         if( idxsta .LE. 0 .AND. lstlev(idxsta) ) goto 90
c
c  --- initialize daily emissions to zero ---
c
         do 11 i=1,MXPOL
           emsday(i) = 0.0
 11      continue
c
c  --- if population for this state is zero, just write a zero record 
c      and go to next state ---
c
         if( popsta(idxsta) .LE. 0 ) then
            call wrtdat(jerr,statcd(idxsta),subcur,asccod,hplev,0.,
     &                                                  0.,0.,emsday)
            if( jerr .NE. ISUCES ) goto 9999
            goto 90
         endif
c
c   --- call routine to get the monthly, daily, and hourly adjustment ---
c
         tplfac(idxsta) = dailyf( ndays, asccod, statcd(idxsta) )
c
c   --- call the routine to find the growth factor indicator in the
c       cross reference arrays ----
c
         idxgrw(idxsta) = 0
         if( iyear .NE. ipopyr(icurec) ) then
            if( .NOT. lgrwfl ) goto 7003
            idxgrw(idxsta) = 
     &             fndgxf( statcd(idxsta), asccod, avghpc(icurec) )
            if( idxgrw(idxsta) .LE. 0 ) goto 7001
         endif
c
c   --- loop over technology types, looking for activity data ---
c
         do 21 i=1,ntech(idxtch)
c
c  --- set the maximum on the tank volume ----
c
            tank(i) = MIN( tnkvol(idxact(i,idxsta))*hpval, TNKMAX )
c
c   --- call routine to get the growth factor data from the file 
c       only if the indicator data has changed ---
c
            if( idxgrw(idxsta) .GT. 0 ) then
                if( indgrx(idxgrw(idxsta)) .NE. indcur ) then
                   call getgrw( jerr, indgrx(idxgrw(idxsta)) ) 
                   if( jerr .NE. ISUCES ) goto 9999
                   indcur = indgrx(idxgrw(idxsta))
c
c --- compute the growth factor for this state --- (2/5/96)
c
                  call grwfac( jerr, grwtmp,
     $                 ipopyr(icurec), iyear, statcd(idxsta), indcur )
                  if( jerr .NE. ISUCES ) goto 9999
              endif
              grwsta(idxsta) = grwtmp
            endif
c
c  --- call routine to calculate the model year distribution fractions ----
c
            call modyr( modfrc, modscp, stradj, actadj, nyrlif, 
     &         detage, usehrs(icurec), discod(icurec),
     &           starts(idxact(i,idxsta)), actlev(idxact(i,idxsta)), 
     &              iactun(idxact(i,idxsta)),faclod(idxact(i,idxsta)))
c
c  --- call routine to calculate the grown populations and model
c      year populations and recalculate model year distribution
c      fractions (modfrc) to incorporate growth ----
c
            call grwclc( modpop, modfrc, modscp, nyrlif, grwsta(idxsta),
     &                          ipopyr(icurec), iyear, popeqp(icurec))
c
c  --- call routine to get the refueling mode for this SCC and tech type ---
c
         if ( lfacfl(IDXSPL) ) then
            idxall = fndrfm( asccod, hpval, tank(i), TECDEF )
            idxref = fndrfm( asccod, hpval, tank(i), tecnam(i) )
            if ( idxref .EQ. 0 )  idxref = idxall
            if ( idxref .GT. 0 )  then
               rfmode(i) = modspl(idxref)
            else
c
c   --- no data was found, write a warning message ----
c
               rfmode(i) = '         '
               write(IOWMSG,'(/,1X,2A,F6.1,1X,A)',ERR=9999) 
     &               'WARNING:  No Spillage data found for: ',
     &              asccod, hpval, tecnam(i)
               call chkwrn(jerr,IDXWEM)
               if( jerr .NE. ISUCES ) goto 9999
            endif
         endif
c
   21    continue 
c
c  --- set population, activity and starts totals to zero
c
         poptot = 0.0
         acttot = 0.0
         strtot = 0.0  
         fulcsm = 0.0  
c            
c  --- loop over years ----
c
         do 31 iyr=iyear-MXAGYR+1,iyear
c
c --- compute relative index -- backwards from absolute year loop ---
c
            idxyr = iyear - iyr + 1
c
c  --- skip it the model year fraction is zero (sometimes happens for
c      the first year in the distribution)
c
            if( modfrc(idxyr) .LE. 0.0 ) goto 31
c
c  --- call routine to find the technology index for this
c      piece of equipment ---
c
            idxtch = fndtch(asccod,hpval,iyr)
c
c   --- call routine to calculate the emission factors for this
c       equipment type ---
c
            do 41 i=1,ntech(idxtch)
               tecnam(i) = tectyp(idxtch,i)
               tecfrc(i) = tchfrc(idxtch,i)
   41       continue
c
c   ---- loop over technology types ---
c
            do 51 i=1,ntech(idxtch)
c
c   ---- skip over unused technology types
c
               if( tchfrc(idxtch,i) .LE. 0. ) goto 51
c
c   --- set the local variable for temporal adjustment factor ---
c
               if( iactun(idxact(i,idxsta)) .EQ. IDXHRY .OR.
     &                iactun(idxact(i,idxsta)) .EQ. IDXGLY ) then
                   tpltmp = tplfac(idxsta)
               else if( iactun(idxact(i,idxsta)) .EQ. IDXHRD .OR.
     &                iactun(idxact(i,idxsta)) .EQ. IDXGLD ) then
                   tpltmp = 1.0
               endif
c
c   --- calculate fuel consumption ---
c
               thisfc = tpltmp * popsta(idxsta) * 
     &          actadj(idxyr) * modfrc(idxyr) * tchfrc(idxtch,i) *
     &                 (hpval * faclod(idxact(i,idxsta)) * 
     &                                       bsfc(idxyr,i) / denful )
               fulcsm = fulcsm + thisfc
c
c  --- fill emissions arrays ---
c
              call clcems (emsday, emsbmy,
     &            idxyr, i, idxtch, detage(idxyr), detcap,
     &            adetcf, bdetcf, idxunt, tecfrc(i), hpval, denful,
     &            bsfc(idxyr,i), idxact(i,idxsta), adjems, emsfac, 
     &            tpltmp, stradj(idxyr), popsta(idxsta), modfrc(idxyr),
     &            ndays, tank(i), actadj(idxyr), rfmode(i), thisfc )

c
c  --- calculate the contribution from this tech type ---
c
              popbmy = popsta(idxsta) * modfrc(idxyr) * tchfrc(idxtch,i)
              actbmy = actadj(idxyr) * popsta(idxsta) * modfrc(idxyr) *
     &                                         tpltmp * tchfrc(idxtch,i)
              fulbmy = tpltmp * popsta(idxsta) * 
     &          actadj(idxyr) * modfrc(idxyr) * tchfrc(idxtch,i) *
     &                 (hpval * faclod(idxact(i,idxsta)) * 
     &                                         bsfc(idxyr,i) / denful ) 
c
c  --- call routine to write by-model-year output ---
c
              if ( lbmyfl )  then
                  call wrtbmy(jerr,statcd(idxsta),subcur,asccod,hplev,
     &                                    tecnam(i),iyr,popbmy,emsbmy)
                  if( jerr .NE. ISUCES ) goto 9999
              endif
c
c  --- call routine to add to totals for SI report ---
c
              if( lsifl .AND. tecfrc(i) .GT. 0.) then
                  call sitot(jerr,tecnam(i),popbmy,actbmy,fulbmy,emsbmy)
                  if( jerr .NE. ISUCES .AND. jerr .NE. ISKIP ) goto 9999
              endif
c
c  --- next technology type ----
c
   51       continue
c
c --- sum population, activity and starts ---
c 
            poptot = poptot + popsta(idxsta) * modfrc(idxyr)  
            acttot = acttot + actadj(idxyr) * 
     &                 popsta(idxsta) * modfrc(idxyr) * tpltmp
            strtot = strtot + stradj(idxyr) * 
     &                      popsta(idxsta) * modfrc(idxyr) * tpltmp
c
c   --- next year ---
c
   31    continue
c
c************************************************************
c  NOTE:  Fix to alleviate somoe confusion about fuel 
c         consumption in the reports.  LPG and CNG fuel
c         consumption means something different.
c************************************************************
c
      if( ifuel .EQ. IDXLPG .OR. ifuel .EQ. IDXCNG ) fulcsm = 0.
c
c  --- call routine to write the output to the data file ---
c
         call wrtdat(jerr,statcd(idxsta),subcur,asccod,hplev,poptot,
     &                                             acttot,fulcsm,emsday)
         if( jerr .NE. ISUCES ) goto 9999
c
c   --- next state --
c
   90 continue
c
c  --- all counties processed, return to the calling routine ---
c
      ierr = ISUCES 
      goto 9999
c
c-----------------------------------------------------------------------
c    Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Could not find any ',
     &                'allocation coefficients for SCC code ',asccod
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Could not find any ',
     &                'allocation coefficients for SCC code ',asccod
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999) 'ERROR: Could not find ',
     &                 'match in growth indicator cross reference for: '
      write(IOWSTD,'(10X,A,/,10X,A5,3X,A10,6X,F6.1,2X,F6.1)',ERR=9999) 
     &      'County     SCC              HP range',
     &        statcd(idxsta), asccod,hprang(1,icurec),hprang(2,icurec)
      write(IOWMSG,'(/,1X,2A)',ERR=9999) 'ERROR: Could not find ',
     &                 'match in growth indicator cross reference for: '
      write(IOWMSG,'(10X,A,/,10X,A5,3X,A10,6X,F6.1,2X,F6.1)',ERR=9999) 
     &      'County     SCC              HP range',
     &        statcd(idxsta), asccod,hprang(1,icurec),hprang(2,icurec)
      goto 9999
c
 7003 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find the ',
     &                        '/GROWTH FILES/ packet of options file.'
      write(IOWSTD,'(9X,2A)',ERR=9999) 'This packet is required ',
     &                  'for future year projections or backcasting. '
      write(IOWMSG,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find the ',
     &                        '/GROWTH FILES/ packet of options file.'
      write(IOWMSG,'(9X,2A)',ERR=9999) 'This packet is required ',
     &                  'for future year projections or backcasting. '
      goto 9999
c
c-----------------------------------------------------------------------
c    Format statements:
c-----------------------------------------------------------------------
c
 9000 format(/,1X,A,/,10X,A,6X,A,8X,A,11X,A,/,10X,A,4X,A,4X,A10,2X,
     &       F6.1,1X,F6.1)
 9001 format(/,1X,2A,/,16X,A,8X,A,11X,A,/,14X,A,4X,A10,2X,F6.1,1X,F6.1)
 9002 format(10X,2A,F7.2,A)
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
