C**** INTNON
      subroutine intnon( ierr )
c
c-----------------------------------------------------------------------
c  
c   Subroutine to perform initializaton for the nonroad model.
c
c    Argument description:
c        Outputs:
c           ierr   I   error code
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      12/07/95  --djk--  original development
c      07/22/96  --jlf--  added reading of technology fractions
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdalo.inc'
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer*4    jerr
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c  --- set the error code ----
c
      ierr =  IFAIL
c      
c  --- call routine to read the /OPTIONS/ packet ----
c
      call rdnropt(jerr )
      if( jerr .NE. ISUCES ) goto 9999 
      call spinit()
c      
c  --- call routine to read the /PERIOD/ packet ----
c
      call rdnrper(jerr )
      if( jerr .NE. ISUCES ) goto 9999 
      call spinit()
c
c  --- call routine to read the /REGION/ packet ----
c
      call rdnrreg(jerr)
      if( jerr .NE. ISUCES ) goto 9999 
      call spinit()
c
c  --- call routine to read the /SOURCE CATEGORY/ packet ----
c
      call rdnrsrc(jerr)
      if( jerr .NE. ISUCES ) goto 9999 
      call spinit()
c
c  --- call routine to open the emission factor files ---
c
      call opnefc( jerr ) 
      if( jerr .NE. ISUCES ) goto 9999
c
c  --- call routine to read the spatial allocation coefficients ---
c
      call rdalo(jerr)
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to read the spatial indicator data and
c      create the sorted file ---
c
      call rdind( jerr )
      if( jerr .EQ. IEOF ) goto 7001
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to read the growth indicator data and create
c      the sorted growth indicator file ---
c
      call rdgrow( jerr )
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to read the /STAGE II/ packet ----
c
      call rdstg2(jerr)
      if( jerr .NE. ISUCES ) goto 9999 
      call spinit()
c
c  --- call routine to echo the inputs to message file --- 
c
      call wrtmsg( jerr )
      if( jerr .NE. ISUCES ) goto 9999
c
c  --- call routine to read the regions definition file ----
c
      call rdrgndf(jerr)
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to read the activity data ---
c
      call rdact( jerr )
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to read all of the population data and create the
c      sorted file ----
c
      call rdpop(jerr)
      if( jerr .EQ. IEOF ) goto 7000
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to read the emission factor files ---
c
      call rdefls( jerr ) 
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to read the BSFC file ---
c
      call rdbsfc( jerr ) 
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to read the seasonality files ----
c
      call rdseas( jerr )
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to read the technology fraction file ----
c
      call rdtech( jerr )
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- call routine to initialize the adjustment factor variables ---
c
      call intadj()
      if( jerr .NE. ISUCES ) goto 9999
      call spinit()
c
c  --- set error code and return successuflly ---
c
      ierr = ISUCES 
      goto 9999
c
c-----------------------------------------------------------------------
c    Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,2A,/,1X,A)',ERR=9999) 'ERROR:  Could not ',
     &            'find any population data for the regions ',
     &                      '        and equipment types requested.'
      write(IOWSTD,'(9X,A,/9X,A)',ERR=9999) 
     &            'Make sure the population files are for the region',
     &            'specified in the /REGION/ packet.'
      write(IOWMSG,'(/,1X,2A,/,1X,A)',ERR=9999) 'ERROR:  Could not ',
     &            'find any population data for the regions ',
     &                      '        and equipment types requested.'
      write(IOWMSG,'(9X,A,/9X,A)',ERR=9999) 
     &            'Make sure the population files are for the region',
     &            'specified in the /REGION/ packet.'
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Could not find any ',
     &             'spatial allocation indicator data for the regions ',
     &                                  'and equipment types requested.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Could not find any ',
     &             'spatial allocation indicator data for the regions ',
     &                                  'and equipment types requested.'
      goto 9999
c
c-----------------------------------------------------------------------
c    Format statements:
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
