C**** HDRBMY
c
      subroutine hdrbmy( ierr )
c
c-----------------------------------------------------------------------
c
c    writes header record to the output by-model-year data file
c
c    Argument description:
c     Outputs:
c       ierr    I  error flag
c     Inputs:
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      08/06/98  --gwilson--  original development (started w/wrthdr)
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4    ierr
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local parameters:
c-----------------------------------------------------------------------
c
c  COMMA   C   parameter for the comma character
c
      character*1 COMMA
c
      parameter( COMMA = ',' )
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*400 line
      character*15  name(10), namesp(MXPOL)
      integer*4     ilen, i
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      line = ' '
c
c  --- write the lines with first set of labels ---
c
      name(1) = 'Cnty'
      name(2) = 'SubR'
      name(3) = 'SCC'
      name(4) = 'HP'
      name(5) = 'Tech Type'
      name(6) = 'Year'
      name(7) = 'Population'
      write(line,9000,ERR=7000) (name(i),COMMA,i=1,7)
c
c  --- write the lines with first set of labels ---
c
      namesp(IDXTHC) = 'THC-Exhaust'
      namesp(IDXCO)  = 'CO-Exhaust'
      namesp(IDXNOX) = 'NOx-Exhaust'
      namesp(IDXCO2) = 'CO2-Exhaust'
      namesp(IDXSOX) = 'SOx-Exhaust'
      namesp(IDXPM)  = 'PM-Exhaust'
      namesp(IDXCRA) = 'Crankcase'
      namesp(IDXSOK) = 'Hot-Soaks'
      namesp(IDXDIU) = 'Diurnal'
      namesp(IDXDIS) = 'Refueling'
      namesp(IDXSPL) = 'Spillage'
      namesp(IDXRLS) = 'RuningLoss'
      namesp(IDXRST) = 'RestngLoss'
      namesp(IDSTHC) = 'THC-Starts'
      namesp(IDSNOX) = 'NOx-Starts'
      namesp(IDSCO)  = 'CO-Starts'
      namesp(IDSPM)  = 'PM-Starts'
      namesp(IDSSOX) = 'SOx-Starts'
      namesp(IDSCO2) = 'CO2-Starts'
      ilen = strmin( line ) + 1
      write(line(ilen:),'(100(:,A))',ERR=7000) 
     &                            (namesp(i),COMMA,i=IDXTHC,IDXRST)
c
c   --- write the record to the output file ---
c
      write(IOWBMY,'(A)',ERR=7000) line(:strmin(line))
c
c   --- set error code to succes and return ----
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)') 
     &                 'ERROR:  Writing to the by-model-year file ',
     &                                           bmyfl(:strmin(bmyfl))
      write(IOWMSG,'(/,1X,3A)') 
     &                 'ERROR:  Writing to the by-model-year file ',
     &                                           bmyfl(:strmin(bmyfl))
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format(A5,A,A5,A,A10,A,A5,A,A10,A,A4,A,A15,A)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
