C**** GRWFAC  
c
      subroutine grwfac( ierr, factor, ipopyr, iepyr, infips, indcod ) 
c
c-----------------------------------------------------------------------------
c
c   subroutine to compute the growth factor from the current indicator 
c   data
c   
c     Argument declaration
c       Outputs:
c             ierr    I  error indicator flag
c             factor  R  the growth factor based on the current indicator
c       Inputs:
c             ipopyr  I  the base population year
c             iepyr   I  the episode year 
c             infips  I  FIPS code
c             indcod  C  indicator code
c
c-----------------------------------------------------------------------------
c  LOG:
c-----------------------------------------------------------------------------
c
c        12-05-95  -djk-  Original Development
c        07-16-96  -gwl-  Rewritten
c        06/09/97  -gwilson- Now writes error if no data available.
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdgrw.inc'
      include 'nonrdreg.inc'
c
c------------------------------------------------------------------------
c  Argument declarations:
c------------------------------------------------------------------------
c
      integer*4    ierr
      integer*4    ipopyr
      integer*4    iepyr
      real*4       factor
      character*5  infips
      character*4  indcod
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c
c------------------------------------------------------------------------
c  Local variables:
c------------------------------------------------------------------------
c
      character*5 stfips
      integer*4   i, ilo, ihi, ibeg, iend
      real*4      ratio
      logical*4   lzerohi
c
c------------------------------------------------------------------------
c  Entry point:
c------------------------------------------------------------------------
c     
c --- default growth is no growth ---
c
      ierr = IFAIL
      factor = 0.0
c
c --- if episode year equals base year, then no growth ---
c
      if( iepyr .EQ. ipopyr ) then
         ierr = ISUCES
         goto 9999      
      endif
c
c --- zero indicator year indecies ---
c
      ibeg = 0
      iend = 0
c                             
c --- loop over the indicator fips searching for national, state,
c     or county match (note--fipgrw is sorted by fips code) ---
c
      stfips = infips(1:2)//'000'
c                                        
      do 10 i=1,nrcgrw
         if( fipgrw(i) .EQ. '00000') iend = i
         if( fipgrw(i) .EQ. stfips) iend = i
         if( fipgrw(i) .EQ. infips) iend = i
   10 continue      
c         
c --- if there is no match, use default growth ---
c
      if( iend .EQ. 0 ) goto 7000
c  
c --- backup to the first occurrance ---
c
      ibeg = 1
      do 20 i=iend-1,1,-1
         if( fipgrw(i) .NE. fipgrw(iend) ) then
            ibeg = i + 1 
            goto 111
         endif
   20 continue
c
c --- if ibeg equals iend then only one indicator,
c     we need two years for equation, so write error and return ---
c
  111 continue
      if( ibeg .EQ. iend .OR. iyrgrw(ibeg) .EQ. iyrgrw(iend) ) goto 7000
c
c --- use the closest indicator range if both base and episode years
c     are below or above the range of indicator years ---
c
      ilo = ibeg
      ihi = iend
      if( ipopyr .LE. iyrgrw(ibeg) .AND. 
     &                            iepyr .LE. iyrgrw(ibeg) ) then
           ihi = ilo + 1
           goto 222
      endif
      if( ipopyr .GE. iyrgrw(iend) .AND. 
     &                            iepyr .GE. iyrgrw(iend) ) then
           ilo = ihi - 1
           goto 222
       endif
c
c --- else find min/max years spanning base year and episode year      
c     (this code assumes iyrgrw has been sorted on fips and year)
c
      lzerohi = .FALSE.
      do 30 i=ibeg+1,iend
         if( iepyr .GT. iyrgrw(i) .AND. 
     &                   valgrw(i) .EQ. 0. .AND. .NOT. lzerohi ) then
             lzerohi = .TRUE.
             ihi = i
         endif
c
c --- unlikely but possible that episode year is less than base year ---
c              
         if( iepyr .GT. ipopyr ) then
            if( ipopyr .GE. iyrgrw(i) ) then
               ilo = i
            endif   
            if( iepyr .LE. iyrgrw(i) .AND. iepyr .GT. iyrgrw(i-1) ) then
               if( valgrw(i) .NE. 0. ) then
                   ihi = i
               else
                  if( .NOT. lzerohi ) then
                      ihi = i
                      lzerohi = .TRUE.
                  endif
               endif
            endif   
         else   
            if (iepyr .GE. iyrgrw(i) ) then
               ilo = i
            endif   
            if (ipopyr .LE. iyrgrw(i) 
     &                       .AND. ipopyr .LT. iyrgrw(i-1) ) then
               if( valgrw(i) .NE. 0 ) then
                   ihi = i
               else
                  if( .NOT. lzerohi ) then
                      ihi = i
                      lzerohi = .TRUE.
                  endif
               endif
            endif   
         endif   
   30 continue  
c
c --- solve for the slope and intercept for this line ----
c     
  222 continue
      if( iyrgrw(ihi) .NE. iyrgrw(ilo) .AND. valgrw(ilo) .NE. 0.) then
          factor = (valgrw(ihi)-valgrw(ilo)) / 
     &               ((iyrgrw(ihi)-iyrgrw(ilo)) * valgrw(ilo) )
      endif
c
c  --- set error code to sucess and return ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find any ',
     &                                        'valid growth data for '
      write(IOWSTD,9000,ERR=9999) 'County','Year','Indicator Code',
     &                                            infips, iepyr, indcod
      write(IOWMSG,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find any ',
     &                                        'valid growth data for '
      write(IOWMSG,9000,ERR=9999) 'County','Year','Indicator Code',
     &                                            infips, iepyr, indcod
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format(10X,A6,3X,A4,3X,A,/,10X,A5,4X,I4,10X,A4)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999  continue
       return
       end
