C     Last change:  GK    9 Oct 1998    9:34 am
C**** FNDFHP
c
      function fndfhp(ascin,clsin,clstp)
      integer*4 fndfhp
c
c-----------------------------------------------------------------------
c
c    This function returns the index of the specified combination of
c    source code classification, class, and class type("HP" or "DWT").
c
c    Return value:
c         > 0   =  index in array of best match
c         = 0   =  no match found
c
c    Arguments:
c
c     Inputs: 
c       ascin      C   SCC code to match
c       clsin      I   size class to match
c       clstp      C   class type code to match
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/27/98   --  gfkohlbach, based loosely on fnd*
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdeqp.inc'
      include 'nonrdefc.inc'
      include 'nonrdcmr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      character*10  ascin
      integer*4     clsin
      character*5   clstp
c-----------------------------------------------------------------------
c    Local parameters:
c-----------------------------------------------------------------------
c
c   MXGLB   I  number of codes for global matches
c
      integer*4 MXGLB
c
      parameter( MXGLB = 4 )
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*10  ascglb(MXGLB)
      character*10  ascmtc
      integer*4     idxfhp, idxtmp, j, mtchlv
      integer*4     idxglb(2)
      character*5   cmptp
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- assume no match ----
c
      idxtmp = 0
      mtchlv = 9
c
c   ---- set up the global matches ----
c
      ascglb(1) = ascin
      ascglb(2) = ascin(1:7)//'000'
      ascglb(3) = ascin(1:4)//'000000'
      ascglb(4) = ascin(1:2)//'00000000'
c
c   ---- set class type to match to upper case and left set
c
      call low2up( clstp )
      call lftjst( clstp )
c
c   ---- loop over all entries in the arrays ----
c
      do 10 idxfhp=1,nfhprc
c
c   ---- skip if not correct size class  ---
c
         if( clsin .NE. fhpcls(idxfhp) ) goto 10
c
c   ---- skip if not correct class type ---
c
         cmptp=fhptyp(idxfhp)
         call low2up( cmptp )
         call lftjst( cmptp )
         if ( clstp .NE. cmptp ) goto 10
c
c   ---- if exact SCC match, set return value and return right away
c        since we already know the size class and size type are also
c        exact matches
c
         ascmtc = fhpscc(idxfhp)
         if( ascin .EQ. ascmtc ) then
             idxtmp = idxfhp
             mtchlv = 0
             goto 10
         endif
c
c   --- check the global matches and set the local index array ---
c
         do 20 j=1,2
            if( fhpscc(idxfhp) .EQ. ascglb(j) ) then
	        idxglb(j) = idxfhp
            else
                idxglb(j) = 0
            endif
   20    continue
c
c   ---- find the best match, loop backwards through 
c        found-match array ---
c
      do 30 j=2,1,-1
         if( idxglb(j) .GT. 0 ) then
            if (mtchlv .GT. j) then
               mtchlv=j
               idxtmp = idxglb(j)
               ascmtc = fhpscc(idxtmp)
            end if
         endif
  30  continue
c
c   --- get the next array element ----
c
   10 continue
c
c   --- set return code
c
      fndfhp=idxtmp
c
c   ---- return to calling routine ----
c
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 9001 format(1X,2A,I4,A,I3,A,I4,A)
 8002 format(A132)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
