c**** DAILYF
c
      real*4 function dailyf(ndays, asccod, fipin)
c
c-----------------------------------------------------------------------
c
c    calculates daily factor adjustments for a specified engine type
c    The return value is a single factor to convert the annual emissions
c    estimate the to period requested by the user.
c
c    Arguments:
c      Outputs:
c        ndays   I  number of days spanned by interval (used for 
c                   diurnal emissions caclulations)
c      Inputs:
c        asccod  C  SCC code to match
c        fipin   C  FIPs code to match
c
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      06/19/96  --gwl-- lifted from main program
c      07/20/96  --jlf-- added calculation of overall month/day/hour
c                        adjustment
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdreg.inc'
      include 'nonrdusr.inc'
      include 'nonrdefc.inc'
      include 'nonrdeqp.inc'
      include 'nonrdtpl.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4    ndays
      character*10 asccod
      character*5  fipin
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------

      integer*4 idxtpd, idxtpm, modays(2,12), ileap, jleap, ipt, i
      real*4    mthf, dayf, mthin(MXMTH), dayin(MXDAY)
c
c-----------------------------------------------------------------------
c   Data statements:
c-----------------------------------------------------------------------
c
      data modays /31, 31, 28, 29, 31, 31, 30, 30, 31, 31, 30, 30,
     &             31, 31, 31, 31, 30, 30, 31, 31, 30, 30, 31, 31/
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   ----- determine if it is leap year -----
c
      ileap = MOD(iepyr,4)
      jleap = MOD(iepyr,1000)
      if( ileap .EQ. 0 .AND. jleap .NE. 0 ) then
         ipt = 2
      else
         ipt = 1
      endif
c
c   --- call routine to get the monthly and daily seasonality data ---
c
      dailyf = -9.
      call fndtpm( asccod, fipin, idxtpm, idxtpd )
c
c  --- if match found for day-of-week, load the values ---
c
      if( idxtpd .GT. 0 ) then
         do 10 i=1,MXDAY
            dayin(i) = dayfac(i,idxtpd)
   10    continue
c
c  --- otherwise load the defaults ---
c
      else
         do 20 i=1,MXDAY
            dayin(i) = defday(i)
   20    continue
      endif
c
c  --- if match found for month of year, load the values ---
c
      if( idxtpm .GT. 0 ) then
         do 30 i=1,MXMTH
            mthin(i) = mthfac(i,idxtpm)
   30    continue
c
c  --- otherwise load the defaults ---
c
      else
         do 40 i=1,MXMTH
            mthin(i) = defmth(i)
   40    continue
      endif
c
c  --- loop over months and add the monthly factors ---
c
      mthf = 0.
      ndays = 0
      do 50 i=1,MXMTH
        if( lmonth(i) ) then
            mthf = mthf + mthin(i) 
            ndays = ndays + modays(ipt,i)
         endif
   50 continue
c
c  --- if doing a daily inventory, divide by number of days to get an
c      average day for this period ----
c
      if( ismtyp .EQ. IDXTYP .AND. ndays .GT. 0 ) 
     &                                mthf = mthf / FLOAT(ndays)
c
c  --- if the period is not daily, the day-of-week adjustment is 1.0 ---
c
      if( ismtyp .EQ. IDXTOT ) then
          dayf = 1.0
      else
c
c  --- if the period is daily, multiply by 7 to get a weeks worth and 
c      then apply the day of week factor ---
c
          ndays = 1
          dayf = 0.
          if( ldays(IDXWKD) ) then 
             dayf = dayin(IDXWKD)
          else
             dayf = dayin(IDXWKE)
          endif
          dayf = 7 * dayf
      endif
c
c  --- calculate the combined factor and return ---
c
      dailyf = dayf * mthf
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
