c**** CLCEMS
c
      subroutine clcems(emsday, emsbmy,
     &             idxyr, idxtec, idxtch, dage, detcap, adetcf, bdetcf,
     &             idxunt, tfrac, hpval, denful, bsfval, iact, adjems,
     &             emsfac, tpltmp, sadj, pop, mfrac, ndays, tvol, afac,
     &             refmod, fulcsm )
c
c-----------------------------------------------------------------------
c  
c   This routine calculates emissions
c      Argument descriptions:
c        Outputs:
c          emsday  R   calculated emissions
c          emsbmy  R   calculated emissions by-model-year
c        Inputs:
c          idxyr   I   year index
c          idxtec  I   technology type index
c          idxtch  I   number of technology types 
c          dage    R   age of deterioration
c          detcap  R   cap on age of equip for deterioration calc
c          adetcf  R   A coefficient of deterioration factor equation
c          bdetcf  R   B coefficient of deterioration factor equation
c          idxunt  I   index of unit conversion
c          tfrac   R   technology type fraction
c          hpval   R   horsepower
c          denful  R   fuel density
c          bsfval  R   bsfc value
c          iact    I   activity index
c          adjems  R   adjustment factors
c          emsfac  R   emission factors
c          sadj    R   starts hour
c          tpltmp  R   temporal adjustment factor
c          pop     R   population
c          mfrac   R   model year fraction
c          ndays   I   number of period days
c          tvol    R   tank volume
c          afac    R   activity adjustment
c          refmod  C   refueling mode
c          fulcsm  R   fuel consumption
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/8/98  --mmj-- taken from the process routines 'prcxxx'
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdeqp.inc'
      include 'nonrdact.inc'
      include 'nonrdusr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      real*4      emsday(MXPOL)
      real*4      emsbmy(MXPOL)
c
      character*9 refmod
      integer*4   idxyr
      integer*4   idxtec
      integer*4   idxtch
      integer*4   idxunt(MXPOL,MXTECH)
      integer*4   iact
      integer*4   ndays
      real*4      dage
      real*4      detcap(MXPOL,MXTECH)
      real*4      adetcf(MXPOL,MXTECH)
      real*4      bdetcf(MXPOL,MXTECH)
      real*4      tfrac
      real*4      hpval
      real*4      denful
      real*4      bsfval
      real*4      adjems(MXPOL)
      real*4      emsfac(MXAGYR,MXPOL,MXTECH)
      real*4      sadj
      real*4      tpltmp
      real*4      pop
      real*4      mfrac
      real*4      tvol
      real*4      afac
      real*4      fulcsm
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   unitcf   R   returns unit conversion factor
c
      real*4    unitcf
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer*4    idxspc
      real*4       modscp(MXAGYR)
      real*4       cvtbck, tempds
      real*4       detrat, emstmp,  emiss, cvttmp, emsthc
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c --- calculate emissions for each pollutant ---
c
       do 90 idxspc=1,MXPOL
c
c  --- spillage emissions are a function of tank volume  ---
c  --- different for container or gas pump (gas only)    ---
c
          if( idxspc .EQ. IDXSPL )  then
             if ( lfacfl(IDXSPL) .AND. refmod .NE. '         ' ) then
                if ( ifuel .EQ. IDXGS2 .OR. ifuel .EQ. IDXGS4 )  then
                   if( refmod .EQ. PUMP ) then
                     emiss = PMPFAC / tvol
                   elseif ( refmod .EQ. CNTR )  then
                     emiss = CNTFAC / tvol
                   endif
                else
                   emiss = 0.0
                endif
                emsday(idxspc) = emsday(idxspc) 
     &                           + emiss * CVTTON * fulcsm
                emsbmy(idxspc) = emiss * CVTTON * fulcsm
             else
                emsday(idxspc) = RMISS
                emsbmy(idxspc) = RMISS
             endif
             goto 90
          endif
c
c  ---- vapor displacement emissions are a function of ambient temp and RVP ---
c  ---  different for container or gas pump (gas only)                      ---
c
          if( idxspc .EQ. IDXDIS )  then
             if ( lfacfl(IDXSPL) .AND. refmod .NE. '         ' ) then
                if ( ifuel .EQ. IDXGS2 .OR. ifuel .EQ. IDXGS4 )  then
                   if( refmod .EQ. PUMP ) then
                     tempds =  62 + 0.6 * (amtemp - 62.)
                   elseif (refmod .EQ. CNTR )  then
                     tempds = amtemp
                   endif
                   emiss =  -5.909 - 0.0949 * (amtemp - tempds) 
     &                       + 0.0884 * tempds + 0.485 * fulrvp
                else
                   emiss = 0.0
                endif
                emsday(idxspc) = emsday(idxspc) 
     &                          + emiss * CVTTON * fulcsm * stg2fac
                emsbmy(idxspc) = emiss * CVTTON * fulcsm * stg2fac
             else
                emsday(idxspc) = RMISS
                emsbmy(idxspc) = RMISS
             endif
             goto 90
          endif
c
c  --- calculate the detrioration rate from values retrieved earlier ----
c
          if( dage .LE. detcap(idxspc,idxtec) ) then
              detrat = 1. + adetcf(idxspc,idxtec) * 
     &                         dage**bdetcf(idxspc,idxtec)
          else
              detrat = 1. + adetcf(idxspc,idxtec)
          endif
c
c  --- call routine to get the units converion for this species ---
c
          cvttmp = unitcf( idxunt(idxspc,idxtec),hpval,iact,
     &                                    denful,bsfval )
          emstmp = emsfac(idxyr,idxspc,idxtec) * cvttmp * detrat * 
     &                                                  adjems(idxspc)
c
c   --- save the THC exhaust emission factor for use later ---
c
          if( idxspc .EQ. IDXTHC ) emsthc = 
     &                emsfac(idxyr,idxspc,idxtec) * cvttmp * detrat
c
c   --- calculate the SOx emissions from the HC emission factor ---
c
          if( idxspc .EQ. IDXSOX .AND. tfrac .GT. 0. ) then
              cvtbck = 1.0 / (hpval * faclod(iact) )
              if( ifuel .EQ. IDXDSL ) then
                  emsfac(idxyr,idxspc,idxtec) = 
     &                hpval * ( bsfval * 
     &                453.6 * (1.0 - 0.022) - emsthc*cvtbck ) * 
     &                0.0033 * 2.0
              else
                  emsfac(idxyr,idxspc,idxtec) = 
     &                hpval * ( bsfval * 
     &                453.6 -  emsthc*cvtbck ) * 0.00034 * 2.0
              endif
              emstmp = emsfac(idxyr,idxspc,idxtec) * adjems(idxspc)
          endif
c
c  --- calculate the Crankcase emission factor from HC emission factor ----
c
          if( idxspc .EQ. IDXCRA .AND. tfrac .GT. 0 
     &                  .AND. emsfac(idxyr,IDXTHC,idxtec) .GT. 0.0 
     &                      .AND. emsfac(idxyr,IDXCRA,idxtec) .GT. 0.0 )
     &          emstmp = emsfac(idxyr,idxspc,idxtec) * emsthc
c
c  --- special case for CO2, CO2 emissions are just a function of BSFC ---
c
          if( idxspc .EQ. IDXCO2 ) then
              if( tfrac .GT. 0 ) then
                  emsfac(idxyr,idxspc,idxtec) =  hpval * 
     &                      faclod(iact) * bsfval * 
     &                      453.6 * 0.87 * 44./12.
                  emstmp = emsfac(idxyr,idxspc,idxtec) * detrat
              endif
          endif 
c
c  --- Correction for sulfur content to PM, need to wait until
c      now because the correction factor uses BSFC which is by
c      technology type ---
c
          if( idxspc .EQ. IDXPM .AND. ifuel .EQ. IDXDSL ) then
               emstmp = emstmp - bsfval * 453.6 * 
     &                                0.157 * (0.0033 - soxdsl)
          endif
c
c  ---- Hot soak and starts depend on number of starts ---
c
          if( idxspc .EQ. IDXSOK .OR. idxspc .GE. IDSTHC) then
             emiss = emstmp * sadj * 
     &            tpltmp * pop * mfrac * tchfrc(idxtch,idxtec)
c
c  ---- diurnal emissions are different ---
c
          else if( idxspc .EQ. IDXDIU ) then
             if( idxunt(idxspc,idxtec) .EQ. IDXTNK ) then
                emiss = emstmp * ndays * tvol * 
     &              pop * mfrac * tchfrc(idxtch,idxtec)
             else if( idxunt(idxspc,idxtec) .EQ. IDXGDY ) then
                emiss = emstmp * ndays * 
     &              pop * mfrac * tchfrc(idxtch,idxtec)
             else
                emiss = emstmp * afac * tpltmp *
     &              pop * mfrac * tchfrc(idxtch,idxtec)
             endif
c
c  ---- "normal" exhaust species ---
c
          else
             if( idxunt(idxspc,idxtec) .EQ. IDXGDY ) then
                 emiss = emstmp * ndays * tpltmp *
     &               pop * mfrac * tchfrc(idxtch,idxtec)
             else
                 emiss = emstmp * afac * tpltmp *
     &               pop * mfrac * tchfrc(idxtch,idxtec)
             endif
          endif
c
          if( emsfac(idxyr,idxspc,idxtec) .LT. 0.
     &                         .OR. emsday(idxspc) .LT. 0.0 ) then
              emsday(idxspc) = RMISS
              emsbmy(idxspc) = RMISS
          else
              emsday(idxspc) = emsday(idxspc) + emiss * CVTTON
              emsbmy(idxspc) = emiss * CVTTON
          endif
c
   90  continue
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
