C     Last change:  GK   25 Sep 1998    2:00 pm
C**** RMEXHSLO
c
      subroutine rmexhslo( ierr )
c
c-----------------------------------------------------------------------
c
c    reads MARINE exhaust slow emissions packet
c    during execution of the commercial marine module of the NONROAD program.
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/22/97  --gkohlbach-- cloned from rmexhcru.for for the marine model
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdcmr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4     ierr
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin  I   returns the actual length of a string (min of 1)
c   fndchr  I   returns the index of string in array of strings
c   fndkey
c
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*(4*MXSTR) line
      character*20        keywrd, keyin
      integer*4           irec, jerr
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 0
c
c   --- call routine to find the /EXHAUST SLOW/ packet ----
c
      keywrd = '/EXHAUST SLOW/'
      call fndkey( jerr, IOREMS, keywrd )
      if( jerr .NE. ISUCES ) then
          ierr = IFAIL
          goto 9999
      endif
c
c   --- read a record as a character string --- 
c
  111 continue
      read(IOREMS,8002,ERR=7000,END=7000) line
      call mspinit()
c
c   --- check for the end keyword ---
c
      keyin = line(1:10)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 222
c
c   --- not the end so increment record count
c
      irec = irec + 1
c
c   --- parse the line
c    +- read SCC
c
      sloscc(irec) = line(1:10)
      call lftjst( sloscc(irec) )
      call low2up( sloscc(irec) )
c
c    +- read size class group
c
      read(line(11:18),'(I7)',ERR=7001) slocls(irec)
c
c    +- read class type
c
      slotyp(irec) = line(18:27)
      call lftjst( slotyp(irec) )
      call low2up( slotyp(irec) )
c
c    +- read units
c
      slouni(irec) = line(29:38)
      call lftjst( slouni(irec) )
      call low2up( slouni(irec) )
c
c    +- read hydrocarbon
c
      read(line(39:46),'(F8.0)',ERR=7001) slohc(irec)
c
c    +- read carbon monoxide
c
      read(line(47:54),'(F8.0)',ERR=7001) sloco(irec)
c
c    +- read oxides of nitrogen
c
      read(line(55:62),'(F8.0)',ERR=7001) slonox(irec)
c
c    +- read oxides of sulfur
c
      read(line(63:70),'(F8.0)',ERR=7001) slosox(irec)
c
c    +- read particulate matter
c
      read(line(71:78),'(F8.0)',ERR=7001) slopm(irec)
c
c   --- get the next record ---
c
      goto 111
c
c   --- finished reading file ---
c
  222 continue
      ierr = ISUCES
      nslorc= irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot open ',
     &           emfcfl, ', the marine emission factors file.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot open ',
     &           emfcfl, ', the marine emission factors file.'
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading /EXHAUST SLOW/ packet. ',
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading /EXHAUST SLOW/ packet. ',
     &                               'Line read: ',line(:strmin(line))
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 8001 format(20(:,F10.0))
 8002 format(A132)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end

