C     Last change:  GK    2 Oct 1998    1:15 pm
      subroutine rdmscxwk(ierr)
c
c-----------------------------------------------------------------------
c     Initializes the internal to external SCC crosswalk arrays.
c     These arrays are used to supply the correct SCC to write to the
c     output file rather than the more stratified SCCs used internally.
c
c     Each internal SCC occupies a position in the array mscin while
c     corresponding external SCCs occupy the same ordinal position in
c     the array mscout.
c
c     Since the arrays have the same ordering, the method for selecting
c     the correct reporting (external)  SCC for an analysis (internal)
c     SCC is to use the fndasc function to locate the index position of
c     the best match for the analysis SCC.
c
c     The analysis SCCs are considerably more stratified so calculation 
c     of emissions employs the more detailed information while reporting
c     is aggregated at the basic marine scc level.
c
c-----------------------------------------------------------------------
c   LOG:
c-----------------------------------------------------------------------
c
c     09/27/1998 -gkohlbach-  Original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdcmr.inc'
      include 'nonrdreg.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c
      integer*4     ierr
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin  I   returns the actual length of a string (min of 1)
c   fndchr  I   returns the index of a string in an array of strings
c
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*(4*MXSTR) line
      character*20        keywrd, keyin
      character*10        intscc
      character*10        extscc
      integer*4           irec, jerr
      logical*4           lcheck
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 0
c
c   --- open the marine SCC crosswalk data file.
c
      open(IORXWK,file=mscxwk,ERR=7002,status='UNKNOWN')
      inquire(file=mscxwk,exist=lcheck)
      if( .NOT. lcheck ) goto 7001
c
c   --- call routine to find the /MARINE SCC CROSSWALK/ packet ----
c
      keywrd = '/MARINE CROSSWALK/'
      call fndkey( jerr, IORXWK, keywrd )
      if( jerr .NE. ISUCES ) then
          goto 9999
      endif
c
c   --- read a record as a character string --- 
c
  111 continue
      read(IORXWK,8002,ERR=7000,END=7000) line
      call mspinit()
c
c   --- check for the end keyword ---
c
      keyin = line(1:10)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 333
c
c   --- parse the line
c    +- read reporting SCC
c
      extscc=line(1:10)
      call low2up( extscc )
      call lftjst( extscc )
c
c    +- read analysis SCC
c
      intscc=line(12:21)
      call low2up( intscc )
      call lftjst( intscc )
c
c    +- increment index, store marine fipcode,
c          and set corresponding element of logic array to true.
c
      irec = irec + 1
      mscin(irec)=intscc
      mscout(irec)=extscc
c
c   --- get the next record ---
c
      goto 111
c
c   --- finished reading file ---
c
  333 continue
      close(IORXWK)
      ierr = ISUCES
      nmscrc = irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(//,1X,3A)',ERR=9999) 'ERROR:  Reading ',
     &           keywrd(:strmin(keywrd)),' packet of options file.'
      write(IOWMSG,'(//,1X,3A)',ERR=9999) 'ERROR:  Reading ',
     &           keywrd(:strmin(keywrd)),' packet of options file.'
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,2A,I10,/,1X,2A)',ERR=9999)
     &              'ERROR:  Reading /MARINE SCC CROSSWALK/ packet. ',
     &                        'at record: ',irec,
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,I10,/,1X,2A)',ERR=9999)
     &              'ERROR:  Reading /MARINE SCC CROSSWALK/ packet. ',
     &                        'at record: ',irec,
     &                               'Line read: ',line(:strmin(line))
      goto 9999
 7002 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot ',
     &           'open Marine SCC crosswalk data file ', emfcfl
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot ',
     &           'open Marine SCC crosswalk data file ', emfcfl
      goto 9999
c
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 8001 format(20(:,F10.0))
 8002 format(A132)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
