C     Last change:  GK   30 Sep 1998    8:34 pm
C**** RDMAREMF
c
      subroutine rdmaremf( ierr )
c
c-----------------------------------------------------------------------
c
c    reads the marine emission factors file
c    to be used by the commercial marine module of the NONROAD program.
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/21/97  --gkohlbach-- original code
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdcmr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4     ierr
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer*4           jerr
      logical*4           lcheck
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
c
c   --- open the marine emission factors file.
c
      open(IOREMS,file=emfcfl,ERR=7000,status='UNKNOWN')
      inquire(file=emfcfl,exist=lcheck)
      if( .NOT. lcheck ) goto 7001
c
c   --- read the exhaust maneuver packet
c
      call rmexhman(jerr)
      if( jerr .NE. ISUCES ) goto 7002
c
c   --- read the exhaust cruise packet
c
      call rmexhcru(jerr)
      if( jerr .NE. ISUCES ) goto 7003
c
c   --- read the exhaust full packet
c
      call rmexhful(jerr)
      if( jerr .NE. ISUCES ) goto 7004
c
c   --- read the exhaust slow packet
c
      call rmexhslo(jerr)
      if( jerr .NE. ISUCES ) goto 7005
c
c   --- read the technology packet
c
      call rdmartch(jerr)
      if( jerr .NE. ISUCES ) goto 7006
c
c   --- read the fuel and hp packet
c
      call rdmarfhp(jerr)
      if( jerr .NE. ISUCES ) goto 7007
c
c  --- set success flag
c
      ierr = ISUCES
c
c  --- close the marine emission factors file
c
      close(IOREMS)
c
c  --- continue
c
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot ',
     &           'open Marine emission factors file ', emfcfl
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot ',
     &           'open Marine emission factors file ', emfcfl
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &           'ERROR:  Marine emission factors file does not exist'
      write(IOWMSG,'(/,1X,2A)',ERR=9999)
     &           'ERROR:  Marine emission factors file does not exist'
      goto 9999
 7002 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine EXHAUST MANEUVER packet '
      write(IOWMSG,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine EXHAUST MANEUVER packet '
      goto 9999
 7003 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine EXHAUST CRUISE packet '
      write(IOWMSG,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine EXHAUST CRUISE packet '
      goto 9999
 7004 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine EXHAUST FULL packet '
      write(IOWMSG,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine EXHAUST FULL packet '
      goto 9999
 7005 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine EXHAUST SLOW packet '
      write(IOWMSG,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine EXHAUST SLOW packet '
      goto 9999
 7006 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine TECHNOLOGY packet '
      write(IOWMSG,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine TECHNOLOGY packet '
      goto 9999
 7007 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine FUEL&HP packet '
      write(IOWMSG,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine FUEL&HP packet '
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 8001 format(20(:,F10.0))
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end