C**** RDMARCHR
c
      subroutine rdmarchr( ierr )
c
c-----------------------------------------------------------------------
c
c    reads the marine vessel charateristics file
c    to be used by the commercial marine module of the NONROAD program.
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/25/97  --gkohlbach-- cloned from rdmaremf.for
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdcmr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4     ierr
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer*4           jerr
      logical*4           lcheck
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
c
c   --- open the marine vessel characteristics file.
c
      open(IORVSL,file=vslchr,ERR=7000,status='UNKNOWN')
      inquire(file=vslchr,exist=lcheck)
      if( .NOT. lcheck ) goto 7001
c
c   --- read the fleet activity packet
c
      call rmchrfac(jerr)
      if( jerr .NE. ISUCES ) goto 7002
c
c   --- read the vessel mix packet
c
      call rmchrvmx(jerr)
      if( jerr .NE. ISUCES ) goto 7003
c
c  --- close the marine vessel characteristics file
c
      ierr=ISUCES
      close(IORVSL)
c
c  --- continue
c
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot ',
     &           'open Marine vessel characteristics file ', emfcfl
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot ',
     &           'open Marine vessel characteristics file ', emfcfl
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &       'ERROR:  Marine vessel characteristics file does not exist'
      write(IOWMSG,'(/,1X,2A)',ERR=9999)
     &       'ERROR:  Marine vessel characteristics file does not exist'
      goto 9999
 7002 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine fleet activity packet '
      write(IOWMSG,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine fleet activity packet '
      goto 9999
 7003 continue
      write(IOWSTD,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine vessel mix packet '
      write(IOWMSG,'(/,1X,1A)',ERR=9999)
     &             'ERROR:  Reading marine vessel mix packet '
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 8001 format(20(:,F10.0))
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
