C     Last change:  GK   24 Oct 1998    1:09 pm
C**** MARCALC
c
      subroutine marcalc(ierr,mtype)
c
c-----------------------------------------------------------------------
c
c    using data read into common blocks by routines invoked earlier,
c    calculates and stores marine emission estimates.
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c       mtype   C  marine analysis type flag
c     Inputs:
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/14/98  --gfkohlbach --  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdcmr.inc'
      include 'nonrdio.inc'
      include 'nonrdalo.inc'
      include 'nonrdreg.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4         ierr
      character*10      mtype
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   fndchr   I   returns the index of a string in an array of strings
c   fndasc   I   returns the best match of an SCC code in an array
c   fndchr   I   returns the index of a string in array of strings
c   fndact   I   returns the index of record in activity arrays
c   fndgxf   I   returns the index of the record in growth Xref arrays
c   fndtch   I   returns the index of the technology type
c   dailyf   R   returns a month/day/hour adjustment factor
c
c      integer*4 fndchr
      integer*4 fndasc
      integer*4 fndmef
      integer*4 fndfhp
c      integer*4 fndact
c      integer*4 fndgxf
c      integer*4 fndtch
c      real*4    dailyf
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
c     fipin    C FIPS code for region
c     scc      C current SCC code
c     oldscc   C SCC code from previous read
c     sub      C subregion code - for compatibility with wrtdat
c     tchfrc   R fraction of this scc with this tech type.
c     time     R amount of time in current scc x class x mode
c     ahp      R average horsepower
c     tctp     I integral tech type
c     keywrd   C keyword to check
c     i, idxpor, mode, class, pllt
c     trips    I number of trips for current SCC
c     fcmax    R maximum fuel consumption
c     pctmax   R percent of max fuel used in an operating mode.
c     fuel     R fuel used in current SCC, class, mode
c     efactr   R emission factor for current SCC, class, mode, type
c     emiss    R array of emissions by pollutant
c     idxmar, idxtac, idxfac,idxscc
c     idxvmx, idxtch, idxtac
c     ilength, iefctr
c     idxman(MRXCLS), idxcru(MRXCLS)
c     idxful(MRXCLS), idxslo(MRXCLS)
c     lmarpr(MRXSCC)
c     lexist
c     clstp    C
c     pctime   R percent of time spent in indicated operating mode
c     hpin     R horsepower
c     popin    R population
c     rsub     C
c     rscc     C
c     rhp      R
c     rpop     R
c     ract     R
c     fuel     R
c     remis    R
      integer*4         jerr
      character*5       fipin
      character*10      scc
      character*5       sub
      real*4            tchfrc
      real*4            time
      real*4            ahp
      integer*4         tctp
      integer*4         idxpor, mode, class, pllt
      integer*4         trips
      real*4            fcmax
      real*4            pctmax
      real*4            fuel
      real*4            efactr
      real*4            emiss(MXPOL+1)
      integer*4         idxvmx, idxtch, idxtac,idxscc,idxtmp
      integer*4         idxmef
      logical*4         lmarpr(MRXSCC)
      real*4            pctime
      character*5       rsub(MRXSCC)
      character*10      roscc(MRXSCC)
      character*5       clstp
      real*4            rhp(MRXSCC)
      real*4            rpop(MRXSCC)
      real*4            ract(MRXSCC)
      real*4            rfuel(MRXSCC)
      real*4            remis(MRXSCC,MXPOL+1), hours, vmix
      integer*4         nvalrc(MRXSCC), idxfhp, idxfac, idxtpp
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag and initialize local variables ---
c
      ierr  = IFAIL
      jerr  = ISUCES
      tctp=1
      idxpor= 0
      sub   = ' '
      clstp='HP   '
c     loop through port definitions per options file
      do 10 idxpor=1,nmarpr
c       initialize this port position to unfound in logical array
        lmarpr(idxpor)=.FALSE.
        fipin = marfip(idxpor)
c       zero out all the regional summation variables
        do 60 idxtac=1,MRXSCC
          rsub(idxtac)=' '
          roscc(idxtac)=' '
          rhp(idxtac)=0
          rpop(idxtac)=0
          ract(idxtac)=0
          rfuel(idxtac)=0
          do 65 pllt=1,MXPOL
            remis(idxtac,pllt)=0
   65     continue
   60   continue
c       loop trip activity file, regarding only current port's records.
        do 20 idxtac=1,ntacrc
          if (marpor(idxpor).NE.tacpor(idxtac)) goto 20
          trips=tactrp(idxtac)
c    +-   find scc
          scc=tacscc(idxtac)
c    +-   find corresponding true output SCC.
          idxscc=fndasc(scc,mscin,nmscrc)
          roscc(idxtac)=mscout(idxscc)
c    +-   find index of this trip activity record in fleet activity file.
          idxfac= fndasc(scc, facscc, nfacrc )
          if( idxfac .LE. 0 ) goto 7001
          hours=fachrs(idxfac)
c    +-   find best match for SCC code in vessel mix file
          idxvmx= fndasc( scc, vmxscc, nvmxrc )
          if( idxvmx .LE. 0 ) goto 7002
          vmix=vmxfrc(idxvmx)
c
c    +-   find best match for SCC code in tech fractions file
c
          idxtch= fndasc( scc, tchscc, ntchrc )
          if( idxtch .LE. 0 ) goto 7003
c
c    +-   assign tech type 1 globally(for beta version)
c         and find technical fraction and pct of time in that type
c
          tchfrc=tchtyp(tctp,idxtch)
          pctime=factim(tctp,idxfac)
c
c         loop through defined operating modes
c
          do 30 mode=1,MRXMOD
c
c           loop through size classes
c           assume for beta that size class type is 'HP'
c
            do 40 class=1,MRXCLS
c
c    +-       find best match for SCC code, class, type in fuel/hp file
c
              idxfhp= fndfhp( scc, class, clstp )
              if( idxfhp .LE. 0 ) goto 7004
              ahp=fhpahp(idxfhp)
              fcmax=fhpmxf(idxfhp)
                if (mode.EQ.MARMAN) then
                  idxmef=fndmef(scc,class,manscc,mancls,nmanrc)
                  pctmax=fhpman(idxfhp)
                elseif(mode.EQ.MARCRU) then
                  idxmef=fndmef(scc,class,cruscc,crucls,ncrurc)
                  pctmax=fhpcru(idxfhp)
                elseif(mode.EQ.MARFUL) then
                  idxmef=fndmef(scc,class,fulscc,fulcls,nfulrc)
                  pctmax=fhpful(idxfhp)
                elseif(mode.EQ.MARSLO)then
                  idxmef=fndmef(scc,class,sloscc,slocls,nslorc)
                  pctmax=fhpslo(idxfhp)
                else
c                 hotelling (other modalities?) to be addressed here.
                end if
              if (idxmef.LE.0) then
                write(IOWSTD,'(1X,3A,I4)',ERR=9999)
     &          'WARNING: No Emission factor record found for MSC ',
     &          scc,' class ',class
                write(IOWMSG,'(1X,3A,I4)',ERR=9999)
     &          'WARNING: No Emission factor record found for MSC ',
     &          scc,' class ',class
              end if
              time=trips*hours*vmix*pctime/100*tchfrc
              fuel=time*fcmax*pctmax/100*tchfrc
c             loop thru pollutants
              do 50 pllt=1,MXPOL
c    +-       assign emission factors (and other mode-specific vars?)
c             //NB account for different units for e.f.//
c             set emission factor to zero for nonrepresented classes.
               if (idxmef .LE. 0) then
                        efactr=0
               else
                if (pllt .EQ. IDXTHC ) then
                  if (mode .EQ. MARMAN) then
                      efactr=manhc(idxmef)
                  elseif (mode .EQ. MARCRU) then
                      efactr=cruhc(idxmef)
                  elseif (mode .EQ. MARFUL) then
                      efactr=manhc(idxmef)
                  elseif (mode .EQ. MARSLO) then
                      efactr=slohc(idxmef)
                  end if
                elseif (pllt .EQ. IDXCO  ) then
                  if (mode .EQ. MARMAN) then
                        efactr=manco(idxmef)
                  elseif (mode .EQ. MARCRU) then
                        efactr=cruco(idxmef)
                  elseif (mode .EQ. MARFUL) then
                        efactr=manco(idxmef)
                  elseif (mode .EQ. MARSLO) then
                        efactr=sloco(idxmef)
                  end if
                elseif (pllt .EQ. IDXNOX ) then
                  if (mode .EQ. MARMAN) then
                        efactr=mannox(idxmef)
                  elseif (mode .EQ. MARCRU) then
                        efactr=crunox(idxmef)
                  elseif (mode .EQ. MARFUL) then
                        efactr=mannox(idxmef)
                  elseif (mode .EQ. MARSLO) then
                        efactr=slonox(idxmef)
                  end if
                elseif (pllt .EQ. IDXSOX ) then
                  if (mode .EQ. MARMAN) then
                        efactr=mansox(idxmef)
                  elseif (mode .EQ. MARCRU) then
                        efactr=crusox(idxmef)
                  elseif (mode .EQ. MARFUL) then
                        efactr=mansox(idxmef)
                  elseif (mode .EQ. MARSLO) then
                        efactr=slosox(idxmef)
                  end if
                elseif (pllt .EQ. IDXPM  ) then
                  if (mode .EQ. MARMAN) then
                        efactr=manpm(idxmef)
                  elseif (mode .EQ. MARCRU) then
                        efactr=crupm(idxmef)
                  elseif (mode .EQ. MARFUL) then
                        efactr=manpm(idxmef)
                  elseif (mode .EQ. MARSLO) then
                        efactr=slopm(idxmef)
                  endif
                else
                   efactr=0
                end if
               end if
c    +-         N.B. all fractions applied prior to this step.
                remis(idxtac,pllt) = remis(idxtac,pllt)+
     &            (efactr*ahp*fuel*CVTTON)
c             as this loop is traversed, remis values for current
c             trip activity _record_, class, mode, scc are filled
   50         continue
   40       continue
   30     continue
   25    continue
c    +-  add current values to regional rollup vars
         rsub(idxtac)  =  sub
c        roscc(idxtac) was set above
         rhp(idxtac)   =  ahp
         rpop(idxtac)  =  rpop(idxtac)   + trips
         ract(idxtac)  =  ract(idxtac)   + hours
         rfuel(idxtac) =  rfuel(idxtac)  + fuel
c    +-   set this port to true.
         lmarpr(idxpor)=.TRUE.

   20   continue
        do 79 idxtac=1,ntacrc

   79   continue
c   --- identify unique output sccs
        do 80 idxtac=1,ntacrc
          nvalrc(idxtac)=1
          do 82 idxtmp=1,idxtac-1
c
c    +-     look for exact matches on output scc
c
            if ((roscc(idxtac).EQ.roscc(idxtmp))
     &                        .AND. (nvalrc(idxtac).GT. 0))  then
              nvalrc(idxtac)=0
c
c    +-       find rolling average of hps
c
              rhp(idxtmp)=(rhp(idxtmp)*nvalrc(idxtmp)
     &                            +rhp(idxtac))/(nvalrc(idxtmp)+1)
              rpop(idxtmp)=rpop(idxtmp)+rpop(idxtac)
              ract(idxtmp)=ract(idxtmp)+ract(idxtac)
              rfuel(idxtmp)=rfuel(idxtmp)+rfuel(idxtac)
c
c    +-       accumulate pollutant specific emissions
c
              do 81 idxtpp=1,MXPOL
                remis(idxtmp,idxtpp)=remis(idxtmp,idxtpp)
     &            +remis(idxtac,idxtpp)
                remis(idxtac,idxtpp)=0
   81         continue
              nvalrc(idxtmp)=nvalrc(idxtmp)+1
            end if
   82     continue
   80   continue
c   --- write data for each unique output SCC.
        do 85 idxtac=1,ntacrc
        if (nvalrc(idxtac).GT. 0) then
c   ---       write the data record to direct access file ----
           do 70 pllt=1,MXPOL
             emiss(pllt)=remis(idxtac,pllt)
   70      continue
              call wrtdat( jerr, fipin, rsub(idxtac), roscc(idxtac),
     &          rhp(idxtac), rpop(idxtac),ract(idxtac),
     &          rfuel(idxtac), emiss)
        end if
   85   continue
   10 continue
c     Warn for any ports not found in data.
      do 90 idxpor=1,nmarpr
      if ( .NOT. lmarpr(idxpor) ) then
        write (IOWSTD,9005,ERR=9999)
     &    'Marine port #',marpor(idxpor),'not represented in data.'
        write (IOWMSG,9005,ERR=9999)
     &    'Marine port #',marpor(idxpor),'not represented in data.'
      end if
   90 continue
      ierr=ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
c 7000 continue
c      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot find: ',
c     &       keywrd(:strmin(keywrd)),' packet of the control file.'
c      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Cannot find: ',
c     &       keywrd(:strmin(keywrd)),' packet of the control file.'
c      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Marine SCC "',
     &       scc,'" not found in trip activity file.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Marine SCC "',
     &       scc,'" not found in trip activity file.'
      goto 9999
c
 7002 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Marine SCC "',
     &       scc,'" not found in vessel mix file.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Marine SCC "',
     &       scc,'" not found in vessel mix file.'
      goto 9999
c
 7003 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Marine SCC "',
     &       scc,'" not found in tech type file.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Marine SCC "',
     &       scc,'" not found in tech type file.'
      goto 9999
c
 7004 continue
      write(IOWSTD,'(/,1X,4A,I4,2A)',ERR=9999) 'ERROR:  No match for ',
     &       'Marine SCC: "',scc,'", class "', class,
     & '" and class type "',clstp, '" found in fuel/hp file.'
      write(IOWMSG,'(/,1X,4A,I4,2A)',ERR=9999) 'ERROR:  No match for ',
     &       'Marine SCC: "',scc,'", class "', class,
     & '" and class type "',clstp, '" found in fuel/hp file.'
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9005 format(1X, 3A)
 9006 format(1X,A,I4,A,I4,A,F10.0)
 9008 format(1X,7A,F10.0,A,F10.0,A,F10.0,A,F10.0,A,
     & F10.0,A,F10.0,A,F10.0,A,F10.0,A,F10.0)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
