C     Last change:  GK   29 Sep 1998   10:00 pm
C**** INTMAR
c
      subroutine intmar( ierr )
c
c-----------------------------------------------------------------------
c
c    reads the /MARINE FILES/ packet of the options file
c
c    Argument description.
c     Outputs:
c       ierr    I error flag
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      12/10/95  --djk--  original development
c      07/19/96  --jlf--  removed mention of aircraft, vessels, and
c                         locomotives files
c      07/22/96  --jlf--  changed so population file opened here
c      08/22/97  --gkohlbach--  cloned opnmar from opnnon
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdusr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strlen  I   returns the actual length of a string
c   strmin  I   returns the actual length of a string (minimum of 1)
c
      integer*4 strlen
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
c   fname   C   character string for temporary storage of filenames
c
      character*(100) fname, line
      character*20      keywrd, keyfil, keyin
      integer*4         jerr
      logical*4         lcheck
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
c
c
c   --- search for the packet header ----
c
      lmfpac = .FALSE.
      keywrd = '/MARINE FILES/'
      call fndkey( jerr, IORUSR, keywrd )
      if( jerr .NE. ISUCES ) goto 7006
c
  111 continue
      read(IORUSR,8002,ERR=7000,END=7008) line
      keyfil = line(1:19)
      call lftjst( keyfil )
      call low2up( keyfil )
c
c   --- check for /END/ keyword ----
c
      if( keyfil .EQ. KEYEND ) goto 222
c
c   --- get the filename ---
c
      fname = line(21:)
      call lftjst( fname )
c
c    ---- check if file is TRIP ACTIVITY FILE -----
c
      if( keyfil .EQ. 'TRIP ACTIVITY FILE' ) then
         if( strlen( fname ) .GT. 0 ) then
            trpact = fname
            ltrpfl = .TRUE.
         endif
c
c    ---- check if file is emission factors file -----
c
      else if( keyfil .EQ. 'EMISSION FACTORS' ) then
         if( strlen( fname ) .GT. 0 ) then
            emfcfl = fname
            lemffl = .TRUE.
         endif
c
c    ---- check if file is Vessel Character file -----
c
      else if( keyfil .EQ. 'VESSEL CHARACTER' ) then
         if( strlen( fname ) .GT. 0 ) then
            vslchr = fname
            lvslfl = .TRUE.
         endif
c
c    ---- check if file is Marine SCC Crosswalk file -----
c
      else if( keyfil .EQ. 'SCC XREF' ) then
         if( strlen( fname ) .GT. 0 ) then
            mscxwk = fname
            lmscfl = .TRUE.
         endif
c
c   ---- unrecognized keyword, skip it ---
c
      else
         goto 7007
      endif
c
c  --- get the next record ---
c
      goto 111
c
c  ---- read the entire file, check for output files ---
c
 222  continue
c
c  --- check to make sure all necessary files were provided, if so
c      open them ----
c
c  --- TRIP ACTIVITY file ---
c      this file will be opened later to save file handles ---
c
      if( .NOT. ltrpfl ) then
          keyin = ' MARINE TRIP ACTIVITY FILE'
          goto 7002
      else
          fname = trpact
          inquire(file=trpact,exist=lcheck)
          if( .NOT. lcheck ) goto 7001
      endif
c
c  --- EMISSION FACTORS file ---
c      this file will be opened later to save file handles ---
c
      if( .NOT. lemffl ) then
          keyin = ' MARINE EMISSION FACTORS'
          goto 7002
      else
          fname = emfcfl
          inquire(file=emfcfl,exist=lcheck)
          if( .NOT. lcheck ) goto 7001
      endif
c
c  --- VESSEL CHARACTER file ---
c
      if( .NOT. lvslfl ) then
          keyin = ' MARINE VESSEL CHARACTER'
          goto 7002
      else
          fname = vslchr
          inquire(file=vslchr,exist=lcheck)
          if( .NOT. lcheck ) goto 7001
      endif
c
c  --- MARINE SCC XREF file ---
c
      if( .NOT. lmscfl ) then
          keyin = ' MARINE SCC XREF'
          goto 7002
      else
          fname = vslchr
          inquire(file=vslchr,exist=lcheck)
          if( .NOT. lcheck ) goto 7001
      endif
c
c   --- echo filenames ---
c
  444 continue
      write(IOWMSG,9001,ERR=7004)
      write(IOWMSG,9003,ERR=7004) '*** Marine Module Files ***'
      write(IOWMSG,9001,ERR=7004)
      if( ltrpfl ) then
          write(IOWMSG,9002,ERR=7004)
     &               'Marine Trip Activity File',trpact(:strmin(trpact))
      endif
      if( lemffl ) then
          write(IOWMSG,9002,ERR=7004)
     &            'Marine Emission Factors file',emfcfl(:strmin(emfcfl))
      endif
      if( lvslfl ) then
          write(IOWMSG,9002,ERR=7004)
     &      'Marine vessel characteristics file',vslchr(:strmin(vslchr))
      endif
      if( lmscfl ) then
          write(IOWMSG,9002,ERR=7004)
     &      'Marine SCC crosswalk file',mscxwk(:strmin(mscxwk))
      endif
c
c  --- set error flag to success ----
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR: reading ',
     &               keywrd(:strmin(keywrd)),' packet of options file.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR: reading ',
     &               keywrd(:strmin(keywrd)),' packet of options file.'
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999)
     &            'ERROR: Input file not found: ',fname(:strmin(fname))
      write(IOWMSG,'(/,1X,2A)',ERR=9999)
     &            'ERROR: Input file not found: ',fname(:strmin(fname))
      goto 9999
c
 7002 continue
      write(IOWSTD,'(/,1X,5A)',ERR=9999) 'ERROR:  A',
     &       keyin(:strmin(keyin)),' file must be provided in the ',
     &         keywrd(:strmin( keywrd )),' packet of the options file.'
      write(IOWMSG,'(/,1X,5A)',ERR=9999) 'ERROR:  A',
     &       keyin(:strmin(keyin)),' file must be provided in the ',
     &         keywrd(:strmin( keywrd )),' packet of the options file.'
      goto 9999
c
 7004 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999)
     &          'ERROR: Writing message file: ',msgfl(:strmin(msgfl))
      write(IOWMSG,'(/,1X,2A)',ERR=9999)
     &          'ERROR: Writing message file: ',msgfl(:strmin(msgfl))
      goto 9999
c
 7006 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999)
     &        'ERROR:  This program requires the ',
     &          keywrd(:strmin( keywrd )),' packet of the options file.'
       write(IOWMSG,'(/,1X,3A)',ERR=9999)
     &        'ERROR:  This program requires the ',
     &          keywrd(:strmin( keywrd )),' packet of the options file.'
      goto 9999
c
 7007 continue
      write(IOWSTD,'(/,1X,5A)',ERR=9999)
     &    'ERROR:  Invalid file identifier in ',keywrd(:strmin(keywrd)),
     &                   ' packet of options file: -->',line(1:19),'<--'
      write(IOWMSG,'(/,1X,5A)',ERR=9999)
     &    'ERROR:  Invalid file identifier in ',keywrd(:strmin(keywrd)),
     &                   ' packet of options file: -->',line(1:19),'<--'
      goto 9999
c
 7008 continue
      write(IOWSTD,'(/,1X,4A)',ERR=9999)
     &     'ERROR:  Unexpected end-of-file reached reading ',
     &          keywrd(:strmin(keywrd)),' packet of the options file.'
      write(IOWMSG,'(/,1X,4A)',ERR=9999)
     &     'ERROR:  Unexpected end-of-file reached reading ',
     &          keywrd(:strmin(keywrd)),' packet of the options file.'
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 8002 format(A100)
 9001 format(1X,5A)
 9002 format(T10,A,T45,:,':',A)
 9003 format(T20,A)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
