C**** GRWFAC  
c
      subroutine grwfac( ierr, factor, ipopyr, iepyr, infips, indcod ) 
c
c-----------------------------------------------------------------------------
c
c   subroutine to compute the growth factor from the current indicator 
c   data
c   
c     Argument declaration
c       Outputs:
c             ierr    I  error indicator flag
c             factor  R  the growth factor based on the current indicator
c       Inputs:
c             ipopyr  I  the base population year
c             iepyr   I  the episode year 
c             infips  I  FIPS code
c             indcod  C  indicator code
c
c-----------------------------------------------------------------------------
c  LOG:
c-----------------------------------------------------------------------------
c
c        12-05-95  -djk-  Original Development
c        07-16-96  -gwl-  Rewritten
c        06/09/97  -gwilson- Now writes error if no data available.
c        09/19/01  -charvey- For future year interpolate between two 
c                    closest yrs of input vs using later year index.
c        01/24/02  -charvey- If base pop year in pop file is not a year
c                    in the growth file, interpolate to get base index.
c        03/14/02 12 charvey: Properly backcast & handle negative growth.
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdgrw.inc'
      include 'nonrdreg.inc'
c
c------------------------------------------------------------------------
c  Argument declarations:
c------------------------------------------------------------------------
c
      integer*4    ierr
      integer*4    ipopyr
      integer*4    iepyr
      real*4       factor
      character*5  infips
      character*4  indcod
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c
c------------------------------------------------------------------------
c  Local variables:
c------------------------------------------------------------------------
c
      character*5 stfips
      integer*4   i, ilo, ihi, ibeg, iend, imidlo, imidhi
      real*4      ratio, midgrw, logrw
      logical*4   lzerohi, gotihi
c
c------------------------------------------------------------------------
c  Entry point:
c------------------------------------------------------------------------
c     
c --- default growth is no growth ---
c
      ierr = IFAIL
      factor = 0.0
c
c --- if episode year equals base year, then no growth ---
c
CCC 
CCC  but still need to calc growth to get proper adjusted age dist?
CCC
      if( iepyr .EQ. ipopyr ) then
        ierr = ISUCES
        goto 9999      
      endif
CCC
c
c --- zero indicator year indecies ---
c
      ibeg = 0
      iend = 0
c                             
c --- loop over the indicator fips searching for national, state,
c     or county match (note--fipgrw is sorted by fips code) ---
c
      stfips = infips(1:2)//'000'
c                                        
      do 10 i=1,nrcgrw
         if( fipgrw(i) .EQ. '00000') iend = i
         if( fipgrw(i) .EQ. stfips) iend = i
         if( fipgrw(i) .EQ. infips) iend = i
   10 continue      
c         
c --- if there is no match, use default growth ---
c
      if( iend .EQ. 0 ) goto 7000
c  
c --- backup to the first occurrance ---
c
      ibeg = 1
      do 20 i=iend-1,1,-1
         if( fipgrw(i) .NE. fipgrw(iend) ) then
            ibeg = i + 1 
            goto 111
         endif
   20 continue
c
c --- if ibeg equals iend then only one indicator,
c     we need two years for equation, so write error and return ---
c
  111 continue
cc
cc      write(IOWMSG,'(1X,A,2I4)',ERR=9999)
cc     &  'ibeg,iend: ',ibeg,iend
cc
      if( ibeg .EQ. iend .OR. iyrgrw(ibeg) .EQ. iyrgrw(iend) ) goto 7000
c
c --- use the closest indicator range if both base and episode years
c     are below or above the range of indicator years ---
c
      gotihi = .FALSE.
      if( iepyr .LE. iyrgrw(ibeg) ) then
        ihi = ibeg
        imidhi = ibeg+1
        gotihi = .TRUE.
cc
cc      write(IOWMSG,'(1X,A,4I4)',ERR=9999)
cc     &  'Case loep ilo,ihi,imidlo,imidhi: ',ilo,ihi,imidlo,imidhi
cc
      else
       if( iepyr .GE. iyrgrw(iend) ) then
        ihi = iend
        imidhi = ihi-1
        gotihi = .TRUE.
cc
cc      write(IOWMSG,'(1X,A,4I4)',ERR=9999)
cc     &  'Case hiep ilo,ihi,imidlo,imidhi: ',ilo,ihi,imidlo,imidhi
cc
       endif
      endif
CCC
      ilo = ibeg
      if( .NOT. gotihi ) ihi = ibeg+1
      if( ipopyr .LE. iyrgrw(ibeg) .AND. 
     &                            iepyr .LE. iyrgrw(ibeg) ) then
           imidlo = ilo
           if( .NOT. gotihi ) then
             ihi = ilo + 1
             imidhi = ihi
           endif
cc
cc      write(IOWMSG,'(1X,A,4I4)',ERR=9999)
cc     &  'Case 1 ilo,ihi,imidlo,imidhi: ',ilo,ihi,imidlo,imidhi
cc
           goto 222
      endif
      if( ipopyr .GE. iyrgrw(iend) .AND. 
     &                            iepyr .GE. iyrgrw(iend) ) then
           ilo = ihi - 1
           imidlo = ilo
           if( .NOT. gotihi ) then
             ihi = iend
             imidhi = ihi
           endif
cc
cc      write(IOWMSG,'(1X,A,4I4)',ERR=9999)
cc     &  'Case 2 ilo,ihi,imidlo,imidhi: ',ilo,ihi,imidlo,imidhi
cc
           goto 222
      endif
c
c --- else find exact year or closest two indicator years for base pop
c     year and for episode year. 
c     (this code assumes iyrgrw has been sorted on fips and year)
c
      lzerohi = .FALSE.
      imidlo = ibeg
      if( .NOT. gotihi ) then
        ihi = ibeg
        imidhi = ibeg
      endif
      do 30 i=ibeg,iend
CCCC
         if( ipopyr .GE. iyrgrw(i) ) then
           ilo = i
           imidlo = i+1
           if( ipopyr .EQ. iyrgrw(i) ) imidlo = i
         endif
c
         if( iepyr .GE. iyrgrw(i) .AND. .NOT. gotihi ) then
           ihi = i+1
           imidhi = i
           if( iepyr .EQ. iyrgrw(i) ) ihi = i
         endif
         if( iyrgrw(i) .GT. ipopyr .AND. iyrgrw(i) .GT. iepyr )
     &     goto 222
cc
   30 continue  
cc
cc      write(IOWMSG,'(1X,A)',ERR=9999)
cc     &  '*** Unresolved? ***'
cc
c
c --- solve for the slope and intercept for this line ----
c
  222 continue
cc
cc      write(IOWMSG,'(1X,A,4I4)',ERR=9999)
cc     &  'PreFinal: ilo,ihi,imidlo,imidhi: ',ilo,ihi,imidlo,imidhi
cc

cc
c
c --- if needed, interpolate between two closest growth indexes to 
c     get proper base year growth index for input pop year.
c
      if( imidlo .NE. ilo ) then
        logrw = valgrw(ilo) + (ipopyr - iyrgrw(ilo)) *
     &   ( (valgrw(imidlo)-valgrw(ilo)) / (iyrgrw(imidlo)-iyrgrw(ilo)) )
        ilo = imidlo
      else
        logrw = valgrw(ilo)
      endif
cc
c
c --- interpolate between two closest growth indexes to get proper 
c     future or past year growth index to match episode year.
c
      if( imidhi .NE. ihi) then
        midgrw = valgrw(imidhi) + ABS(iepyr - iyrgrw(imidhi)) *
     &   ( (valgrw(ihi)-valgrw(imidhi)) / 
     &   ABS(iyrgrw(ihi)-iyrgrw(imidhi)) )
      endif
c
      if( imidhi .NE. ihi) then
        if( iepyr .NE. ipopyr .AND. logrw .NE. 0.) then
            factor = ABS(midgrw - logrw) / 
     &               (ABS(iepyr - iyrgrw(ilo)) * logrw )
        endif
c
      else
        if( iyrgrw(ihi) .EQ. ipopyr ) then
            factor = ABS(valgrw(ihi)-logrw) / 
     &               (ABS(iyrgrw(ihi)-iyrgrw(ilo)) * logrw )
        else
          if( iyrgrw(ihi) .NE. ipopyr .AND. logrw .NE. 0.) then
            factor = ABS(valgrw(ihi)-logrw) / 
     &               (ABS(iyrgrw(ihi)-iyrgrw(ilo)) * logrw )
          endif
        endif
      endif
c
c  Check for negative growth
c
      if( ihi .LT. ilo ) factor = -factor
      if( valgrw(ihi) .LT. valgrw(ilo) ) factor = -factor
c
ccc
cc      write(IOWMSG,'(/,1X,2A,/,1X,3I5,2I4,3F8.1,F7.4)',ERR=9999)
cc     &  'ipopyr,iepyr,iyrgrw(ihi),imidlo,imidhi,',
cc     &  'logrw,midgrw,valgrw(ihi),factor:',
cc     &  ipopyr,iepyr,iyrgrw(ihi),imidlo,imidhi,
cc     &  logrw,midgrw,valgrw(ihi),factor
ccc
c
c  --- set error code to sucess and return ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find any ',
     &                                        'valid growth data for '
      write(IOWSTD,9000,ERR=9999) 'County','Year','Indicator Code',
     &                                            infips, iepyr, indcod
      write(IOWMSG,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find any ',
     &                                        'valid growth data for '
      write(IOWMSG,9000,ERR=9999) 'County','Year','Indicator Code',
     &                                            infips, iepyr, indcod
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format(10X,A6,3X,A4,3X,A,/,10X,A5,4X,I4,10X,A4)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999  continue
       return
       end
