C**** GRWCLC
c
      subroutine grwclc( modpop, modfrc, 
     &               modscp, nyrlif, facgrw, iyrbas, ifutyr, popval)
c
c-----------------------------------------------------------------------
c
c    this routine calculates the populations for each model year 
c    after applying the growth factor.
c
c    Argument declaration.
c     Outputs:
c       modpop  R  the model year populations
c       modfrc  R  adjusted fractions for each model year (also input)
c     Inputs:
c       modscp  R  array of new equipment fractions not yet scrapped
c                  for each model year
c       facgrw  R  slope of line used for growth 
c       modfrc  R  array of fractions for each model year
c       nyrlif  I  number of years in the lifetime 
c       iyrbas  I  year of the base population
c       ifutyr  I  future year to which to grow
c       popval  R  base year population
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      06/16/93  --rel--  original development
c      07/15/96  --asr--  modified
c      04/12/01 c.harvey TEST static age distribution (scrap & growth)
c
c-----------------------------------------------------------------------
c    Include files
c-----------------------------------------------------------------------
c
       include 'nonrdprm.inc'
       include 'nonrdefc.inc'
       include 'nonrdeqp.inc'
       include 'nonrdact.inc'
       include 'nonrdusr.inc'
       include 'nonrdgrw.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      real*4    modpop(MXAGYR)
      real*4    modfrc(MXAGYR)
      real*4    modscp(MXAGYR)
      integer*4 nyrlif
      real*4    facgrw
      integer*4 iyrbas
      integer*4 ifutyr
      real*4    popval
c
c-----------------------------------------------------------------------
c    Local variables:
c----------------------------------------------------------------------- 

      integer*4 i, j, imb
      real*4    popyr, accum, popsav(MXSCRP)
      real*4    modtot
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- if the future year is the same as the growth year, 
c       or there is no growth, just return ---
c
CCC
ccc   if( ifutyr .EQ. iyrbas .OR. facgrw .EQ. 0.0 ) goto 9999
CCC
      if( facgrw .EQ. 0.0 ) goto 9999
      popyr = popval
c
c   --- if the growth factor in future is positive, walk through
c       each year and calculate the new sales each year ---
c
ccc --- TEST static age distribution method for everything,
c       and ignore all this other stuff.
c
      goto 51
cccccccccccccccccccccccc      goto 51
c
c
c
c
c
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccc   if( facgrw .GT. 0.0 .AND. ifutyr .GT. iyrbas ) then       !ccccccccccccccccc
ccccccccc      if( facgrw .GT. 0.0 .AND. ifutyr .GT. iyrbas ) then       !ccccccccccccccccc
ccc                                                               !ccccccccccccccccc
ccc   --- calculate the model year populations for the base year ----
ccc                                                               !ccccccccccccccccc
ccc         do 10 i=1,nyrlif                                       !ccccccccccccccccc
ccc            modpop(i) = modfrc(i) * popval                      !ccccccccccccccccc
ccc   10    continue                                               !ccccccccccccccccc
c                                                               !ccccccccccccccccc
c   --- loop over years to grow total population and calculate model year
c       distribution ---                                        !ccccccccccccccccc
c                                                               !ccccccccccccccccc
ccc         do 20 i=iyrbas+1,ifutyr                                !ccccccccccccccccc
ccc            imb = i - iyrbas                                    !ccccccccccccccccc
c                                                               !ccccccccccccccccc
c   --- apply growth factor to base year population --          !ccccccccccccccccc
c                                                               !ccccccccccccccccc
ccc            popyr = (1.0 + (imb * facgrw)) * popval             !ccccccccccccccccc
ccc            accum = 0.                                          !ccccccccccccccccc
c                                                               !ccccccccccccccccc
c   --- loop through earlier model years to calculate those populations in
c       current year ---                                        !ccccccccccccccccc
c                                                               !ccccccccccccccccc
ccc            do 30 j=nyrlif,2,-1                                 !ccccccccccccccccc
c                                                               !ccccccccccccccccc
c   --- check whether this model year is the base year or earlier.  if so,
c       current year population taken from base year model year !ccccccccccccccccc
c       distribution ---                                        !ccccccccccccccccc
c                                                               !ccccccccccccccccc
ccc                if( i-j+1 .LE. iyrbas ) then                    !ccccccccccccccccc
ccc                    accum = accum + modpop(j)                   !ccccccccccccccccc
c                                                               !ccccccccccccccccc
c   --- if not, use modscp, the fraction of the new population left in current
c       year, and new population --                             !ccccccccccccccccc
c                                                               !ccccccccccccccccc
ccc                else                                            !ccccccccccccccccc
ccc                    modpop(j) = modscp(j) * popsav(imb-j+1)     !ccccccccccccccccc
ccc                    accum = accum + modpop(j)                   !ccccccccccccccccc
ccc                endif                                           !ccccccccccccccccc
ccc   30       continue                                            !ccccccccccccccccc
c                                                               !ccccccccccccccccc
c   --- find current model year population from difference between total
c       population and populations of earlier model years ---   !ccccccccccccccccc
c                                                               !ccccccccccccccccc
ccc            modpop(1) = popyr - accum                           !ccccccccccccccccc
c                                                               !ccccccccccccccccc
c   --- use this value to find total population of current model year
c       equipment and save, so that scrappage can be applied to it
c       to find this model year population in later years ---   !ccccccccccccccccc
c                                                               !ccccccccccccccccc
c   --- first, correct for scrappage that is implicitly in first year
c       population value. then double to estimate population for entire first
c       year --                                                 !ccccccccccccccccc
c                                                               !ccccccccccccccccc
ccc            popsav(imb) =  modpop(1) / modscp(1)                !ccccccccccccccccc
c                                                               !ccccccccccccccccc
ccc   20    continue                                               !ccccccccccccccccc
c                                                               !ccccccccccccccccc
c   --- readjust modfrc to incorporate growth. these fractions are referenced
c       to base year population, so they do not add to 1.0 ---  !ccccccccccccccccc
c                                                               !ccccccccccccccccc
ccc         do 50 i=1,nyrlif                                       !ccccccccccccccccc
ccc            modfrc(i) = modpop(i)/popval                        !ccccccccccccccccc
ccc   50    continue                                               !ccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
c
c
   51    continue
c
c   --- if "future year" is earlier than base year --
c   
ccc   else
cccccccccccccccc     else
c
c   --- find "future year" population from base year ---
c          
         popyr = MAX(0.0,(1.0 + ((ifutyr-iyrbas) * facgrw)) * popval)
c
c   --- reset uniform sales model year fractions for "future year" to base 
c       year reference (fractions do not add to 1.0) ---
c         
         modtot = 0.
         do 60 i=nyrlif,1,-1
            if( popyr .LE. 0 .OR. modtot .GE. INT(popyr)+1 ) then
                modpop(i) = 0.0
            else
                modpop(i) = popval * modfrc(i)
                modpop(i) = MAX(0.0, modpop(i) - modfrc(i) * 
     &                                             (popval-popyr) )
                if( modtot + modpop(i) .GT. popyr ) 
     &                                modpop(i) = popyr - modtot
            endif
            modtot = modtot + modpop(i)
   60    continue     
c      
c   --- readjust modfrc to incorporate decrease, these fractions are referenced
c       to base year population, so they do not add to 1.0 ---
c
         do 70 i=1,nyrlif
            modfrc(i) = modpop(i)/popval
   70    continue
ccccccccccc   endif
cccccccccccccccccccccccc      endif
c
c   --- return to calling routine ----
c
      goto 9999
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
