c**** CLCEMS
c
      subroutine clcems(ierr, emsday, emsbmy,
     &             idxyr, idxtec, idxtch, dage, detcap, adetcf, bdetcf,
     &             idxunt, tfrac, hpval, denful, bsfval, iact, adjems,
     &             emsfac, tpltmp, sadj, pop, mfrac, ndays, tvol, afac,
     &             refmod, fulcsm )
c
c-----------------------------------------------------------------------
c  
c   This routine calculates emissions
c      Argument descriptions:
c        Outputs:
c          ierr    I   error flag
c          emsday  R   calculated emissions
c          emsbmy  R   calculated emissions by-model-year
c        Inputs:
c          idxyr   I   year index
c          idxtec  I   technology type index
c          idxtch  I   number of technology types 
c          dage    R   age of deterioration
c          detcap  R   cap on age of equip for deterioration calc
c          adetcf  R   A coefficient of deterioration factor equation
c          bdetcf  R   B coefficient of deterioration factor equation
c          idxunt  I   index of unit conversion
c          tfrac   R   technology type fraction
c          hpval   R   horsepower
c          denful  R   fuel density
c          bsfval  R   bsfc value
c          iact    I   activity index
c          adjems  R   adjustment factors
c          emsfac  R   emission factors
c          sadj    R   starts hour
c          tpltmp  R   temporal adjustment factor
c          pop     R   population
c          mfrac   R   model year fraction
c          ndays   I   number of period days
c          tvol    R   tank volume
c          afac    R   activity adjustment
c          refmod  C   refueling mode
c          fulcsm  R   fuel consumption
c          cfrac   R   fuel carbon fraction
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/8/98  --mmj-- taken from the process routines 'prcxxx'
c      02/10/00 mjimenez added error to diurnal calc if no spillage file
c      01/19/01 charvey adds code for T3 & T4 sulfur PM adjustment.
c      06/11/01 -3 charvey mods vapor disp equation from NEVES to ORVR.
c      06/14/01 -4 charvey adds carbon fractions by fuel type for CO2.
c      06/25/01 -5 charvey fixes carbon fract: IDXGS2/4, not IDXGAS.
c      08/03/01 -6 charvey tries T5 sulf PM adj using ".LT. T4" code
c      08/31/01 -7 charvey/bgiannelli remove unused modscp declaration.
c      09/28/01 -11 charvey fixes SOx calc for LPG & CNG. 
c      10/30/01 -12 charvey allow CI base sulfur input in OPT file packet.
c      02/26/02 -13 charvey: T4 & T4N sulfate conversion 30% from 2.2% for SOX & PM.
c      03/14/02 -14 charvey: fix stage II to only apply to pump refueling.
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdeqp.inc'
      include 'nonrdact.inc'
      include 'nonrdusr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      real*4      emsday(MXPOL)
      real*4      emsbmy(MXPOL)
c
      character*9 refmod
      integer*4    ierr
      integer*4   idxyr
      integer*4   idxtec
      integer*4   idxtch
      integer*4   idxunt(MXPOL,MXTECH)
      integer*4   iact
      integer*4   ndays
      real*4      dage
      real*4      detcap(MXPOL,MXTECH)
      real*4      adetcf(MXPOL,MXTECH)
      real*4      bdetcf(MXPOL,MXTECH)
      real*4      tfrac
      real*4      hpval
      real*4      denful
      real*4      bsfval
      real*4      adjems(MXPOL)
      real*4      emsfac(MXAGYR,MXPOL,MXTECH)
      real*4      sadj
      real*4      tpltmp
      real*4      pop
      real*4      mfrac
      real*4      tvol
      real*4      afac
      real*4      fulcsm, soxcnv, stg2tmp
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   unitcf   R   returns unit conversion factor
c   fndchr   I   returns the index of string in array of strings  
c
      real*4    unitcf
      integer*4 fndchr
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer*4    idxspc, idxalt
      real*4       cvtbck, tempds, sulbas
      real*4       detrat, emstmp,  emiss, cvttmp, emsthc
      real*4       cfrac
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
c
c --- calculate emissions for each pollutant ---
c
       do 90 idxspc=1,MXPOL
c
c  --- spillage emissions are a function of tank volume  ---
c  --- different for container or gas pump (gas only)    ---
c
          if( idxspc .EQ. IDXSPL )  then
             if ( lfacfl(IDXSPL) .AND. refmod .NE. '         ' ) then
                if ( ifuel .EQ. IDXGS2 .OR. ifuel .EQ. IDXGS4 )  then
                   if( refmod .EQ. PUMP ) then
                     emiss = PMPFAC / tvol
                   elseif ( refmod .EQ. CNTR )  then
                     emiss = CNTFAC / tvol
                   endif
                else
                   emiss = 0.0
                endif
                emsday(idxspc) = emsday(idxspc) 
     &                           + emiss * CVTTON * fulcsm
                emsbmy(idxspc) = emiss * CVTTON * fulcsm
             else
                emsday(idxspc) = RMISS
                emsbmy(idxspc) = RMISS
             endif
             goto 90
          endif
c
c  ---- vapor displacement emissions are a function of ambient temp and RVP ---
c  ---  different for container or gas pump (gas only)                      ---
c
          if( idxspc .EQ. IDXDIS )  then
             if ( lfacfl(IDXSPL) .AND. refmod .NE. '         ' ) then
                if ( ifuel .EQ. IDXGS2 .OR. ifuel .EQ. IDXGS4 )  then
                   if( refmod .EQ. PUMP ) then
                     tempds =  62 + 0.6 * (amtemp - 62.)
                   elseif (refmod .EQ. CNTR )  then
                     tempds = amtemp
                   endif
                   emiss = EXP( -1.2798 - 0.0049 * (tempds - amtemp)
     &                      + 0.0203 * tempds + 0.1315 * fulrvp )
c
c                  emiss =  -5.909 - 0.0949 * (amtemp - tempds) 
c    &                       + 0.0884 * tempds + 0.485 * fulrvp
                else
                   emiss = 0.0
                endif
                if( refmod .EQ. PUMP ) then
                  stg2tmp = stg2fac
                else
                  stg2tmp = 1.0
                endif
                emsday(idxspc) = emsday(idxspc) 
     &                          + emiss * CVTTON * fulcsm * stg2tmp
                emsbmy(idxspc) = emiss * CVTTON * fulcsm * stg2tmp
             else
                emsday(idxspc) = RMISS
                emsbmy(idxspc) = RMISS
             endif
             goto 90
          endif
c
c  --- calculate the detrioration rate from values retrieved earlier ----
c
          if( dage .LE. detcap(idxspc,idxtec) ) then
              detrat = 1. + adetcf(idxspc,idxtec) * 
     &                         dage**bdetcf(idxspc,idxtec)
          else
              detrat = 1. + adetcf(idxspc,idxtec)
          endif
c
c  --- call routine to get the units converion for this species ---
c
          cvttmp = unitcf( idxunt(idxspc,idxtec),hpval,iact,
     &                                    denful,bsfval )
          emstmp = emsfac(idxyr,idxspc,idxtec) * cvttmp * detrat * 
     &                                                  adjems(idxspc)
c
c   --- save the THC exhaust emission factor for use later ---
c
          if( idxspc .EQ. IDXTHC ) emsthc = 
     &                emsfac(idxyr,idxspc,idxtec) * cvttmp * detrat
c
c   --- calculate the SOx emissions from the HC emission factor ---
c
          if( idxspc .EQ. IDXSOX .AND. tfrac .GT. 0. ) then
              cvtbck = 1.0 / (hpval * faclod(iact) )
cc
              soxcnv = soxfrc(ifuel)
c
c  --- look for alternate sulfur conversion factor by tech type ---
c
              idxalt = fndchr( 
     &                      tectyp(idxtch,idxtec), 10, sultec, numalt )
              if( idxalt .GT. 0 .AND. sulcnv(idxalt) .GE. 0.) 
     &                                          soxcnv = sulcnv(idxalt)
c
              emsfac(idxyr,idxspc,idxtec) = hpval * faclod(iact) * 
     &           ( bsfval * 453.6 * (1.0 - soxcnv)
     &             - emsthc*cvtbck ) * 0.01*soxbas(ifuel) * 2.0
              emstmp = emsfac(idxyr,idxspc,idxtec) * adjems(idxspc)
          endif
c
c  --- calculate the Crankcase emission factor from HC emission factor ----
c
          if( idxspc .EQ. IDXCRA .AND. tfrac .GT. 0 
     &                  .AND. emsfac(idxyr,IDXTHC,idxtec) .GT. 0.0 
     &                      .AND. emsfac(idxyr,IDXCRA,idxtec) .GT. 0.0 )
     &          emstmp = emsfac(idxyr,idxspc,idxtec) * emsthc
c
c  --- special case for CO2, CO2 emissions are just a function of BSFC ---
c
          if( idxspc .EQ. IDXCO2 .AND. tfrac .GT. 0 ) then
              cvtbck = 1.0 / (hpval * faclod(iact) )
              if( ifuel .EQ. IDXGS2 .OR. ifuel .EQ. IDXGS4 ) then
                cfrac = CMFGAS
              elseif( ifuel .EQ. IDXDSL ) then
                cfrac = CMFDSL
              elseif( ifuel .EQ. IDXLPG ) then
                cfrac = CMFLPG
              elseif( ifuel .EQ. IDXCNG ) then
                cfrac = CMFCNG
              endif
              emsfac(idxyr,idxspc,idxtec) =  hpval * faclod(iact) * 
     &           ( bsfval * 453.6 - emsthc*cvtbck ) * cfrac * 44./12.
             emstmp = emsfac(idxyr,idxspc,idxtec) * detrat
          endif 
c
c  --- Correction for sulfur content to PM, need to wait until
c      now because the correction factor uses BSFC which is by
c      technology type.  ---
c
          if( idxspc .EQ. IDXPM .AND. ifuel .EQ. IDXDSL) then
            sulbas = soxbas(IDXDSL)
c
c  --- Loop check if there is any alternate base sulfur level
c      for this techtype. ---
c
            idxalt = fndchr( tectyp(idxtch,idxtec), 10, sultec, numalt)
            if( idxalt .GT. 0 .AND. sulalt(idxalt) .GE. 0. ) 
     &                                           sulbas = sulalt(idxalt)
c
c  --- '1.0' means no PM adjustment: in-use expected to equal cert sulfur.
c       (but it is not a multiplicative factor).
c
            if( sulbas .NE. 1.0 ) then
c
              soxcnv = soxfrc(ifuel)
              if( idxalt .GT. 0 .AND. sulcnv(idxalt) .GE. 0.) 
     &                                          soxcnv = sulcnv(idxalt)
c
              emstmp = emstmp - bsfval * 453.6 * hpval *
     &          faclod(iact) * 7.0 * soxcnv * 0.01 * (sulbas - soxdsl)
            endif
          endif
c
c  ---- Hot soak and starts depend on number of starts ---
c
          if( idxspc .EQ. IDXSOK .OR. idxspc .GE. IDSTHC) then
             emiss = emstmp * sadj * 
     &            tpltmp * pop * mfrac * tchfrc(idxtch,idxtec)
c
c  ---- diurnal emissions are different ---
c
          else if( idxspc .EQ. IDXDIU ) then
            if ( ifuel .EQ. IDXGS2 .OR. ifuel .EQ. IDXGS4 )  then
             if( idxunt(idxspc,idxtec) .EQ. IDXTNK ) then
                if ( lfacfl(IDXSPL) .AND. tvol .GT. 0 ) then
                   emiss = emstmp * ndays * tvol * 
     &                 pop * mfrac * tchfrc(idxtch,idxtec)
                else
                     goto 7000
                endif
             else if( idxunt(idxspc,idxtec) .EQ. IDXGDY ) then
                emiss = emstmp * ndays * 
     &              pop * mfrac * tchfrc(idxtch,idxtec)
             else
                emiss = emstmp * afac * tpltmp *
     &              pop * mfrac * tchfrc(idxtch,idxtec)
             endif
            endif
c
c  ---- "normal" exhaust species ---
c
          else
             if( idxunt(idxspc,idxtec) .EQ. IDXGDY ) then
                 emiss = emstmp * ndays * tpltmp *
     &               pop * mfrac * tchfrc(idxtch,idxtec)
             else
                 emiss = emstmp * afac * tpltmp *
     &               pop * mfrac * tchfrc(idxtch,idxtec)
             endif
          endif
c
          if( emsfac(idxyr,idxspc,idxtec) .LT. 0.
     &                         .OR. emsday(idxspc) .LT. 0.0 ) then
              emsday(idxspc) = RMISS
              emsbmy(idxspc) = RMISS
          else
              emsday(idxspc) = emsday(idxspc) + emiss * CVTTON
              emsbmy(idxspc) = emiss * CVTTON
          endif
c
   90  continue
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)')
     &                 'ERROR:  Tank volume required for diurnal ',
     &                'calc when emission factor units are ', KEYTNK
      write(IOWMSG,'(/,1X,3A)')
     &                 'ERROR:  Tank volume required for diurnal ',
     &                'calc when emission factor units are ', KEYTNK
      goto 9999
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
