C     Last change:  GK    2 Oct 1998    2:23 pm
C**** RDMARTCH
c
      subroutine rdmartch( ierr )
c
c-----------------------------------------------------------------------
c
c    reads MARINE exhaust technology packet
c    for the commercial marine module of the NONROAD program.
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/24/97  --gkohlbach-- cloned from rmexhman.for for marine model
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdcmr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4     ierr
c
c-----------------------------------------------------------------------
c     Common block variables
c-----------------------------------------------------------------------
c   tchscc  C   SCC code for the technology type
c   tchlyr  I   Last Calendar Year for the technology type
c   tchtyp  R   Technology type fractions
c
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin  I   returns the actual length of a string (min of 1)
c   fndchr  I   returns the index of string in array of strings
c   fndkey
c
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*(4*MXSTR) line
      character*20        keywrd, keyin
      integer*4           irec, jerr
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 0
c
c   --- call routine to find the /TECHNOLOGY/ packet ----
c
      keywrd = '/TECHNOLOGY/'
      call fndkey( jerr, IOREMS, keywrd )
      if( jerr .NE. ISUCES ) then
          ierr = ISUCES
          goto 9999
      endif
c
c   --- read a record as a character string --- 
c
  111 continue
      read(IOREMS,8002,ERR=7000,END=7000) line
      call mspinit()
c
c   --- check for the end keyword ---
c
      irec = irec + 1
      keyin = line(1:10)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 222
c
c   --- parse the line
c    +- read SCC
c
      tchscc(irec) = line(1:10)
      call lftjst( tchscc(irec) )
      call low2up( tchscc(irec) )
c
c    +- last year valid
c
      read(line(11:17),'(I7)',ERR=7001) tchlyr(irec)
c
c    +- read technology type 1
c
      read(line(30:37),'(F8.0)',ERR=7011) tchtyp(1,irec)
c
c    +- read technology type 2
c
      read(line(38:45),'(F8.0)',ERR=7021) tchtyp(2,irec)
c
c    +- read technology type 3
c
      read(line(46:53),'(F8.0)',ERR=7031) tchtyp(3,irec)
c
c    +- read technology type 4
c
      read(line(54:61),'(F8.0)',ERR=7041) tchtyp(4,irec)
c
c   --- get the next record ---
c
       goto 111
c
c   --- finished reading file ---
c
  222 continue
      ierr = ISUCES
      ntchrc = irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999) 'ERROR:  Reading from ',
     &           emfcfl, ', the marine emmission factors file.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 'ERROR:  Reading from ',
     &           emfcfl, ', the marine emmission factors file.'
      goto 9999
c
 7001 continue
      write(IOWSTD,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading /TECHNOLOGY/ packet. ',
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading /TECHNOLOGY/ packet. ',
     &                               'Line read: ',line(:strmin(line))
      goto 9999
c
 7011 continue
      write(IOWSTD,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading tech type 1. ',
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading tech type 1. ',
     &                               'Line read: ',line(:strmin(line))
      goto 9999
c
 7021 continue
      write(IOWSTD,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading tech type 2. ',
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading tech type 2. ',
     &                               'Line read: ',line(:strmin(line))
      goto 9999
c
 7031 continue
      write(IOWSTD,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading tech type 3. ',
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading tech type 3. ',
     &                               'Line read: ',line(:strmin(line))
      goto 9999
c
 7041 continue
      write(IOWSTD,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading tech type 4. ',
     &                               'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,1X,1A)',ERR=9999)
     &                      'Error reading tech type 4. ',
     &                               'Line read: ',line(:strmin(line))
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 8001 format(20(:,F10.0))
 8002 format(A132)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
