c**** PRC1ST
c
      subroutine prc1st(ierr,icurec,asccod,growth)
c
c-----------------------------------------------------------------------
c  
c   This routine does the prcessing for the state records for a state
c   run.  It performs the the application of all of the emission factors
c   and seasonality factors.
c      Argument descriptions:
c        Outputs:
c          ierr    I   error code
c        Inputs:
c          icurec  I   record number of current record
c          asccod  C   SCC code of current record
c          growth  R   growth value (-9 means not yet calulated)
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      05/20/97  --gmw-- original developnent
c      11/04/99  --mmj-- modified HP bin selection; now based on
c                        HP range midpoint
c      02/10/00 mjimenez tank volume specified in spillage file
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdreg.inc'
      include 'nonrdefc.inc'
      include 'nonrdeqp.inc'
      include 'nonrdalo.inc'
      include 'nonrdgrw.inc'
      include 'nonrdact.inc'
      include 'nonrdusr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4    ierr
      integer*4    icurec
      character*10 asccod
      real*4       growth
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   fndchr   I   returns the index of a string in an array of strings
c   fndact   I   returns the index of record in activity arrays
c   fndgxf   I   returns the index of the record in growth Xref arrays
c   fndrfm   I   returns the index of the refueling mode
c   fndtch   I   returns the index of the technology type
c   dailyf   R   returns a month/day/hour adjustment factor
c   unitcf   R   returns unit conversion factor
c
      integer*4 fndchr
      integer*4 fndact
      integer*4 fndgxf
      integer*4 fndrfm
      integer*4 fndtch
      real*4    dailyf
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*10 tecnam(MXTECH)
      character*9  rfmode(MXTECH)
      character*5  fipin, subcur
      character*4  indcur
      integer*4    jerr, i, idxsta, j, idxref, idxall
      integer*4    idxact(MXTECH), idxgrw, nyrlif, idxyr, iyr
      integer*4    idxunt(MXPOL,MXTECH), iyear, idxtch, ndays
      real*4       popsta, grwsta, grwtmp
      real*4       modfrc(MXAGYR), actadj(MXAGYR), modpop(MXAGYR)
      real*4       modscp(MXAGYR), detage(MXAGYR), stradj(MXAGYR)
      real*4       emsfac(MXAGYR,MXPOL,MXTECH), emsday(MXPOL)
      real*4       thisfc, fulcsm, hplev, bsfc(MXAGYR,MXTECH)
      real*4       tplfac, tpltmp, poptot, acttot, strtot
      real*4       hpval, adjems(MXPOL), tank(MXTECH), hpmid
      real*4       denful, tecfrc(MXTECH)
      real*4       popbmy, actbmy, fulbmy, emsbmy(MXPOL)
      real*4       adetcf(MXPOL,MXTECH), bdetcf(MXPOL,MXTECH)
      real*4       detcap(MXPOL,MXTECH)
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c ---- initialize the error code ---
c
      ierr = IFAIL
      iyear = iepyr
      subcur = ' '
c
c  --- get the index of this county ---
c
      fipin = regncd(icurec)(1:5) 
      idxsta = fndchr( fipin, 5, statcd, NSTATE )
      if( idxsta .LE. 0 ) then
          ierr = ISKIP 
          goto 9999
      endif
      nstarc(idxsta) = nstarc(idxsta) + 1
c
c  --- find HP level for this HP category ---
c
      hpmid = (hprang(1,icurec)+hprang(2,icurec)) / 2.
      if( hpmid .LE. hpclev(1) ) then
         hplev = hpclev(1)
      else if( hpmid .GT. hpclev(MXHPC) ) then
         hplev = 9999
      else
         hplev = -9.
         do 10 i=2,MXHPC
           if( hplev .LT. 0. .AND. hpmid .LT. hpclev(i) ) 
     &                                               hplev = hpclev(i)
   10    continue
      endif
      hpval = avghpc(icurec)
c
c  --- if the population is zero, just write the records and return ---
c
      do 20 i=1,MXPOL
        emsday(i) = 0.
   20 continue
      if( popeqp(icurec) .LE. 0. ) then
         call wrtdat(jerr,fipin,subcur,asccod,hplev,0.,0.,0.,emsday)
         if( jerr .NE. ISUCES ) goto 9999
         ierr = ISUCES 
         goto 9999
      endif
      popsta = popeqp(icurec)
c
c  --- call routine to find the number of technology types for this
c      piece of equipment ---
c
      idxtch = fndtch(asccod,hpval,iyear)
      if( idxtch .LE. 0 ) then
         write(IOWMSG,'(/,1X,3A,1X,F7.1)',ERR=9999) 'WARNING:  Could ',
     &            'not find any technology fractions for equipment: '
         write(IOWMSG,'(10X,A,10X,A)',ERR=9999) 'SCC code','Average HP'
         write(IOWMSG,'(10X,A,7X,F7.1)',ERR=9999) asccod,hpval
         write(IOWMSG,'(8X,A)',ERR=9999) 'Skipping...'
         call chkwrn(jerr,IDXWTC)
         if( jerr .NE. ISUCES ) goto 9999
         ierr = ISKIP
         goto 9999
      endif
c
c   --- find the fuel density, used for fuel consumption calc ---
c
      denful = 1.0
      if( ifuel .EQ. IDXGS2 .OR. ifuel .EQ. IDXGS4 ) then
         denful = DENGAS
      else if( ifuel .EQ. IDXCNG ) then
         denful = DENCNG
      else if( ifuel .EQ. IDXLPG ) then
         denful = DENLPG
      else if( ifuel .EQ. IDXDSL ) then
         denful = DENDSL
      endif
c
c  --- initialize daily emissions to zero ---
c
      do 30 i=1,MXPOL
         emsday(i) = 0.0
   30 continue
c
c   --- call routine to get the monthly, daily, and hourly adjustment ---
c
      tplfac = dailyf( ndays, asccod, fipin )
c
c   --- call the routine to find the growth factor indicator in the
c       cross reference arrays ----
c
      idxgrw = 0
CCC      if( iyear .NE. ipopyr(icurec) ) then
         if( .NOT. lgrwfl ) goto 7003
         idxgrw = fndgxf( fipin, asccod, avghpc(icurec) )
         if( idxgrw .LE. 0 ) goto 7001
CCC      endif
c
c   --- loop over technology types, looking for activity data ---
c
      do 40 i=1,ntech(idxtch)
         tecfrc(i) = tchfrc(idxtch,i)
         tecnam(i) = tectyp(idxtch,i)
         idxact(i) = fndact( asccod, fipin, tecnam(i), avghpc(icurec) )
         if( idxact(i) .LE. 0 ) then
            write(IOWMSG,9000,ERR=9999) 
     &             'WARNING:  Could not find any activity data for: ',
     &                       'County','SCC','Tech','HP range',
     &                               statcd(idxsta),asccod,tecnam(i),
     &                               hprang(1,icurec),hprang(2,icurec)
            call chkwrn(jerr,IDXWAC)
            if( jerr .NE. ISUCES ) goto 9999
            do 50 j=1,MXPOL
               emsday(j) = RMISS
   50       continue
            call wrtdat(jerr,fipin,subcur,asccod,
     &                                   hplev,RMISS,RMISS,RMISS,emsday)
            if( jerr .NE. ISUCES ) goto 9999
            ierr = ISUCES
            goto 9999
         endif
c
c  --- set the maximum on the tank volume ----
c  --- removed from activity file and inidcated in spillage data ---
c
c follows fndrfm     tank(i) = MIN( tnkvol(idxact(i))*hpval, TNKMAX )
c
c   --- call routine to get the growth factor data from the file 
c       only if the indicator data has changed ---
c
         if( idxgrw .GT. 0 ) then
             if( indgrx(idxgrw) .NE. indcur ) then
                call getgrw( jerr, indgrx(idxgrw) )
                if( jerr .NE. ISUCES ) goto 9999
                indcur = indgrx(idxgrw)
c
c --- compute the growth factor for this county --- (2/5/96)
c
                call grwfac( jerr, grwtmp,
     &                 ipopyr(icurec), iyear, fipin, indcur )
                if( jerr .NE. ISUCES ) goto 9999
             endif
             grwsta = grwtmp
         endif
c
c  --- call routine to calculate the model year distribution fractions ----
c
         call modyr( modfrc, modscp, stradj, actadj, nyrlif, detage,
     &               usehrs(icurec), discod(icurec), starts(idxact(i)), 
     &               actlev(idxact(i)), iactun(idxact(i)),
     &               faclod(idxact(i)), actage(idxact(i)) )
c
c  --- call routine to calculate the grown populations and model
c      year populations and recalculate model year distribution
c      fractions (modfrc) to incorporate growth ----
c
         call grwclc( modpop, modfrc, modscp, nyrlif, grwsta,
     &                          ipopyr(icurec), iyear, popeqp(icurec))
c
c  --- call routine to get the refueling mode for this SCC and tech type ---
c
         if ( lfacfl(IDXSPL) ) then
            idxall = fndrfm( asccod, hpval, TECDEF )
            idxref = fndrfm( asccod, hpval, tecnam(i) )
            if ( idxref .EQ. 0 )  idxref = idxall
            if ( idxref .GT. 0 )  then
               rfmode(i) = modspl(idxref)
               if ( untspl(idxref) .EQ. GALLON )  then
                  tank(i) = volspl(idxref)
               elseif ( untspl(idxref) .EQ. GALHP )  then
                  tank(i) = MIN( volspl(idxref)*hpval, TNKMAX )
               endif
            else
c
c   --- no data was found, write a warning message ----
c
               rfmode(i) = '         '
               tank(i) = -9.
               write(IOWMSG,'(/,1X,2A,F6.1,1X,A)',ERR=9999) 
     &               'WARNING:  No Spillage data found for: ',
     &              asccod, hpval, tecnam(i)
               call chkwrn(jerr,IDXWEM)
               if( jerr .NE. ISUCES ) goto 9999
            endif
         endif
c
   40 continue 
c
c  --- set population, activity and starts totals to zero
c
      poptot = 0.0
      acttot = 0.0
      strtot = 0.0  
      fulcsm = 0.0  
c            
c  --- loop over years ----
c
      do 60 iyr=iyear-nyrlif+1,iyear
c
c --- compute relative index -- backwards from absolute year loop ---
c
         idxyr = iyear - iyr + 1
c
c  --- skip it the model year fraction is zero (sometimes happens for
c      the first year in the distribution)
c
         if( modfrc(idxyr) .LE. 0.0 ) goto 60
c
c  --- call routine to find the technology index for this
c      piece of equipment ---
c
         idxtch = fndtch(asccod,hpval,iyr)
         do 70 i=1,ntech(idxtch)
            tecnam(i) = tectyp(idxtch,i)
            tecfrc(i) = tchfrc(idxtch,i)
   70    continue
c
c   --- call routine to calculate the emission factors for this
c       equipment type, all tech types  ---
c
         call emfclc(jerr, emsfac, bsfc, idxunt, adetcf, bdetcf, 
     &                 detcap, asccod, tecnam, ntech(idxtch), tecfrc, 
     &                                              iyr, idxyr, icurec)
         if( jerr .NE. ISUCES ) goto 9999
c
c   --- call routine to calculate the adjustment factors for the
c       emission factors for this equipment type ---
c
         call emsadj( adjems, asccod )
c
c   --- loop over all tech types and sum up the emissions ---
c
         do 80 i=1,ntech(idxtch)
c
c   ---- skip over unused technology types
c
            if( tchfrc(idxtch,i) .LE. 0. ) goto 80
c
c   --- set the local variable for temporal adjustment factor ---
c
            if( iactun(idxact(i)) .EQ. IDXHRY .OR. 
     &                       iactun(idxact(i)) .EQ. IDXGLY ) then
                 tpltmp = tplfac
            else if( iactun(idxact(i)) .EQ. IDXHRD .OR. 
     &                       iactun(idxact(i)) .EQ. IDXGLD ) then
                 tpltmp = 1.0
            endif
c
c   --- calculate fuel consumption ---
c
            thisfc = tpltmp * popsta * 
     &           actadj(idxyr) * modfrc(idxyr) * tchfrc(idxtch,i) *
     &            (hpval * faclod(idxact(i)) * bsfc(idxyr,i) / denful )
            fulcsm = fulcsm + thisfc
c
c  --- fill emissions arrays ---
c
           call clcems (jerr,emsday, emsbmy,
     &            idxyr, i, idxtch, detage(idxyr), detcap,
     &            adetcf, bdetcf, idxunt, tecfrc(i), hpval, denful,
     &            bsfc(idxyr,i), idxact(i), adjems, emsfac, 
     &            tpltmp, stradj(idxyr), popsta, modfrc(idxyr),
     &            ndays, tank(i), actadj(idxyr), rfmode(i), thisfc )
           if( jerr .NE. ISUCES ) goto 9999
c
c  --- calculate the contribution from this tech type ---
c
           popbmy = popsta * modfrc(idxyr) * tchfrc(idxtch,i)
           actbmy = actadj(idxyr) * popsta * modfrc(idxyr) *
     &                                         tpltmp * tchfrc(idxtch,i)
           fulbmy = tpltmp * popsta * actadj(idxyr) * 
     &                         modfrc(idxyr) * tchfrc(idxtch,i) *
     &             (hpval * faclod(idxact(i)) * bsfc(idxyr,i) / denful ) 
c
c  --- call routine to write by-model-year output ---
c
           if ( lbmyfl )  then
                call wrtbmy(jerr,fipin,subcur,asccod,hplev,
     &                               tecnam(i),iyr,popbmy,emsbmy,fulbmy)
                if( jerr .NE. ISUCES ) goto 9999
           endif
c
c  --- call routine to add to totals for SI report ---
c
           if( lsifl .AND. tecfrc(i) .GT. 0.) then
               call sitot(jerr,tecnam(i),popbmy,actbmy,fulbmy,emsbmy)
               if( jerr .NE. ISUCES .AND. jerr .NE. ISKIP ) goto 9999
           endif
c
c  --- next technology type ----
c
   80    continue
c
c --- sum population, activity and starts ---
c 
         poptot = poptot + popsta * modfrc(idxyr)  
         acttot = acttot + actadj(idxyr) * popsta * modfrc(idxyr)*tpltmp
         strtot = strtot + stradj(idxyr) * popsta * modfrc(idxyr)*tpltmp
c
c   --- next year ---
c
   60 continue
c
c************************************************************
c  NOTE:  Fix to alleviate some confusion about fuel 
c         consumption in the reports.  LPG and CNG fuel
c         consumption means something different.
c         CNG is currently CUBIC FEET not Gallons due to DENCNG.
c************************************************************
c
cc    if( ifuel .EQ. IDXLPG .OR. ifuel .EQ. IDXCNG ) fulcsm = 0.
c
c  --- call routine to write the output to the data file ---
c
      call wrtdat(jerr,fipin,subcur,asccod,hplev,poptot,
     &                                             acttot,fulcsm,emsday)
      if( jerr .NE. ISUCES ) goto 9999
c
c  --- all counties processed, return to the calling routine ---
c
      ierr = ISUCES 
      goto 9999
c
c-----------------------------------------------------------------------
c    Error messages:
c-----------------------------------------------------------------------
c
 7001 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find ',
     &                 'match in growth indicator cross reference for: '
      write(IOWSTD,'(10X,A,/,10X,A5,3X,A10,6X,F6.1,2X,F6.1)',ERR=9999) 
     &      'County     SCC              HP range',
     &      fipin, asccod,hprang(1,icurec),hprang(2,icurec)
      write(IOWMSG,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find ',
     &                 'match in growth indicator cross reference for: '
      write(IOWMSG,'(10X,A,/,10X,A5,3X,A10,6X,F6.1,2X,F6.1)',ERR=9999) 
     &      'County     SCC              HP range',
     &      fipin, asccod,hprang(1,icurec),hprang(2,icurec)
      goto 9999
c
 7003 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find the ',
     &                        '/GROWTH FILES/ packet of options file.'
      write(IOWSTD,'(9X,2A)',ERR=9999) 'This packet is required ',
     &                  'for future year projections or backcasting. '
      write(IOWMSG,'(/,1X,2A)',ERR=9999) 'ERROR:  Could not find the ',
     &                        '/GROWTH FILES/ packet of options file.'
      write(IOWMSG,'(9X,2A)',ERR=9999) 'This packet is required ',
     &                  'for future year projections or backcasting. '
      goto 9999
c
c-----------------------------------------------------------------------
c    Format statements:
c-----------------------------------------------------------------------
c
 9000 format(/,1X,A,/,10X,A,6X,A,8X,A,11X,A,/,10X,A,4X,A,4X,A10,2X,
     &       F6.1,1X,F6.1)
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
