C**** NONRDREG.INC
c
c-----------------------------------------------------------------------
c
c    Include file for the region definition data used by the EPA
c    NONROAD program.  It contains data structures for the state names,
c    county names and code as well as the subregion designation.
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c     09/01/93  -gmw-   Original development
c
c-----------------------------------------------------------------------
c   Variables for county and state data:
c-----------------------------------------------------------------------
c
c    statnm    C    name of each state
c    statcd    C    state FIPS codes
c    nconty    I    array of number of counties in each state
c    idxcty    I    index into arrays of fist county in the state
c    cntynm    C    name of each county
c    fipcod    C    array of fips codes selected
c    lfipcd    L    flags to determine if the counties were selected
c    lstacd    L    flag for determining if state was selected
c
      character*20 statnm(NSTATE)
      character*5  statcd(NSTATE)
      character*40 cntynm(NCNTY)
      character*5  fipcod(NCNTY)
      integer*4    nconty(NSTATE)
      integer*4    idxcty(0:NSTATE+1)
      logical*4    lfipcd(NCNTY)
      logical*4    lstacd(NSTATE)
c
      common /regchr/ statcd, fipcod, statnm, cntynm
      common /regdat/ nconty, idxcty, lfipcd, lstacd
