C**** NONRDCMR.INC
c
c-----------------------------------------------------------------------
c   Parameters for marine activity data:
c-----------------------------------------------------------------------
c
c    MRXSCC  I   maximum number of marine source classification codes
c    MRXCTY  I   maximum number of counties for marine model
c    MRXCLS  I   number of size classes
c    MRXMOD  I   number of operational modes analyzed
c    MRXPOL  I   number of pollutant species tracked
c    MARMAN  I maneuver operating mode
c    MARCRU  I cruise operating mode
c    MARFUL  I full operating mode
c    MARSLO  I slow operating mode
c    UNUSED  I unused pollutant code
c
      integer*4 MRXSCC
      integer*4 MRXCTY
      integer*4 MRXCLS
      integer*4 MRXMOD
      integer*4 MRXPOL
      integer*4 MARMAN
      integer*4 MARCRU
      integer*4 MARFUL
      integer*4 MARSLO
      integer*4 UNUSED
c
      parameter( MRXSCC  = 300 )
      parameter( MRXCTY  = 200 )
      parameter( MRXCLS  =   6 )
      parameter( MRXMOD  =   5 )
      parameter( MRXPOL  =   7 )
      parameter( MARMAN  =   1 )
      parameter( MARCRU  =   2 )
      parameter( MARFUL  =   3 )
      parameter( MARSLO  =   4 )
      parameter( UNUSED  =   4 )
c
c-----------------------------------------------------------------------
c   Variables for technology type data
c-----------------------------------------------------------------------
c
c    tchscc  C   SCC code for the technology type
c    tchlyr  I   Last Calendar Year for the technology type
c    tchtyp  R   Technology type fractions
c    ntchrc  I   number of records in tch arrays
c
      character*10 tchscc(MRXSCC)
      integer*4    tchlyr(MRXSCC)
      real*4       tchtyp(MRXMOD,MRXSCC)
      integer*4    ntchrc
c
      common /tchchr/ tchscc, tchtyp
      common /tchdat/ tchlyr, ntchrc
c-----------------------------------------------------------------------
c   Variables for marine fuel and horsepower data
c-----------------------------------------------------------------------
c
c    fhpscc  C   SCC
c    fhpcls  I   Size Class Group
c    fhptyp  C   Class Type
c    fhpahp  R   average horsepower
c    fhpmxf  R   maximum fuel
c    fhpman  R   %max maneuver
c    fhpcru  R   %max cruise
c    fhpslo  R   %max slow
c    fhpful  R   %max full
c    nfhprc  I   number of records in fhp arrays
c
      character*10 fhpscc(MRXSCC)
      integer*4    fhpcls(MRXSCC)
      character*5  fhptyp(MRXSCC)
      real*4       fhpahp(MRXSCC)
      real*4       fhpmxf(MRXSCC)
      real*4       fhpman(MRXSCC)
      real*4       fhpcru(MRXSCC)
      real*4       fhpslo(MRXSCC)
      real*4       fhpful(MRXSCC)
      integer*4    nfhprc
c
      common /fhpchr/ fhpscc, fhpcls, fhptyp
      common /fhpdat/ fhpahp, fhpmxf, fhpman, fhpcru, fhpslo,
     &                fhpful, nfhprc
c
c-----------------------------------------------------------------------
c   Variables for marine maneuver exhaust data
c-----------------------------------------------------------------------
c
c    manscc  C   scc
c    mancls  I   size class group
c    mantyp  C   class type
c    manuni  C   units
c    manhc   R   maneuver hydrocarbon
c    manco   R   maneuver carbon monoxide
c    mannox  R   maneuver oxides of nitrogen
c    mansox  R   maneuver oxides of sulfur
c    manpm   R   maneuver particulate matter
c    nmanrc  I   number of records in man arrays
c
      character*10 manscc(MRXSCC)
      integer*4    mancls(MRXSCC)
      character*10 mantyp(MRXSCC)
      character*10 manuni(MRXSCC)
      real*4       manhc(MRXSCC)
      real*4       manco(MRXSCC)
      real*4       mannox(MRXSCC)
      real*4       mansox(MRXSCC)
      real*4       manpm(MRXSCC)
      integer*4    nmanrc
c
      common /manchr/ manscc, mancls, mantyp, manuni
      common /mandat/ manhc, manco, mannox, mansox, manpm, nmanrc
c
c-----------------------------------------------------------------------
c   Variables for marine cruise exhaust data
c-----------------------------------------------------------------------
c
c    cruscc  C   scc
c    crucls  I   size class group
c    crutyp  C   class type
c    cruuni  C   units
c    cruhc   R   cruise hydrocarbon
c    cruco   R   cruise carbon monoxide
c    crunox  R   cruise oxides of nitrogen
c    crusox  R   cruise oxides of sulfur
c    crupm   R   cruise particulate matter
c    ncrurc  I   number of records in cru arrays
c
      character*10 cruscc(MRXSCC)
      integer*4    crucls(MRXSCC)
      character*10 crutyp(MRXSCC)
      character*10 cruuni(MRXSCC)
      real*4       cruhc(MRXSCC)
      real*4       cruco(MRXSCC)
      real*4       crunox(MRXSCC)
      real*4       crusox(MRXSCC)
      real*4       crupm(MRXSCC)
      integer*4    ncrurc
c
      common /cruchr/ cruscc, crucls, crutyp, cruuni
      common /crudat/ cruhc, cruco, crunox, crusox, crupm, ncrurc
c
c-----------------------------------------------------------------------
c   Variables for marine full exhaust data
c-----------------------------------------------------------------------
c
c    fulscc  C   scc
c    fulcls  I   size class group
c    fultyp  C   class type
c    fuluni  C   units
c    fulhc   R   full hydrocarbon
c    fulco   R   full carbon monoxide
c    fulnox  R   full oxides of nitrogen
c    fulsox  R   full oxides of sulfur
c    fulpm   R   full particulate matter
c    nfulrc  I   number of records in ful arrays
c
      character*10 fulscc(MRXSCC)
      integer*4    fulcls(MRXSCC)
      character*10 fultyp(MRXSCC)
      character*10 fuluni(MRXSCC)
      real*4       fulhc(MRXSCC)
      real*4       fulco(MRXSCC)
      real*4       fulnox(MRXSCC)
      real*4       fulsox(MRXSCC)
      real*4       fulpm(MRXSCC)
      integer*4    nfulrc
c
      common /fulchr/ fulscc, fulcls, fultyp, fuluni
      common /fuldat/ fulhc, fulco, fulnox, fulsox, fulpm, nfulrc
c
c-----------------------------------------------------------------------
c   Variables for marine slow exhaust data
c-----------------------------------------------------------------------
c
c    sloscc  C   scc
c    slocls  I   size class group
c    slotyp  C   class type
c    slouni  C   units
c    slohc   R   slow hydrocarbon
c    sloco   R   slow carbon monoxide
c    slonox  R   slow oxides of nitrogen
c    slosox  R   slow oxides of sulfur
c    slopm   R   slow particulate matter
c    ntsloc  I   number of records in slo arrays
c
c
      character*10 sloscc(MRXSCC)
      integer*4    slocls(MRXSCC)
      character*10 slotyp(MRXSCC)
      character*10 slouni(MRXSCC)
      real*4       slohc(MRXSCC)
      real*4       sloco(MRXSCC)
      real*4       slonox(MRXSCC)
      real*4       slosox(MRXSCC)
      real*4       slopm(MRXSCC)
      integer*4    nslorc
c
      common /slochr/ sloscc, slocls, slotyp, slouni
      common /slodat/ slohc, sloco, slonox, slosox, slopm, nslorc
c
c-----------------------------------------------------------------------
c   Vriables for marine trip activity data
c-----------------------------------------------------------------------
c
c    tacpor  C   Port ID Code
c    tacscc  C   SCC
c    tachot  C   Hotelling Flag
c    tactrp  I   activity in trips per year
c    tacyr   I   reference year
c    ntacrc  I   number of records processed from trip activity file
c
      character*5  tacpor(MRXSCC)
      character*10 tacscc(MRXSCC)
      character*3  tachot(MRXSCC)
      integer*4    tactrp(MRXSCC)
      integer*4    tacyr(MRXSCC)
      integer*4    ntacrc
c
      common /tacchr/ tacpor, tacscc, tachot
      common /tacdat/ ntacrc, tactrp, tacyr
c
c-----------------------------------------------------------------------
c   variables for marine fleet activity data
c-----------------------------------------------------------------------
c    facscc  C   SCC
c    fachrs  R   Time in Hours per trip
c    factim  R   percent of time in each operating mode
c    facspd  R   speed in each operating mode
c    nfacrc  I   number of records in fac arrays
c
      character*10 facscc(MRXSCC)
      real*4       fachrs(MRXSCC)
      real*4       factim(MRXMOD,MRXSCC)
      real*4       facspd(MRXMOD,MRXSCC)
      integer*4    nfacrc
c
      common /facchr/ facscc
      common /facdat/ fachrs, factim, facspd, nfacrc
c
c-----------------------------------------------------------------------
c   variables for vessel mix data
c-----------------------------------------------------------------------
c    vmxscc  C   SCC
c    vmxfrc  R   vessel fraction
c    vmxsiz  R   size class by scc
c    nvmxrc  I   number of records in vmx arrays
c
      character*10 VMXSCC(MRXSCC)
      real*4       vmxfrc(MRXSCC)
      real*4       vmxsiz(MRXCLS,MRXSCC)
      integer*4    nvmxrc
c
      common /vmxchr/ vmxscc
      common /vmxdat/ vmxfrc, vmxsiz, nvmxrc
c
c-----------------------------------------------------------------------
c   variables for marine ports data and marine SCC crosswalk
c-----------------------------------------------------------------------
c    marfip  C   FIPS code for county
c    marpor  C   Representative port code
c    marsca  R   Scaling factor for port in county.
c    nmarpr  I   number of marine port records
c    mscin   C   internal SCC used for calculating emissions
c    mscout  C   external SCC used for reporting
c    nmscrc  I   number of records in marine SCC crosswalk
c
      character*5   marfip(MRXCTY)
      character*5   marpor(MRXCTY)
      logical*4     lporcd(MRXCTY)
      real*4        marsca(MRXCTY)
      integer*4     nmarpr
      character*10  mscin(100)
      character*10  mscout(100)
      integer*4     nmscrc
c
      common /marchr/ marfip, marpor, mscin, mscout
      common /mardat/ marsca, nmarpr, lporcd, nmscrc
