C**** MODYR
c
      subroutine modyr(modfrc, modscp, stradj, actadj, nyrlif, detage,
     &     uselif, disin, strhrs, acthrs, idxunt, eload, agecod)
c
c-----------------------------------------------------------------------
c
c    This routine calculates the fraction of population still in 
c    service of a certain equipment type.  It uses the hours of service
c    per year and the expected hours of life together with the scrappage
c    curve data.  If the distribution code is not the default code the
c    adjustment factors by year are retrieved and applied.  Otherwise
c    just the annual activity is used for all years.    
c
c    Argument declaration.
c     Outputs:
c       modfrc  R  array of population fractions for each model year
c       modscp  R  array of new equipment fractions not yet scrapped
c                  for each model year
c       stradj  R  array of new adjusted starts hours for each year
c       actadj  R  array of new adjusted activity hours for each year
c       nyrlif  I  number of years in the lifetime 
c       detage  R  age of the engine, used for deterioration calculation
c     Inputs:
c       uselif  R  expected lifespan of equipment in hours
c                  this is currently read from the population file in years
c                  and multiplied by annual use hours here to get total hours
c       disin   C  code that tells which scrappage curve to use
c       strhrs  R  number of starts from activity file
c       acthrs  R  number of hours of use from activity file
c       idxunt  R  index units of activity data
c       eload   R  equipment load factor
c       agecod  C  code that indicates which age vs activity curve to apply
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      06/16/93  --rel--  original development
c      12/18/95  --djk--  modified for EPA offroad
c      07/15/96  --asr--  modified for mid-year evaluation
c      07/21/96  --jlf--  modified to pass back useful life consumed for
c                         deterioration calculation
c      06/10/97  --gwilson-- added switch to do end of year fractions
c                            when doing annual, winter season, or
c                            a late year month
c      11/30/99  -mjimenez- added age vs activity adjustment
c      08/30/01  -rgiannelli- static age dist with backcast growth in it.
c      08/31/01  -charvey- removes all partial year scrap & det. code.
c
c-----------------------------------------------------------------------
c    Include files
c-----------------------------------------------------------------------
c
       include 'nonrdprm.inc'
       include 'nonrdio.inc'
       include 'nonrdefc.inc'
       include 'nonrdeqp.inc'
       include 'nonrdact.inc'
       include 'nonrdusr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      real*4       modfrc(MXAGYR)
      real*4       modscp(MXAGYR)
      real*4       stradj(MXAGYR)
      real*4       actadj(MXAGYR)
      real*4       detage(MXAGYR)
      integer*4    nyrlif
      real*4       uselif
      character*10 disin
      real*4       acthrs
      real*4       strhrs
      integer*4    idxunt
      real*4       eload
      character*10 agecod
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   fndchr   I   returns index of a string in array of strings
c
      integer*4 fndchr
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer*4 i, j, idxalt, idxage
      real*4    adjfac(MXAGYR), fract(MXAGYR), accum, acttmp
      real*4    tmpbin(MXSCRP), tmppct(MXSCRP)
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- initiialize the adjustment factors ----
c
      do 10 i=1,MXAGYR
          adjfac(i) = 1.0
          modfrc(i) = 0.0
   10 continue
c
c   --- search for the alternate scrappage curve applied to this
c       equipment, assume default first ---
c
      do 20 i=1,MXSCRP
         tmpbin(i) = scpbin(i)
CCC         tmppct(i) = scppct(i)
         tmppct(i) = scppct_mod(i)
cc
cc       write(1,*) scppct_mod(i),scppct(i),tmppct(i)
cc         write(IOWMSG,'(2X,A,3F7.3)',ERR=9999)
cc     &      'scppct_mod,scppct,tmppct: ',
cc     &       scppct_mod(i),scppct(i),tmppct(i)
cc
   20 continue
      if( disin .NE. 'DEFAULT' ) then
         idxalt = fndchr( disin, 10, altnam, naltnm )
         if( idxalt .GT. 0 ) then
             do 30 i=1,MXSCRP
                tmpbin(i) = altbin(i)
                tmppct(i) = altpct(idxalt,i)
   30        continue
         else
             write(IOWMSG,'(/,1X,4A)',ERR=9999) 'WARNING:  Cannot ',
     &                 'find /ALTERNATE SCRAPPAGE/ curve ',disin,
     &                            '   Using DEFAULT curve.'
             nwarn = nwarn + 1
         endif
      endif
c
c  --- search for the alternate activity curve to apply ---
c
      idxage = 0
      if ( agecod .NE. 'DEFAULT' )  then
         idxage = fndchr ( agecod, 10, agenam, nagenm )
         if ( idxage .LE. 0 )  then
            write(IOWMSG,'(/,1X,4A)',ERR=9999) 'WARNING:  Cannot ',
     &                  'find /AGE ADJUSTMENT/ curve ', agecod,
     &                  '   Using DEFAULT, no adjustment.'
            nwarn = nwarn + 1
         endif
      endif
c
c   --- set the local variable to be the annual units ---
c
      if( idxunt .EQ. IDXHRY ) then
         acttmp = acthrs
      else if( idxunt .EQ. IDXHRD ) then
         acttmp = acthrs * 365
      else if( idxunt .EQ. IDXGLY .AND. uselif .GT. 0. ) then
         acttmp = 1.0 / (2*uselif)
      else if( idxunt .EQ. IDXGLD .AND. uselif .GT. 0. ) then
         acttmp = 1.0 / (2*uselif)
      endif
c
c   --- find out how many years the equipment will last ----
c
      accum = 0
      if( uselif .LE. 0 ) uselif = 1.0
      do 40 i=1,MXAGYR
         if( accum .LT. 2*uselif ) then
             nyrlif = i
             if ( idxage .LE. 0 )  then
                actadj(i) = acttmp
             else
                if ( accum/uselif .GE. 2 )  then
                   actadj(i) = 0.0
                else if ( accum/uselif .LE. agebin(1) )  then
                   actadj(i) = agepct(idxage,1)/100.0 * acttmp
                else
                   do 35 j = 1, MXUSE
                      if ( accum/uselif .GT. agebin(j) .AND. 
     &                     accum/uselif .LE. agebin(j+1) )  then
                         actadj(i) = agepct(idxage,j)/100.0 * acttmp
                         goto 39
                      endif
   35              continue
   39              continue
                endif
             endif
             stradj(i) = adjfac(i) * strhrs
             accum = accum + actadj(i) * eload
         endif
   40 continue
c
c   --- loop over years, calculate the fraction of life (hp-hours) used and 
c       get percent scrapped from the scappage data. save these to use in
c       grwclc ----
c
      accum = 0. 
      do 50 i=1,nyrlif
c
c   --- if period is towards the end of the year, do a end of 
c       year distribution, first years equipment used only 
c       half a year on average ----
c
cc        if( iprtyp .EQ. IDXANN .OR. 
cc     &        (iprtyp .EQ. IDXSES .AND. iseasn .EQ. IDXWTR ) .OR. 
cc     &            (iprtyp .EQ. IDXMTH .AND. imonth .GE. IDXOCT)  ) then
cc          if (i .EQ. 1) then
cc              accum = accum + 0.50*actadj(1) * eload
cc          else
cc              accum = accum + actadj(i) * eload
cc          endif
c
c   --- since evaluation takes place at mid year, by this time  first year
c       equipment in place has been used only one-fourth of year on average.
c       by the end of the first year, first year equipment in place has been
c       used only one-half year on average.  ---
c
cc        else
cc          if (i .EQ. 1) then
cc              accum = accum + 0.25*actadj(1) * eload
cc          else
cc              accum = accum + actadj(i) * eload
cc          endif
cc        endif
        accum = accum + actadj(i) * eload
cc
c
        if( accum .GT. 0 ) then
           fract(i) = accum / uselif
c
c   ---- save the age of the engine that is used for
c        deterioration calculation ---
c
           detage(i) = accum / uselif
        else
           fract(i) = 0.0
           detage(i) = 0.0
        endif
        if( fract(i) .GE. 2.0 ) then
           modscp(i) = 0.0
        else if( fract(i) .LE. tmpbin(1) ) then
           modscp(i) = 1.0 - (tmppct(1)/100.0)
        else
           do 60 j=1,MXSCRP 
             if( fract(i) .GT. tmpbin(j) .AND. 
     &                                fract(i) .LE. tmpbin(j+1) ) then
                 modscp(i) = 1.0 - (tmppct(j)/100.0)
                 goto 50
             endif
  60       continue
        endif
  50  continue
c 
c  --- correction for when an equipment is all used up in 1 year ---
c
      if( modscp(1) .EQ. 0 ) modscp(1) = 1.0
c
c   --- renormalize the scrappage fractions to get the model year fractions. ---
c   --- since evaluation takes place at mid-year, only half of current year
c       equipment is in place ---
c   --  implicit assumption that new equipment population has been the same
c       each year --
c
cc      if( iprtyp .EQ. IDXANN .OR. 
cc     &        (iprtyp .EQ. IDXSES .AND. iseasn .EQ. IDXWTR ) .OR. 
cc     &            (iprtyp .EQ. IDXMTH .AND. imonth .GE. IDXOCT)  ) then
cc         accum = modscp(1)
cc      else
cc         accum = 0.5*modscp(1)
cc      endif
cc
        accum = modscp(1)
cc
      do 70 i=2,nyrlif
         accum = accum + modscp(i)
   70 continue
      if( accum .NE. 0. ) then
cc         if( iprtyp .EQ. IDXANN .OR. 
cc     &        (iprtyp .EQ. IDXSES .AND. iseasn .EQ. IDXWTR ) .OR. 
cc     &            (iprtyp .EQ. IDXMTH .AND. imonth .GE. IDXOCT)  ) then
cc             modfrc(1) = modscp(1)/accum
cc         else
cc             modfrc(1) = 0.5*modscp(1)/accum
cc         endif
         modfrc(1) = modscp(1)/accum
cc
         do 80 i=2,nyrlif
            if( accum .NE. 0. ) modfrc(i) = modscp(i) / accum
   80    continue
      endif
c
c   --- return to calling routine ----
c
      goto 9999
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
