C**** GETGRW
c
      subroutine getgrw( ierr, indin )
c
c-----------------------------------------------------------------------
c
c    reads the growth indicator data from sorted scratch file.
c    the only data that is saved is for the indicator code specified in 
c    the argument list.
c
c    Argument declaration.
c     Outputs:
c       ierr    I  error flag
c     Inputs:
c       indin   C  indicator code 
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/01/93  --gmw--  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      IMPLICIT NONE
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdgrw.inc'
      include 'nonrdeqp.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4     ierr
      character*4   indin
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin  I   returns the actual length of a string (minumum of 1)
c
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*(MXSTR) line
      character*10      keytmp
      character*5       fiptmp, subtmp
      character*4       indtmp
      integer*4         irec, iyrtmp
      real*4            valtmp
      logical           lpass
      integer*4         MLINE1
      INTEGER           ijk,kij,jki
      REAL              SALESHSTRY(MXSCRP)
      REAL              sumpct, mxfrac
      REAL              pctgrw1
      INTEGER           mxscp
      REAL              TMP(MXSCRP)
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 1
      nrcgrw = 0
      lpass = .TRUE.
c
c   --- read a record as a character string --- 
c
  111 continue
      read(IOSGRW,8000,ERR=7001,END=7001) line
      irec = irec + 1
c
c   --- look for the /END/ keyword ----
c
      keytmp = line(1:10)
      call low2up( keytmp )
      call lftjst( keytmp )
      if( keytmp .EQ. KEYEND ) goto 222
c
c   --- get the indicator code, if it is not the one we want skip
c       the record ----
c
      indtmp = line(17:20)
      call lftjst( indtmp )
      if( indtmp .LT. indin ) goto 111
      if( indtmp .GT. indin ) goto 222
c
c   --- parse the line and load all of the data ----
c
      fiptmp = line(1:5)
      subtmp = line(6:10)
      read(line(16:20),'(I5)',ERR=7003) MLINE1
      read(line(11:15),'(I5)',ERR=7003) iyrtmp
      read(line(26:45),'(F20.0)',ERR=7003) valtmp
c
c   --- store the data in global arrays ----
c
      pctgrw1=0.0
      nrcgrw = nrcgrw + 1
      if( nrcgrw .GT. MXGROW ) goto 7004
      fipgrw(nrcgrw) = fiptmp
      subgrw(nrcgrw) = subtmp
      iyrgrw(nrcgrw) = iyrtmp
      valgrw(nrcgrw) = valtmp



      if( nrcgrw .EQ. 2 ) then
c
C 1.  For each SCC, read the first two growth entries in the growth data file
C     (NATION?.GRW) and calculate the linear annual growth rate relative to the
C     first (earlier) year's value.  Currently, these are the entries for calendar
C     years 1996 and 2000, where the 1996 entry is always arbitrarily set to 1,000,
C     and the year 2000 entry is 1,000 plus whatever relative growth is assumed for
C     that category.  E.g., for diesel farm equipment, the year 2000 entry is currently
C     1,126, indicating a linear growth of (1,126-1,000)/1,000/4yrs = 3.15% per year
C     relative to a 1996 baseline.
C
         pctgrw1=(valtmp-valgrw(1))/
     &                              (valgrw(1)*(iyrtmp-iyrgrw(1)))
C
C 2.  For each SCC, create a temporary array the size of MXSCRP, which is a 50 element
C     array, and initialize it with a contrived sales history using the growth rate
C     from Step 1.  I.e., for the example above, the first entry would be 1000, the
C     second would be 1031.5, the third would be 1063.0, etc., increasing by 31.5 each
C     time. Note that Saleshstry used to be opposite order to scppct. 
C
        if( pctgrw1 .GE. 0.0 ) then
          SALESHSTRY(MXSCRP) = 1.0
          SUMPCT=SALESHSTRY(MXSCRP)
          do ijk=MXSCRP-1,1,-1
            SALESHSTRY(ijk)=SALESHSTRY(ijk+1)+pctgrw1
          end do
        else
          SALESHSTRY(1) = 1.0
          SUMPCT=SALESHSTRY(1)
          do ijk=2,MXSCRP
            SALESHSTRY(ijk)=SALESHSTRY(ijk-1)-pctgrw1
          end do
        endif
cc
cc      write(IOWMSG,'(/,1X,A,F7.4)',ERR=9999) 
cc     &    'pctgrw1: ',pctgrw1
cc
C
C 3.  Multiply each value in this temporary array by the corresponding element 
C     of the scrappage array to generate a value for relative number of units 
C     surviving.  Replace the original temporary array value with this new 
C     value. This is shown in column "H" of the attached spreadsheet example
C     (NR-SCRAP.XLS).
C
        scppct_mod(1)=(1.0-(scppct(1)/100.))*SALESHSTRY(1)
        sumpct=scppct_mod(1)
        do ijk=2,MXSCRP
          scppct_mod(ijk)=(1.0-(scppct(ijk)/100.))*SALESHSTRY(ijk)
cc
cc        scppct_mod(ijk)=(scppct(ijk)/100.)*SALESHSTRY(ijk)
cc
          sumpct=sumpct+scppct_mod(ijk)
          MXSCP=ijk
          if( scppct(ijk) .GT. 100. ) EXIT
        end do
C
C 4.  Divide each value in the temporary array by the sum of all of the array values,
C     effectively turning it into an age distribution.  Replace each original temporary
C     array value with the new value. This is shown in column "I" of the attached
C     spreadsheet example.
C
        mxfrac = 0.0
        do jki=1,MXSCP
          scppct_mod(jki)=(scppct_mod(jki)/sumpct)
          mxfrac = MAX(scppct_mod(jki),mxfrac)
        end do
C
C 5.  Normalize the values in the temporary array to represent a new version of percent
C     scrapped that includes growth.  This is shown in column "J" of the attached
C     spreadsheet example.
C
        do kij=1,MXSCP
          TMP(kij) = 100*(1.0-(scppct_mod(kij)/mxfrac))
cc
cc        TMP(kij) = 100*(1.0-(scppct_mod(MXSCP-(KIJ-1))/scppct_mod(MXSCP)))
cc
        end do
        do kij=1,MXSCP
           scppct_mod(kij) = TMP(kij)
        enddo
      endif
c
c   --- get the next record ---
c
      goto 111
c
c   --- entire file processed ---
c
 222  continue
c
c --- check if we have input data ---
c
      if( nrcgrw .GE. 1 ) then
c
c --- back up one record for next call ---
c
         backspace IOSGRW
         ierr = ISUCES
         goto 9999
      else
c
c --- if the file was beyond the desired end, then rewind and start from
c     beginning of file ---
c
         if( lpass ) then
            rewind IOSGRW
            lpass = .FALSE.
            irec = 0
            goto 111
         else
             goto 7005
         endif
      endif
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
c
 7001 continue
      write(IOWSTD,'(/,1X,2A,/,9X,A,I10)',ERR=9999) 
     &             'ERROR:  Reading growth scratch file ',
     &                     grwfl(:strmin(grwfl)),'at record ',irec
      write(IOWMSG,'(/,1X,2A,/,9X,A,I10)',ERR=9999) 
     &             'ERROR:  Reading growth scratch file ',
     &                     grwfl(:strmin(grwfl)),'at record ',irec
      goto 9999
c
 7003 continue
      write(IOWSTD,'(/,1X,2A,/,9X,2A)',ERR=9999) 
     &             'ERROR:  Reading growth scratch file ',
     &         grwfl(:strmin(grwfl)),
     &         'Line read: ',line(:strmin(line))
      write(IOWMSG,'(/,1X,2A,/,9X,2A)',ERR=9999) 
     &             'ERROR:  Reading growth scratch file ',
     &         grwfl(:strmin(grwfl)),
     &         'Line read: ',line(:strmin(line))
      goto 9999
c
 7004 continue
      write(IOWSTD,'(/,1X,2A,I5)',ERR=9999) 
     &                 'ERROR:  Number of growth indicator ',
     &                                    'records exceeds max ',MXGROW
      write(IOWMSG,'(/,1X,2A,I5)',ERR=9999) 
     &                 'ERROR:  Number of growth indicator ',
     &                                    'records exceeds max ',MXGROW
      goto 9999
c
 7005 continue
      write(IOWSTD,'(/,1X,3A)',ERR=9999)
     &                            'ERROR:  Growth indicator ',indin,
     &                            ' not found in growth indicator file.'
      write(IOWMSG,'(/,1X,3A)',ERR=9999) 
     &                            'ERROR:  Growth indicator ',indin,
     &                            ' not found in growth indicator file.'
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
