C     Last change:  GK   28 Sep 1998   11:25 am
C**** FNDMEF
c
      function fndmef(ascin,clsin,ascar,clsar,nmefrc)
      integer*4 fndmef
c
c-----------------------------------------------------------------------
c
c    This routine identifies the index of marine emission factors in the
c    scc and size arrays, which is tied to the emission factor arrays.
c    It searches the arrays using the data supplied in the other
c    arguments.  It finds the best match by matching SCC code hierarchy
c    and size class.
c
c    Return value:
c         > 0   =  index in array of best match
c         = 0   =  no match found
c
c    Arguments:
c
c     Inputs: 
c       ascin      C   SCC code to match
c       clsin      I   size class to match
c       ascar      C   list of SCCs to search
c       clsar      R   list of size classes to search
c       nmefrc     I   number of elements of ascar and clsar
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      09/12/98   --  gfkohlbach, based loosely on fnd*
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdeqp.inc'
      include 'nonrdefc.inc'
      include 'nonrdcmr.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      character*10  ascin
      integer*4     clsin
      character*10  ascar(MXEMFC)
      integer*4     clsar(MXEMFC)
      integer*4     nmefrc
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
      integer*4 fndchr
c
c-----------------------------------------------------------------------
c    Local parameters:
c-----------------------------------------------------------------------
c
c   MXGLB   I  number of codes for global matches
c
      integer*4 MXGLB
c
      parameter( MXGLB = 4 )
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*10 ascglb(MXGLB)
      integer*4    idxasc, idxfac
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- assume no match ----
c
      fndmef = 0
c
c   ---- set up the global matches ----
c
      ascglb(1) = ascin
      ascglb(2) = ascin(1:7)//'000'
      ascglb(3) = ascin(1:4)//'000000'
      ascglb(4) = ascin(1:2)//'00000000'
c
c   ---- loop over all entries in the arrays ----
c
      do 10 idxfac=1,nmefrc
c
c   ---- skip if not correct size class  ---
c
         if( clsin .NE. clsar(idxfac) ) goto 10
c
c   ---- search in arrays for a match of ASC code ----
c
         idxasc = fndchr( ascar(idxfac), 10, ascglb, MXGLB )
         if( idxasc .LE. 0 ) goto 10
c
c   --- set return code and exit
c
      fndmef=idxasc
      goto 9999
c
c   --- get the next array element ----
c
   10 continue
c
c   ---- return to calling routine ----
c
      goto 9999
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
