C**** EMSADJ
c
      subroutine emsadj(adjfac,asccod)
c
c-----------------------------------------------------------------------
c  
c    This routine calculates the various emission adjustment factors.
c    All of the adjustments are incorporated into a single array of
c    factors, indexed by species.
c
c     Argument description:
c       Outputs:
c          adjfac  R   array of caluclated adjustment factors
c       Inputs:
c          asccod  C   SCC code of equipment
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      06/10/97  --gmw--  original development
c      11/10/99  --mmj--  modified oxygenate correction per NR-003
c                         tech report
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdusr.inc'
      include 'nonrdefc.inc'
      include 'nonrdeqp.inc'
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   caludi   R   returns the diurnal "uncontrolled" emission rate
c
      real*4 caludi
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      real*4       adjfac(MXPOL)
      character*10 asccod
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer*4 idxyr, iseas, i
      real*4    stdval, epsval, temfac, acoeff, soxcor, oxyadj
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c   --- initialize the factors to no adjustment ---
c
      do 10 i=1,MXPOL
         adjfac(i) = 1.0
   10 continue 
c
c   --- temperature corrections for diurnal emissions ---
c
      if( ifuel .EQ. IDXGS2 .OR. ifuel .EQ. IDXGS4 ) then
        stdval = caludi( 9.0, 60.0, 84.0, 40.0 ) 
        epsval = caludi( fulrvp, tempmn, tempmx, 40.0 ) 
        if( stdval .NE. 0. ) adjfac(IDXDIU) = 
     &                                adjfac(IDXDIU) * epsval/stdval
      endif
c
c   --- temperature corrections for exhaust emissions ---
c       (NOTE: 2-stroke is included in case data becomes available,
c       we need only change the coefficients ) ----
c
c   --- Gasoline 4-stroke ----
c
      if( ifuel .EQ. IDXGS4 ) then
         if( amtemp .LE. 75.0 ) then
             acoeff = -0.00240
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXTHC) = adjfac(IDXTHC) * temfac
c
             acoeff = 0.0015784
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXCO) = adjfac(IDXCO) * temfac
c
             acoeff = -0.00892
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXNOX) = adjfac(IDXNOX) * temfac
         else
             acoeff = 0.00132
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXTHC) = adjfac(IDXTHC) * temfac
c
             acoeff = 0.00375
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXCO) = adjfac(IDXCO) * temfac
c
             acoeff = -0.00873
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXNOX) = adjfac(IDXNOX) * temfac
         endif
      endif
c
c   --- Gasoline 2-stroke ----
c
      if( ifuel .EQ. IDXGS2 ) then
         if( amtemp .GE. 75.0 ) then
             acoeff = 0.0
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXTHC) = adjfac(IDXTHC) * temfac
c
             acoeff = 0.0
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXCO) = adjfac(IDXCO) * temfac
c
             acoeff = 0.0
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXNOX) = adjfac(IDXNOX) * temfac
         else
             acoeff = 0.0
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXTHC) = adjfac(IDXTHC) * temfac
c
             acoeff = 0.0
             temfac = EXP( acoeff * (amtemp - 75.0) )
             adjfac(IDXCO) = adjfac(IDXCO) * temfac
         endif
      endif
c
c   --- oyxgenate correction to gasoline exhaust ---
c       (NOTE: 2-stroke is included in case data becomes, we need 
c       only change the coefficients ) ----
c
c   --- Gasoline 4-stroke ----
c
      if( .NOT. lrfg .AND. ifuel .EQ. IDXGS4 ) then
          acoeff = 0.045
          oxyadj = 1.0 - ( acoeff * oxypct )
          adjfac(IDXTHC) = adjfac(IDXTHC) * oxyadj
c
          acoeff = 0.063
          oxyadj = 1.0 - ( acoeff * oxypct )
          adjfac(IDXCO) = adjfac(IDXCO) * oxyadj
c
          acoeff = -0.115
          oxyadj = 1.0 - ( acoeff * oxypct )
          adjfac(IDXNOX) = adjfac(IDXNOX) * oxyadj
      endif
c
c   --- Gasoline 2-stroke ----
c
      if( .NOT. lrfg .AND. ifuel .EQ. IDXGS2 ) then
          acoeff = 0.006
          oxyadj = 1.0 - ( acoeff * oxypct )
          adjfac(IDXTHC) = adjfac(IDXTHC) * oxyadj
c
          acoeff = 0.065
          oxyadj = 1.0 - ( acoeff * oxypct )
          adjfac(IDXCO) = adjfac(IDXCO) * oxyadj
c
          acoeff = -0.186
          oxyadj = 1.0 - ( acoeff * oxypct )
          adjfac(IDXNOX) = adjfac(IDXNOX) * oxyadj
      endif
c
c   --- correction for sulfur content on SOx ---
c
      if( .NOT. lrfg .AND. ifuel .GT. 0 .AND. ifuel .LE. IDXCNG ) then
          soxcor = soxful(ifuel) / soxbas(ifuel)
          adjfac(IDXSOX) = adjfac(IDXSOX) * soxcor
      endif
c
c   --- correction for altitude ---
c
      if( lhigh .AND. ifuel .GT. 0 .AND. ifuel .LE. IDXCNG ) then
          do 20 i=IDXTHC,IDXSOX
             adjfac(i) = adjfac(i) * altfac(ifuel)
   20     continue
      endif
c
c   --- correction for RFG ---
c
      iseas = 0
      idxyr = 0
      if( lrfg .AND. imonth .GT. 0 ) iseas = idseas(imonth)
      if( iseas .EQ. IDXWTR .OR. iseas .EQ. IDXSUM ) then
         do 30 i=1,NRFGBIN
             if( iepyr .GE. iyrbin(iseas,i,1) .AND. 
     &                       iepyr .LE. iyrbin(iseas,i,2) ) idxyr = i
   30    continue
c
         if( ifuel .EQ. IDXGS2 .AND. idxyr .NE. 0 ) then
            adjfac(IDXTHC) = adjfac(IDXTHC) * rfggs2(iseas,idxyr,IDXTHC) 
            adjfac(IDXCO) = adjfac(IDXCO) * rfggs2(iseas,idxyr,IDXCO) 
            adjfac(IDXNOX) = adjfac(IDXNOX) * rfggs2(iseas,idxyr,IDXNOX) 
            adjfac(IDXSOX) = adjfac(IDXSOX) * rfggs2(iseas,idxyr,IDXSOX) 
            adjfac(IDXPM) = adjfac(IDXPM) * rfggs2(iseas,idxyr,IDXPM) 
         endif
         if( ifuel .EQ. IDXGS4 .AND. idxyr .NE. 0 ) then
            adjfac(IDXTHC) = adjfac(IDXTHC) * rfggs4(iseas,idxyr,IDXTHC) 
            adjfac(IDXCO) = adjfac(IDXCO) * rfggs4(iseas,idxyr,IDXCO) 
            adjfac(IDXNOX) = adjfac(IDXNOX) * rfggs4(iseas,idxyr,IDXNOX) 
            adjfac(IDXSOX) = adjfac(IDXSOX) * rfggs4(iseas,idxyr,IDXSOX) 
            adjfac(IDXPM) = adjfac(IDXPM) * rfggs4(iseas,idxyr,IDXPM) 
         endif
      endif
c
c-----------------------------------------------------------------------
c    Format statements:
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
