C     Last change:  GK   29 Sep 1998   10:40 pm
c
c
      subroutine commar(ierr, mtype, moxy)
c
c-----------------------------------------------------------------------
c
c    Description:
c
c      This routine controls the operation of the commercial marine
c      module.  Starting with a marine module type (mtype) and a marine
c      fuel oxygen percentage, the module determines how to proceed.
c
c   Arguments:
c
c     Outputs:
c       ierr     I   error flag (either ISUCES or IFAIL)
c     Inputs:
c       mtype    C   string containing the type of marine module
c       moxy     R   real value of marine fuel oxygen percentage
c
c-----------------------------------------------------------------------
c   LOG:
c-----------------------------------------------------------------------
c
c     8/10/97  -gkohlbach-  Original development
c
c-----------------------------------------------------------------------
c   Include files:
c-----------------------------------------------------------------------
c
      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdusr.inc'
      include 'nonrdcmr.inc'
c
c-----------------------------------------------------------------------
c   Argument declaration:
c-----------------------------------------------------------------------
c
      integer*4      ierr
      character*10   mtype
      real*4         moxy
c
c-----------------------------------------------------------------------
c   Local variables:
c-----------------------------------------------------------------------
c
c       jerr     R   error flag to check for spawned processes
c
      integer*4         jerr
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
      ierr = IFAIL
c
c   ---- check mtype for validity----
c
      if(mtype .EQ. MARNON) then
         ierr = ISUCES
         goto 9999
      endif
c
c   ---- check marine files packet and verify files exist ----
c
      call intmar(jerr)
      if( jerr .NE. ISUCES ) goto 9999
c
c   ---- read marine ports packet ----
c
      call rdmarpor(jerr)
      if( jerr .NE. ISUCES ) goto 9999
c
c   ---- read marine emission factors file ----
c
      call rdmaremf(jerr)
      if (jerr .NE. ISUCES ) goto 9999
c
c   ---- read marine vessel character file  ----
c
      call rdmarchr(jerr)
      if (jerr .NE. ISUCES ) goto 9999
c
c   ---- read marine trip activity file ----
c
      call rdmartrp(jerr)
      if (jerr .NE. ISUCES ) goto 9999
c
c   ---- read marine source classification code crosswalk file
c
      call rdmscxwk(jerr)
      if (jerr .NE. ISUCES ) goto 9999
c
c   ---- process the data read and write to output data file.
c
      call marcalc(jerr, mtype)
      if (jerr .NE. ISUCES ) goto 9999
c
c   --- successful, set error code and return ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c    Format statements:
c-----------------------------------------------------------------------
c
 9000 format('+',A,/)
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      end
