/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.viewer.context;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import netscape.javascript.JSObject;
import sun.applet.ActivatorAppletAudioClipRef;
import sun.applet.ActivatorAppletImageRef;
import sun.applet.AppletPanel;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.Trace;
import sun.plugin.viewer.AppletPanelCache;
import sun.plugin.viewer.context.PluginAppletContext;

public abstract class DefaultPluginAppletContext
implements PluginAppletContext {
    private AppletPanel appletPanel;
    private static HashMap imageRefs = new HashMap();
    private static HashMap audioClipStore = new HashMap();
    private int persistStreamMaxSize = 65536;
    private static HashMap streamStore = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioClip getAudioClip(URL uRL) {
        Object object;
        if (uRL == null) {
            return null;
        }
        System.getSecurityManager().checkConnect(uRL.getHost(), uRL.getPort());
        ActivatorAppletAudioClipRef activatorAppletAudioClipRef = null;
        HashMap hashMap = audioClipStore;
        synchronized (hashMap) {
            object = (HashMap<URL, ActivatorAppletAudioClipRef>)audioClipStore.get(this.appletPanel.getCodeBase());
            if (object == null) {
                object = new HashMap<URL, ActivatorAppletAudioClipRef>();
                audioClipStore.put(this.appletPanel.getCodeBase(), object);
            }
            if ((activatorAppletAudioClipRef = (ActivatorAppletAudioClipRef)((Object)((HashMap)object).get(uRL))) == null) {
                activatorAppletAudioClipRef = new ActivatorAppletAudioClipRef(uRL);
                ((HashMap)object).put(uRL, activatorAppletAudioClipRef);
            }
        }
        object = (AudioClip)activatorAppletAudioClipRef.get();
        Trace.println(ResourceHandler.getMessage("appletcontext.audio.loaded") + uRL, 2);
        Trace.println(ResourceHandler.getMessage("appletcontext.audio.loaded") + this.getNameFromURL(uRL), 4);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(URL uRL) {
        if (uRL == null) {
            return null;
        }
        System.getSecurityManager().checkConnect(uRL.getHost(), uRL.getPort());
        ActivatorAppletImageRef activatorAppletImageRef = null;
        HashMap hashMap = imageRefs;
        synchronized (hashMap) {
            activatorAppletImageRef = (ActivatorAppletImageRef)((Object)imageRefs.get(uRL));
            if (activatorAppletImageRef == null) {
                activatorAppletImageRef = new ActivatorAppletImageRef(uRL);
                imageRefs.put(uRL, activatorAppletImageRef);
            }
        }
        Image image = (Image)activatorAppletImageRef.get();
        Trace.println(ResourceHandler.getMessage("appletcontext.image.loaded") + uRL, 2);
        Trace.println(ResourceHandler.getMessage("appletcontext.image.loaded") + this.getNameFromURL(uRL), 4);
        return image;
    }

    public Applet getApplet(String string) {
        string = string.toLowerCase();
        Object[] objectArray = AppletPanelCache.getAppletPanels();
        int n = 0;
        while (n < objectArray.length) {
            AppletPanel appletPanel = (AppletPanel)objectArray[n];
            if (appletPanel != null && appletPanel.isActive()) {
                String string2 = appletPanel.getParameter("name");
                if (string2 != null) {
                    string2 = string2.toLowerCase();
                }
                if (string.equals(string2) && appletPanel.getDocumentBase().equals(this.appletPanel.getDocumentBase())) {
                    try {
                        if (!this.checkConnect(this.appletPanel.getCodeBase().getHost(), appletPanel.getCodeBase().getHost())) {
                            return null;
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.showStatus(invocationTargetException.getTargetException().getMessage());
                        return null;
                    }
                    catch (Exception exception) {
                        this.showStatus(exception.getMessage());
                        return null;
                    }
                    return appletPanel.getApplet();
                }
            }
            ++n;
        }
        return null;
    }

    public Enumeration getApplets() {
        Vector<Applet> vector = new Vector<Applet>();
        Object[] objectArray = AppletPanelCache.getAppletPanels();
        int n = 0;
        while (n < objectArray.length) {
            AppletPanel appletPanel = (AppletPanel)objectArray[n];
            if (appletPanel != null && appletPanel.isActive() && appletPanel.getDocumentBase().equals(this.appletPanel.getDocumentBase())) {
                try {
                    if (this.checkConnect(this.appletPanel.getCodeBase().getHost(), appletPanel.getCodeBase().getHost())) {
                        vector.addElement(appletPanel.getApplet());
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.showStatus(invocationTargetException.getTargetException().getMessage());
                }
                catch (Exception exception) {
                    this.showStatus(exception.getMessage());
                }
            }
            ++n;
        }
        return vector.elements();
    }

    private boolean checkConnect(String string, String string2) throws Exception {
        SocketPermission socketPermission = new SocketPermission(string, "connect");
        SocketPermission socketPermission2 = new SocketPermission(string2, "connect");
        return socketPermission.implies(socketPermission2);
    }

    public void showDocument(URL uRL) {
        this.showDocument(uRL, "_top");
    }

    public void showDocument(URL uRL, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isLetterOrDigit(c) || c == '_') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('_');
            }
            ++n;
        }
        this.doShowDocument(uRL, stringBuffer.toString());
    }

    public void doShowDocument(final URL uRL, final String string) {
        DefaultPluginAppletContext defaultPluginAppletContext = this;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    JSObject jSObject = DefaultPluginAppletContext.this.getJSObject();
                    if (jSObject != null) {
                        Object[] objectArray = new Object[]{uRL.toString(), string};
                        jSObject.call("open", objectArray);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }, "showDocument Thread");
        thread.start();
    }

    public void showStatus(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf("\n");
        if (n != -1) {
            this.doShowStatus(string.substring(0, n));
        } else {
            this.doShowStatus(string);
        }
    }

    protected void doShowStatus(final String string) {
        final DefaultPluginAppletContext defaultPluginAppletContext = this;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    JSObject jSObject = defaultPluginAppletContext.getJSObject();
                    if (jSObject != null) {
                        jSObject.eval("function setStatus() { self.status='" + string + "';};" + "void(setTimeout(\"setStatus()\", 1500))");
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }, "showStatus Thread");
        thread.start();
    }

    public void addAppletPanelInContext(AppletPanel appletPanel) {
        this.appletPanel = appletPanel;
        AppletPanelCache.add(appletPanel);
    }

    public void removeAppletPanelFromContext(AppletPanel appletPanel) {
        AppletPanelCache.remove(appletPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAudioClips() {
        try {
            HashMap hashMap = audioClipStore;
            synchronized (hashMap) {
                HashMap hashMap2 = (HashMap)audioClipStore.get(this.appletPanel.getCodeBase());
                if (hashMap2 != null) {
                    Collection collection = hashMap2.values();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        ActivatorAppletAudioClipRef activatorAppletAudioClipRef = (ActivatorAppletAudioClipRef)((Object)iterator.next());
                        activatorAppletAudioClipRef.setDoDownload(false);
                        AudioClip audioClip = (AudioClip)activatorAppletAudioClipRef.get();
                        activatorAppletAudioClipRef.setDoDownload(true);
                        if (audioClip == null) continue;
                        audioClip.stop();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStream(String string, InputStream inputStream) throws IOException {
        HashMap<String, byte[]> hashMap = (HashMap<String, byte[]>)streamStore.get(this.appletPanel.getCodeBase());
        if (hashMap == null) {
            hashMap = new HashMap<String, byte[]>();
            streamStore.put(this.appletPanel.getCodeBase(), hashMap);
        }
        HashMap<String, byte[]> hashMap2 = hashMap;
        synchronized (hashMap2) {
            if (inputStream != null) {
                byte[] byArray = (byte[])hashMap.get(string);
                if (byArray == null) {
                    int n = inputStream.available();
                    if (n >= this.persistStreamMaxSize) throw new IOException("Stream size exceeds the maximum limit");
                    byArray = new byte[n];
                    inputStream.read(byArray, 0, n);
                    hashMap.put(string, byArray);
                } else {
                    hashMap.remove(string);
                    this.setStream(string, inputStream);
                }
            } else {
                hashMap.remove(string);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStream(String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        HashMap hashMap = (HashMap)streamStore.get(this.appletPanel.getCodeBase());
        if (hashMap != null) {
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                byte[] byArray = (byte[])hashMap.get(string);
                if (byArray != null) {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                }
            }
        }
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getStreamKeys() {
        Iterator iterator = null;
        HashMap hashMap = (HashMap)streamStore.get(this.appletPanel.getCodeBase());
        if (hashMap != null) {
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                iterator = hashMap.keySet().iterator();
            }
        }
        return iterator;
    }

    private String getNameFromURL(URL uRL) {
        try {
            String string = uRL.getFile();
            int n = string.lastIndexOf(47);
            return string.substring(n + 1);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

