/*
 * Decompiled with CFR 0.152.
 */
package sun.beanbox;

import java.awt.Toolkit;
import java.beans.Beans;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sun.beanbox.InputStreamProducer;

public class SimpleClassLoader
extends ClassLoader {
    public static final String urlPrefix = "SIMPLE";
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private static boolean debug = false;
    private static boolean keepLoading = true;
    private String cookie;
    private static Hashtable loaders = new Hashtable();
    public static SimpleClassLoader ourLoader;
    private String localResourceDirectory;
    private Hashtable localOverrides = new Hashtable();
    private Hashtable resourceHash = new Hashtable();
    private Hashtable mimeHash = new Hashtable();
    private Hashtable rawClasses = new Hashtable();

    private SimpleClassLoader(String string, String string2) {
        this.cookie = string;
        this.localResourceDirectory = string2;
        loaders.put(string, this);
    }

    public void defineClassFromBytes(String string, byte[] byArray) {
        this.rawClasses.put(string, byArray);
    }

    private Class applyDefinition(String string, boolean bl) {
        byte[] byArray = (byte[])this.rawClasses.get(string);
        this.rawClasses.remove(string);
        if (byArray == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = super.defineClass(null, byArray, 0, byArray.length);
            if (clazz != null && bl) {
                this.resolveClass(clazz);
            }
        }
        catch (ClassFormatError classFormatError) {
            System.err.println("The definition for " + string + " in the JAR file");
            System.err.println("has a format error.");
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        if (!clazz.getName().equals(string)) {
            System.err.println("\nWARNING: file name versus class name mismatch");
            String string2 = string.replace('.', '/') + ".class";
            System.err.println("    JAR entry \"" + string2 + "\" was expected " + "to contain class \"" + string + "\"");
            System.err.println("    but instead contained class \"" + clazz.getName() + "\"");
            System.err.println("    This may cause future class-loading problems.\n");
        }
        return clazz;
    }

    private static byte[] getByteArray(String string) throws IOException {
        File file = new File(string);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(string);
        int n2 = 0;
        while (n2 < n) {
            int n3 = ((InputStream)fileInputStream).read(byArray, n2, n - n2);
            if (n3 < 0) break;
            n2 += n3;
        }
        return byArray;
    }

    public Class loadClassFromFile(String string) throws ClassNotFoundException {
        try {
            byte[] byArray = SimpleClassLoader.getByteArray(string);
            Class<?> clazz = super.defineClass(null, byArray, 0, byArray.length);
            if (clazz != null) {
                this.resolveClass(clazz);
            }
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            return clazz;
        }
        catch (Exception exception) {
            SimpleClassLoader.debug("LoadFromFile/caught " + exception + " when loading from file " + string);
            throw new ClassNotFoundException(string);
        }
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.applyDefinition(string, bl);
        }
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instantiate(String string, InputStreamProducer inputStreamProducer) throws ClassNotFoundException, IOException {
        String string2 = string.replace('.', '/');
        Object object = null;
        try {
            this.setLocalResourceSource(string2 + ".ser", inputStreamProducer);
            object = Beans.instantiate(this, string);
            Object var6_5 = null;
            this.localOverrides.remove(string2 + ".ser");
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.localOverrides.remove(string2 + ".ser");
            throw throwable;
        }
        return object;
    }

    public void setLocalResourceSource(String string, InputStreamProducer inputStreamProducer) {
        this.localOverrides.put(string, inputStreamProducer);
    }

    void putClassResource(String string, String string2) {
        this.resourceHash.put(string, "A CLASS FILE");
        this.mimeHash.put(string, string2);
    }

    void putLocalResource(String string, byte[] byArray, String string2) {
        this.resourceHash.put(string, byArray);
        this.mimeHash.put(string, string2);
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        return this.getLocalResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        return this.getLocalResourceAsStream(string);
    }

    public URL getLocalResource(String string) {
        Serializable serializable;
        Object object = this.localOverrides.get(string);
        if (object == null) {
            object = this.resourceHash.get(string);
        }
        if (object == null && this.localResourceDirectory != null && (serializable = new File(this.localResourceDirectory, string)).exists()) {
            object = new Integer("1");
        }
        if (object != null) {
            try {
                serializable = new URL("simpleresource", "", "/SIMPLE" + this.cookie + "/+/" + string);
                return serializable;
            }
            catch (Exception exception) {
                SimpleClassLoader.debug("Exception " + exception + " while building a resource URL");
                return null;
            }
        }
        return null;
    }

    private InputStream getLocalResourceAsStream(String string) {
        Object v = this.localOverrides.get(string);
        if (v != null) {
            return ((InputStreamProducer)v).getInputStream();
        }
        v = this.resourceHash.get(string);
        if (v != null) {
            if (v instanceof String) {
                throw new SecurityException("No access through getResource() to .class in 1.1");
            }
            byte[] byArray = (byte[])v;
            return new ByteArrayInputStream(byArray);
        }
        if (this.localResourceDirectory != null) {
            File file = new File(this.localResourceDirectory, string);
            try {
                return new FileInputStream(file);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static SimpleClassLoader createLoader(String string, String string2) {
        SimpleClassLoader simpleClassLoader = SimpleClassLoader.getLoader(string);
        if (simpleClassLoader != null) {
            if (!simpleClassLoader.localResourceDirectory.equals(string2)) {
                throw new Error("internal error!");
            }
            return simpleClassLoader;
        }
        return new SimpleClassLoader(string, string2);
    }

    private static SimpleClassLoader getLoader(String string) {
        return (SimpleClassLoader)loaders.get(string);
    }

    public static Object getLocalResource(String string, String string2) {
        File file;
        SimpleClassLoader simpleClassLoader = SimpleClassLoader.getLoader(string);
        Object v = simpleClassLoader.localOverrides.get(string2);
        if (v != null) {
            return ((InputStreamProducer)v).getInputStream();
        }
        String string3 = (String)simpleClassLoader.mimeHash.get(string2);
        if (string3 != null) {
            v = simpleClassLoader.resourceHash.get(string2);
            if (v instanceof String) {
                throw new SecurityException("No access through getResource() to .class in 1.1");
            }
            byte[] byArray = (byte[])v;
            if (string3.startsWith("image")) {
                return Toolkit.getDefaultToolkit().createImage(byArray).getSource();
            }
            return new ByteArrayInputStream(byArray);
        }
        if (simpleClassLoader.localResourceDirectory != null && (file = new File(simpleClassLoader.localResourceDirectory, string2)).exists()) {
            try {
                URL uRL = new URL("file", "", file.getAbsolutePath());
                return uRL.getContent();
            }
            catch (Exception exception) {
                throw new Error("no such resource");
            }
        }
        return null;
    }

    public static InputStream getLocalResourceAsStream(String string, String string2) {
        SimpleClassLoader simpleClassLoader = SimpleClassLoader.getLoader(string);
        return simpleClassLoader.getLocalResourceAsStream(string2);
    }

    public synchronized boolean applyDefinitions(Vector vector) {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Class clazz = this.findLoadedClass(string);
            if (clazz != null || (clazz = this.applyDefinition(string, true)) != null) continue;
            if (bl) {
                System.err.println("NOTE: There are classes that cannot be defined in this JAR file");
                System.err.println("    Some of these classes will cause the failure of defining or linking ");
                System.err.println("    other classes that depend on them.");
                if (keepLoading) {
                    System.err.println("NOTE: To simplify debugging JAR files, we will proceed loading classes");
                    System.err.println("    although this may lead eventually to an UnknownError or the like");
                    System.err.println();
                }
            }
            System.err.println("Class " + string + " could not be defined from JAR file");
            bl = false;
        }
        return bl;
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("SimpleClassLoader:: " + string);
        }
    }

    static {
        Properties properties = new Properties(System.getProperties());
        properties.put(protocolPathProp, properties.getProperty(protocolPathProp) + "|sun.beanbox");
        System.setProperties(properties);
        ourLoader = SimpleClassLoader.createLoader("BeanBox", null);
    }
}

