/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;

class US_ASCII
extends Charset
implements HistoricallyNamedCharset {
    static /* synthetic */ Class class$sun$nio$cs$US_ASCII;

    public US_ASCII() {
        super("US-ASCII", StandardCharsets.aliasesFor("US-ASCII"));
    }

    public String historicalName() {
        return "ASCII";
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Encoder
    extends CharsetEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        static final /* synthetic */ boolean $assertionsDisabled;

        private Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        public boolean canEncode(char c2) {
            return c2 < '\u0080';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n2;
            int n3;
            block8: {
                CoderResult coderResult2;
                block11: {
                    CoderResult coderResult3;
                    block10: {
                        CoderResult coderResult4;
                        block9: {
                            char[] cArray = charBuffer.array();
                            n3 = charBuffer.arrayOffset() + charBuffer.position();
                            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
                            if (!$assertionsDisabled && n3 > n4) {
                                throw new AssertionError();
                            }
                            n3 = n3 <= n4 ? n3 : n4;
                            byte[] byArray = byteBuffer.array();
                            n2 = byteBuffer.arrayOffset() + byteBuffer.position();
                            int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
                            if (!$assertionsDisabled && n2 > n5) {
                                throw new AssertionError();
                            }
                            n2 = n2 <= n5 ? n2 : n5;
                            try {
                                char c2;
                                while (true) {
                                    if (n3 >= n4) {
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block8;
                                    }
                                    c2 = cArray[n3];
                                    if (c2 >= '\u0080') break;
                                    if (n2 >= n5) {
                                        coderResult4 = CoderResult.OVERFLOW;
                                        Object var13_13 = null;
                                        break block9;
                                    }
                                    byArray[n2] = (byte)c2;
                                    ++n3;
                                    ++n2;
                                }
                                if (this.sgp.parse(c2, cArray, n3, n4) < 0) {
                                    coderResult3 = this.sgp.error();
                                    break block10;
                                }
                                coderResult2 = this.sgp.unmappableResult();
                                break block11;
                            }
                            catch (Throwable throwable) {
                                Object var13_17 = null;
                                charBuffer.position(n3 - charBuffer.arrayOffset());
                                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                                throw throwable;
                            }
                        }
                        charBuffer.position(n3 - charBuffer.arrayOffset());
                        byteBuffer.position(n2 - byteBuffer.arrayOffset());
                        return coderResult4;
                    }
                    Object var13_14 = null;
                    charBuffer.position(n3 - charBuffer.arrayOffset());
                    byteBuffer.position(n2 - byteBuffer.arrayOffset());
                    return coderResult3;
                }
                Object var13_15 = null;
                charBuffer.position(n3 - charBuffer.arrayOffset());
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                return coderResult2;
            }
            Object var13_16 = null;
            charBuffer.position(n3 - charBuffer.arrayOffset());
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            return coderResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n2;
            block6: {
                CoderResult coderResult2;
                block9: {
                    CoderResult coderResult3;
                    block8: {
                        CoderResult coderResult4;
                        block7: {
                            n2 = charBuffer.position();
                            try {
                                char c2;
                                while (true) {
                                    if (!charBuffer.hasRemaining()) {
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block6;
                                    }
                                    c2 = charBuffer.get();
                                    if (c2 >= '\u0080') break;
                                    if (!byteBuffer.hasRemaining()) {
                                        coderResult4 = CoderResult.OVERFLOW;
                                        Object var8_8 = null;
                                        break block7;
                                    }
                                    byteBuffer.put((byte)c2);
                                    ++n2;
                                }
                                if (this.sgp.parse(c2, charBuffer) < 0) {
                                    coderResult3 = this.sgp.error();
                                    break block8;
                                }
                                coderResult2 = this.sgp.unmappableResult();
                                break block9;
                            }
                            catch (Throwable throwable) {
                                Object var8_12 = null;
                                charBuffer.position(n2);
                                throw throwable;
                            }
                        }
                        charBuffer.position(n2);
                        return coderResult4;
                    }
                    Object var8_9 = null;
                    charBuffer.position(n2);
                    return coderResult3;
                }
                Object var8_10 = null;
                charBuffer.position(n2);
                return coderResult2;
            }
            Object var8_11 = null;
            charBuffer.position(n2);
            return coderResult;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$US_ASCII == null ? (class$sun$nio$cs$US_ASCII = US_ASCII.class$("sun.nio.cs.US_ASCII")) : class$sun$nio$cs$US_ASCII).desiredAssertionStatus();
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        static final /* synthetic */ boolean $assertionsDisabled;

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n2;
            int n3;
            block7: {
                CoderResult coderResult2;
                block9: {
                    CoderResult coderResult3;
                    block8: {
                        byte[] byArray = byteBuffer.array();
                        n3 = byteBuffer.arrayOffset() + byteBuffer.position();
                        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
                        if (!$assertionsDisabled && n3 > n4) {
                            throw new AssertionError();
                        }
                        n3 = n3 <= n4 ? n3 : n4;
                        char[] cArray = charBuffer.array();
                        n2 = charBuffer.arrayOffset() + charBuffer.position();
                        int n5 = charBuffer.arrayOffset() + charBuffer.limit();
                        if (!$assertionsDisabled && n2 > n5) {
                            throw new AssertionError();
                        }
                        n2 = n2 <= n5 ? n2 : n5;
                        try {
                            while (true) {
                                if (n3 >= n4) {
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block7;
                                }
                                byte by = byArray[n3];
                                if (by < 0) break;
                                if (n2 >= n5) {
                                    coderResult3 = CoderResult.OVERFLOW;
                                    Object var12_13 = null;
                                    break block8;
                                }
                                cArray[n2++] = (char)by;
                                ++n3;
                            }
                            coderResult2 = CoderResult.malformedForLength(1);
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var12_16 = null;
                            byteBuffer.position(n3 - byteBuffer.arrayOffset());
                            charBuffer.position(n2 - charBuffer.arrayOffset());
                            throw throwable;
                        }
                    }
                    byteBuffer.position(n3 - byteBuffer.arrayOffset());
                    charBuffer.position(n2 - charBuffer.arrayOffset());
                    return coderResult3;
                }
                Object var12_14 = null;
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
                charBuffer.position(n2 - charBuffer.arrayOffset());
                return coderResult2;
            }
            Object var12_15 = null;
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
            charBuffer.position(n2 - charBuffer.arrayOffset());
            return coderResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n2;
            block5: {
                CoderResult coderResult2;
                block7: {
                    CoderResult coderResult3;
                    block6: {
                        n2 = byteBuffer.position();
                        try {
                            while (true) {
                                if (!byteBuffer.hasRemaining()) {
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block5;
                                }
                                byte by = byteBuffer.get();
                                if (by < 0) break;
                                if (!charBuffer.hasRemaining()) {
                                    coderResult3 = CoderResult.OVERFLOW;
                                    Object var7_8 = null;
                                    break block6;
                                }
                                charBuffer.put((char)by);
                                ++n2;
                            }
                            coderResult2 = CoderResult.malformedForLength(1);
                            break block7;
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            byteBuffer.position(n2);
                            throw throwable;
                        }
                    }
                    byteBuffer.position(n2);
                    return coderResult3;
                }
                Object var7_9 = null;
                byteBuffer.position(n2);
                return coderResult2;
            }
            Object var7_10 = null;
            byteBuffer.position(n2);
            return coderResult;
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$US_ASCII == null ? (class$sun$nio$cs$US_ASCII = US_ASCII.class$("sun.nio.cs.US_ASCII")) : class$sun$nio$cs$US_ASCII).desiredAssertionStatus();
        }
    }
}

