/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

class SourceChannelImpl
extends Pipe.SourceChannel
implements SelChImpl {
    FileDescriptor fd;
    int fdVal;
    private static NativeDispatcher nd;
    private Object lock = new Object();
    private boolean isKilled = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$SourceChannelImpl;

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    SourceChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
    }

    protected void implCloseSelectableChannel() throws IOException {
        if (!this.isRegistered()) {
            this.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isKilled) {
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.isKilled = true;
        }
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    public void translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        if (n2 == 1) {
            selectionKeyImpl.readyOps(1);
        }
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        if (n2 == 1) {
            n2 = 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            int n3;
            int n2 = 0;
            try {
                this.begin();
                n3 = n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.lock);
                Object var6_5 = null;
                bl2 = n2 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n2 > 0);
                throw throwable;
            }
            this.end(bl2);
            return n3;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.read(Util.subsequence(byteBufferArray, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            long l2;
            int n2 = 0;
            try {
                this.begin();
                n2 = IOUtil.read(this.fd, byteBufferArray, nd);
                l2 = n2;
                Object var7_5 = null;
                bl2 = n2 > 0;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.end(n2 > 0);
                throw throwable;
            }
            this.end(bl2);
            return l2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$SourceChannelImpl == null ? (class$sun$nio$ch$SourceChannelImpl = SourceChannelImpl.class$("sun.nio.ch.SourceChannelImpl")) : class$sun$nio$ch$SourceChannelImpl).desiredAssertionStatus();
        Util.load();
        nd = new FileDispatcher();
    }
}

