/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.print;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.peer.ComponentPeer;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import sun.awt.print.PrintControl;
import sun.awt.print.PrinterCapabilities;
import sun.awt.print.PrinterListUpdatable;
import sun.awt.windows.WPrintDialog;

public class AwtPrintControl
extends PrintControl {
    private static final PageAttributes.MediaType[] dmPaperToPrintControl;
    private ComponentPeer dialogOwnerPeer = null;
    private static final double TENTHS_MM_TO_POINTS = 3.527777778;
    private static final HashMap mediaCache;
    private static final HashMap capabilitiesCache;

    public AwtPrintControl(Frame frame, String string, Properties properties) {
        super(frame, string, null, null);
    }

    public AwtPrintControl(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        super(frame, string, jobAttributes, pageAttributes);
        if (frame != null) {
            this.dialogOwnerPeer = frame.getPeer();
        }
    }

    private native char _getWin32MediaAttrib(int var1, String var2);

    public char getWin32MediaAttrib() {
        return this._getWin32MediaAttrib(this.getMediaAttrib(), this.getPrinterAttrib());
    }

    private int findWin32Media(int n2, int n3, int n4, boolean bl2) {
        if (n2 >= 1 && n2 <= 41) {
            if (bl2 && (n2 == 32 || n2 == 39 || n2 == 40)) {
                return -1;
            }
            return dmPaperToPrintControl[n2 - 1].hashCode();
        }
        Integer n5 = (Integer)mediaCache.get(new CacheKey(n2, n3, n4));
        if (n5 != null) {
            int n6 = n5;
            if (bl2) {
                int n7 = (int)((double)n3 / 3.527777778 + 0.5);
                int n8 = (int)((double)n4 / 3.527777778 + 0.5);
                if (n7 == PrintControl.WIDTHS[n6] && n8 == PrintControl.LENGTHS[n6] || n7 == PrintControl.LENGTHS[n6] && n8 == PrintControl.WIDTHS[n6]) {
                    return n6;
                }
                return -1;
            }
            return n6;
        }
        int n9 = (int)((double)n3 / 3.527777778 + 0.5);
        int n10 = (int)((double)n4 / 3.527777778 + 0.5);
        int n11 = Integer.MAX_VALUE;
        int n12 = -1;
        int n13 = 0;
        while (n13 < PrintControl.SIZES.length) {
            int n14;
            int n15 = Math.abs(n9 - PrintControl.WIDTHS[n13]) + Math.abs(n10 - PrintControl.LENGTHS[n13]);
            int n16 = n15 = n15 < (n14 = Math.abs(n9 - PrintControl.LENGTHS[n13]) + Math.abs(n10 - PrintControl.WIDTHS[n13])) ? n15 : n14;
            if (n15 < n11) {
                n11 = n15;
                n12 = n13;
                if (n11 == 0) break;
            }
            ++n13;
        }
        mediaCache.put(new CacheKey(n2, n3, n4), new Integer(n12));
        if (!bl2 || n11 == 0) {
            return n12;
        }
        return -1;
    }

    public void setWin32MediaAttrib(int n2, int n3, int n4) {
        this.setMediaAttrib(this.findWin32Media(n2, n3, n4, false));
    }

    public native String getDefaultPrinterName();

    private native boolean _getCapabilities(PrinterCapabilities var1);

    public boolean getCapabilities(PrinterCapabilities printerCapabilities) {
        PrinterCapabilities printerCapabilities2 = (PrinterCapabilities)capabilitiesCache.get(printerCapabilities.getPrinterName());
        if (printerCapabilities2 != null) {
            printerCapabilities.set(printerCapabilities2);
            return true;
        }
        if (!this._getCapabilities(printerCapabilities)) {
            return false;
        }
        int[] nArray = printerCapabilities.getSizes();
        if (nArray != null) {
            TreeSet treeSet = new TreeSet();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] != -1) {
                    treeSet.add(new Integer(nArray[n2]));
                }
                ++n2;
            }
            int[] nArray2 = new int[treeSet.size()];
            Iterator iterator = treeSet.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                nArray2[n3] = (Integer)iterator.next();
                ++n3;
            }
            printerCapabilities.setSizes(nArray2);
        }
        capabilitiesCache.put(printerCapabilities.getPrinterName(), printerCapabilities);
        return true;
    }

    private native String[] _getPrinterList();

    public void getPrinterList(final PrinterListUpdatable printerListUpdatable) {
        new Thread(new Runnable(){

            public void run() {
                String[] stringArray = AwtPrintControl.this._getPrinterList();
                if (stringArray != null) {
                    TreeSet treeSet = new TreeSet();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        treeSet.add(stringArray[n2]);
                        ++n2;
                    }
                    Iterator iterator = treeSet.iterator();
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        stringArray[n3] = (String)iterator.next();
                        ++n3;
                    }
                }
                printerListUpdatable.updatePrinterList(stringArray);
            }
        }).start();
    }

    protected boolean displayNativeDialog() {
        Object object;
        Object object2;
        WPrintDialog wPrintDialog = new WPrintDialog(this.dialogOwner, this);
        wPrintDialog.setRetVal(false);
        wPrintDialog.show();
        boolean bl2 = wPrintDialog.getRetVal();
        if (this.getDestAttrib() == JobAttributes.DestinationType.PRINTER || !bl2) {
            return bl2;
        }
        FileDialog fileDialog = new FileDialog(this.dialogOwner, "", 1);
        String string = this.getFileNameAttrib();
        if (string != null) {
            object2 = new File(string);
            fileDialog.setFile(((File)object2).getName());
            object = ((File)object2).getParentFile();
            if (object != null) {
                fileDialog.setDirectory(((File)object).getPath());
            }
        } else {
            fileDialog.setFile("out.prn");
        }
        fileDialog.show();
        object2 = fileDialog.getFile();
        if (object2 == null) {
            return false;
        }
        object = fileDialog.getDirectory();
        if (object != null) {
            object2 = (String)object + File.separator + (String)object2;
        }
        this.setFileNameAttrib((String)object2);
        return true;
    }

    private static native void initIDs();

    static {
        AwtPrintControl.initIDs();
        dmPaperToPrintControl = new PageAttributes.MediaType[]{PageAttributes.MediaType.NA_LETTER, PageAttributes.MediaType.NA_LETTER, PageAttributes.MediaType.LEDGER, PageAttributes.MediaType.LEDGER, PageAttributes.MediaType.NA_LEGAL, PageAttributes.MediaType.INVOICE, PageAttributes.MediaType.EXECUTIVE, PageAttributes.MediaType.ISO_A3, PageAttributes.MediaType.ISO_A4, PageAttributes.MediaType.ISO_A4, PageAttributes.MediaType.ISO_A5, PageAttributes.MediaType.ISO_B4, PageAttributes.MediaType.JIS_B5, PageAttributes.MediaType.FOLIO, PageAttributes.MediaType.QUARTO, PageAttributes.MediaType.NA_10X14_ENVELOPE, PageAttributes.MediaType.B, PageAttributes.MediaType.NA_LETTER, PageAttributes.MediaType.NA_NUMBER_9_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_10_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_11_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_12_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_14_ENVELOPE, PageAttributes.MediaType.C, PageAttributes.MediaType.D, PageAttributes.MediaType.E, PageAttributes.MediaType.ISO_DESIGNATED_LONG, PageAttributes.MediaType.ISO_C5, PageAttributes.MediaType.ISO_C3, PageAttributes.MediaType.ISO_C4, PageAttributes.MediaType.ISO_C6, PageAttributes.MediaType.ITALY_ENVELOPE, PageAttributes.MediaType.ISO_B4, PageAttributes.MediaType.ISO_B5, PageAttributes.MediaType.ISO_B6, PageAttributes.MediaType.ITALY_ENVELOPE, PageAttributes.MediaType.MONARCH_ENVELOPE, PageAttributes.MediaType.PERSONAL_ENVELOPE, PageAttributes.MediaType.NA_10X15_ENVELOPE, PageAttributes.MediaType.NA_9X12_ENVELOPE, PageAttributes.MediaType.FOLIO};
        mediaCache = new HashMap();
        capabilitiesCache = new HashMap();
    }

    private class CacheKey {
        int dmIndex;
        int width;
        int length;

        CacheKey(int n2, int n3, int n4) {
            this.dmIndex = n2;
            this.width = n3;
            this.length = n4;
        }

        public int hashCode() {
            return this.dmIndex;
        }

        public boolean equals(Object object) {
            CacheKey cacheKey = (CacheKey)object;
            return this.dmIndex == cacheKey.dmIndex && (this.width == cacheKey.width && this.length == cacheKey.length || this.width == cacheKey.length && this.length == cacheKey.width);
        }
    }
}

