/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DTMManagerDefault
extends DTMManager {
    protected DTM[] m_dtms = new DTM[1024];
    private ExpandedNameTable m_expandedNameTable = new ExpandedNameTable();
    private static final boolean DUMPTREE = false;
    private static final boolean DEBUG = false;

    public void addDTM(DTM dTM, int n2) {
        this.m_dtms[n2] = dTM;
        dTM.documentRegistration();
    }

    public int getFirstFreeDTMID() {
        int n2 = this.m_dtms.length;
        int n3 = 1;
        while (n3 < n2) {
            if (null == this.m_dtms[n3]) {
                return n3;
            }
            ++n3;
        }
        throw new DTMException(XSLMessages.createMessage(170, null));
    }

    public DTM getDTM(Source source, boolean bl2, DTMWSFilter dTMWSFilter, boolean bl3, boolean bl4) {
        boolean bl5;
        XMLStringFactory xMLStringFactory = this.m_xsf;
        int n2 = this.getFirstFreeDTMID();
        int n3 = n2 << 22;
        if (null != source && source instanceof DOMSource) {
            DOM2DTM dOM2DTM = new DOM2DTM((DTMManager)this, (DOMSource)source, n3, dTMWSFilter, xMLStringFactory, bl4);
            this.addDTM(dOM2DTM, n2);
            return dOM2DTM;
        }
        boolean bl6 = null != source ? source instanceof SAXSource : true;
        boolean bl7 = bl5 = null != source ? source instanceof StreamSource : false;
        if (bl6 || bl5) {
            boolean bl8;
            Object object;
            XMLReader xMLReader;
            InputSource inputSource;
            if (null == source) {
                inputSource = null;
                xMLReader = null;
            } else {
                xMLReader = this.getXMLReader(source);
                inputSource = SAXSource.sourceToInputSource(source);
                object = inputSource.getSystemId();
                if (null != object) {
                    try {
                        object = SystemIDResolver.getAbsoluteURI((String)object);
                    }
                    catch (Exception exception) {
                        System.err.println("Can not absolutize URL: " + (String)object);
                    }
                    inputSource.setSystemId((String)object);
                }
            }
            object = new SAX2DTM(this, source, n3, dTMWSFilter, xMLStringFactory, bl4);
            this.addDTM((DTM)object, n2);
            boolean bl9 = bl8 = null != xMLReader && xMLReader.getClass().getName().equals("org.apache.xerces.parsers.SAXParser");
            if (bl8) {
                bl3 = true;
            }
            if (m_incremental && bl3) {
                Object object2;
                Object object3 = null;
                if (bl8) {
                    try {
                        object2 = Class.forName("org.apache.xml.dtm.ref.IncrementalSAXSource_Xerces");
                        object3 = (IncrementalSAXSource)((Class)object2).newInstance();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        object3 = null;
                    }
                }
                if (object3 == null) {
                    if (null == xMLReader) {
                        object3 = new IncrementalSAXSource_Filter();
                    } else {
                        object2 = new IncrementalSAXSource_Filter();
                        ((IncrementalSAXSource_Filter)object2).setXMLReader(xMLReader);
                        object3 = object2;
                    }
                }
                ((SAX2DTM)object).setIncrementalSAXSource((IncrementalSAXSource)object3);
                if (null == inputSource) {
                    return object;
                }
                xMLReader.setDTDHandler((DTDHandler)object);
                xMLReader.setErrorHandler((ErrorHandler)object);
                try {
                    object3.startParse(inputSource);
                }
                catch (RuntimeException runtimeException) {
                    ((SAX2DTM)object).clearCoRoutine();
                    throw runtimeException;
                }
                catch (Exception exception) {
                    ((SAX2DTM)object).clearCoRoutine();
                    throw new WrappedRuntimeException(exception);
                }
            }
            if (null == xMLReader) {
                return object;
            }
            xMLReader.setContentHandler((ContentHandler)object);
            xMLReader.setDTDHandler((DTDHandler)object);
            xMLReader.setErrorHandler((ErrorHandler)object);
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            try {
                xMLReader.parse(inputSource);
            }
            catch (RuntimeException runtimeException) {
                ((SAX2DTM)object).clearCoRoutine();
                throw runtimeException;
            }
            catch (Exception exception) {
                ((SAX2DTM)object).clearCoRoutine();
                throw new WrappedRuntimeException(exception);
            }
            return object;
        }
        throw new DTMException(XSLMessages.createMessage(171, new Object[]{source}));
    }

    public int getDTMHandleFromNode(Node node) {
        Object object;
        if (null == node) {
            throw new IllegalArgumentException(XSLMessages.createMessage(172, null));
        }
        if (node instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).getDTMNodeNumber();
        }
        int n2 = this.m_dtms.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            object = this.m_dtms[n3];
            if (null != object && object instanceof DOM2DTM && (n4 = ((DOM2DTM)object).getHandleOfNode(node)) != -1) {
                return n4;
            }
            ++n3;
        }
        object = node;
        Node node2 = object.getParentNode();
        while (node2 != null) {
            object = node2;
            node2 = node2.getParentNode();
        }
        DTM dTM = this.getDTM(new DOMSource((Node)object), false, null, true, true);
        int n5 = ((DOM2DTM)dTM).getHandleOfNode(node);
        if (-1 == n5) {
            throw new RuntimeException(XSLMessages.createMessage(173, null));
        }
        return n5;
    }

    public XMLReader getXMLReader(Source source) {
        try {
            boolean bl2;
            XMLReader xMLReader = source instanceof SAXSource ? ((SAXSource)source).getXMLReader() : null;
            boolean bl3 = bl2 = xMLReader != null;
            if (null == xMLReader) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
                if (null == xMLReader) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new DTMException(sAXException.getMessage(), sAXException);
        }
    }

    public DTM getDTM(int n2) {
        return this.m_dtms[n2 >>> 22];
    }

    public int getDTMIdentity(DTM dTM) {
        int n2 = this.m_dtms.length;
        int n3 = 0;
        while (n3 < n2) {
            DTM dTM2 = this.m_dtms[n3];
            if (dTM2 == dTM) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public boolean release(DTM dTM, boolean bl2) {
        int n2;
        if (dTM instanceof SAX2DTM) {
            ((SAX2DTM)dTM).clearCoRoutine();
        }
        if ((n2 = this.getDTMIdentity(dTM)) >= 0) {
            this.m_dtms[n2] = null;
        }
        dTM.documentRelease();
        return true;
    }

    public DTM createDocumentFragment() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            DocumentFragment documentFragment = document.createDocumentFragment();
            return this.getDTM(new DOMSource(documentFragment), true, null, false, false);
        }
        catch (Exception exception) {
            throw new DTMException(exception);
        }
    }

    public DTMIterator createDTMIterator(int n2, DTMFilter dTMFilter, boolean bl2) {
        return null;
    }

    public DTMIterator createDTMIterator(String string, PrefixResolver prefixResolver) {
        return null;
    }

    public DTMIterator createDTMIterator(int n2) {
        return null;
    }

    public DTMIterator createDTMIterator(Object object, int n2) {
        return null;
    }

    public ExpandedNameTable getExpandedNameTable(DTM dTM) {
        return this.m_expandedNameTable;
    }
}

