/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import javax.swing.text.BadLocationException;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

class GlyphPainter1
extends GlyphView.GlyphPainter {
    FontMetrics metrics;

    GlyphPainter1() {
    }

    public float getSpan(GlyphView glyphView, int n2, int n3, TabExpander tabExpander, float f2) {
        this.sync(glyphView);
        Segment segment = glyphView.getText(n2, n3);
        int n4 = Utilities.getTabbedTextWidth(segment, this.metrics, (int)f2, tabExpander, n2);
        SegmentCache.releaseSharedSegment(segment);
        return n4;
    }

    public float getHeight(GlyphView glyphView) {
        this.sync(glyphView);
        return this.metrics.getHeight();
    }

    public float getAscent(GlyphView glyphView) {
        this.sync(glyphView);
        return this.metrics.getAscent();
    }

    public float getDescent(GlyphView glyphView) {
        this.sync(glyphView);
        return this.metrics.getDescent();
    }

    public void paint(GlyphView glyphView, Graphics graphics, Shape shape, int n2, int n3) {
        int n4;
        Segment segment;
        this.sync(glyphView);
        TabExpander tabExpander = glyphView.getTabExpander();
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n5 = rectangle.x;
        int n6 = glyphView.getStartOffset();
        if (n6 != n2) {
            segment = glyphView.getText(n6, n2);
            n4 = Utilities.getTabbedTextWidth(segment, this.metrics, n5, tabExpander, n6);
            n5 += n4;
            SegmentCache.releaseSharedSegment(segment);
        }
        n4 = rectangle.y + this.metrics.getHeight() - this.metrics.getDescent();
        segment = glyphView.getText(n2, n3);
        graphics.setFont(this.metrics.getFont());
        Utilities.drawTabbedText(segment, n5, n4, graphics, tabExpander, n2);
        SegmentCache.releaseSharedSegment(segment);
    }

    public Shape modelToView(GlyphView glyphView, int n2, Position.Bias bias, Shape shape) throws BadLocationException {
        this.sync(glyphView);
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n3 = glyphView.getStartOffset();
        int n4 = glyphView.getEndOffset();
        TabExpander tabExpander = glyphView.getTabExpander();
        if (n2 == n4) {
            return new Rectangle(rectangle.x + rectangle.width, rectangle.y, 0, this.metrics.getHeight());
        }
        if (n2 >= n3 && n2 <= n4) {
            Segment segment = glyphView.getText(n3, n2);
            int n5 = Utilities.getTabbedTextWidth(segment, this.metrics, rectangle.x, tabExpander, n3);
            SegmentCache.releaseSharedSegment(segment);
            return new Rectangle(rectangle.x + n5, rectangle.y, 0, this.metrics.getHeight());
        }
        throw new BadLocationException("modelToView - can't convert", n4);
    }

    public int viewToModel(GlyphView glyphView, float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        this.sync(glyphView);
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n2 = glyphView.getStartOffset();
        int n3 = glyphView.getEndOffset();
        TabExpander tabExpander = glyphView.getTabExpander();
        Segment segment = glyphView.getText(n2, n3);
        int n4 = Utilities.getTabbedTextOffset(segment, this.metrics, rectangle.x, (int)f2, tabExpander, n2);
        SegmentCache.releaseSharedSegment(segment);
        int n5 = n2 + n4;
        if (n5 == n3) {
            --n5;
        }
        biasArray[0] = Position.Bias.Forward;
        return n5;
    }

    public int getBoundedPosition(GlyphView glyphView, int n2, float f2, float f3) {
        this.sync(glyphView);
        TabExpander tabExpander = glyphView.getTabExpander();
        Segment segment = glyphView.getText(n2, glyphView.getEndOffset());
        int n3 = Utilities.getTabbedTextOffset(segment, this.metrics, (int)f2, (int)(f2 + f3), tabExpander, n2, false);
        SegmentCache.releaseSharedSegment(segment);
        int n4 = n2 + n3;
        return n4;
    }

    void sync(GlyphView glyphView) {
        Font font = glyphView.getFont();
        if (this.metrics == null || !font.equals(this.metrics.getFont())) {
            Container container = glyphView.getContainer();
            Toolkit toolkit = container != null ? container.getToolkit() : Toolkit.getDefaultToolkit();
            this.metrics = toolkit.getFontMetrics(font);
        }
    }
}

