/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class BasicInternalFrameUI
extends InternalFrameUI {
    protected JInternalFrame frame;
    protected MouseInputAdapter borderListener;
    protected PropertyChangeListener propertyChangeListener;
    protected LayoutManager internalFrameLayout;
    protected ComponentListener componentListener;
    protected MouseInputListener glassPaneDispatcher;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected JComponent eastPane;
    protected BasicInternalFrameTitlePane titlePane;
    private static DesktopManager sharedDesktopManager;
    private boolean componentListenerAdded = false;
    private Rectangle parentBounds;
    protected KeyStroke openMenuKey;
    private boolean keyBindingRegistered = false;
    private boolean keyBindingActive = false;
    private InternalFrameListener internalFrameListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicInternalFrameUI((JInternalFrame)jComponent);
    }

    public BasicInternalFrameUI(JInternalFrame jInternalFrame) {
    }

    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        this.frame.setOpaque(true);
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.frame) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this.frame + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.frame = null;
    }

    protected void installDefaults() {
        Color color;
        JComponent jComponent;
        Icon icon = this.frame.getFrameIcon();
        if (icon == null || icon instanceof UIResource) {
            this.frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        }
        if ((jComponent = (JComponent)this.frame.getContentPane()) != null && (color = jComponent.getBackground()) instanceof UIResource) {
            jComponent.setBackground(null);
        }
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        this.frame.setBackground(UIManager.getLookAndFeelDefaults().getColor("control"));
        LookAndFeel.installBorder(this.frame, "InternalFrame.border");
    }

    protected void installKeyboardActions() {
        if (this.internalFrameListener == null) {
            this.createInternalFrameListener();
        }
        this.frame.addInternalFrameListener(this.internalFrameListener);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.frame, actionMap);
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("InternalFrame.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("InternalFrame.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("showSystemMenu", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInternalFrameUI.this.titlePane.showSystemMenu();
            }

            public boolean isEnabled() {
                return BasicInternalFrameUI.this.isKeyBindingActive();
            }
        });
        BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
        ActionMap actionMap = basicLookAndFeel.getAudioActionMap();
        actionMapUIResource.setParent(actionMap);
        return actionMapUIResource;
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
    }

    protected void installListeners() {
        this.borderListener = this.createBorderListener(this.frame);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
        this.installMouseHandlers(this.frame);
        this.glassPaneDispatcher = this.createGlassPaneDispatcher();
        this.frame.getGlassPane().addMouseListener(this.glassPaneDispatcher);
        this.frame.getGlassPane().addMouseMotionListener(this.glassPaneDispatcher);
        this.componentListener = this.createComponentListener();
        if (this.frame.getParent() != null) {
            this.parentBounds = this.frame.getParent().getBounds();
        }
        if (this.frame.getParent() != null && !this.componentListenerAdded) {
            this.frame.getParent().addComponentListener(this.componentListener);
            this.componentListenerAdded = true;
        }
    }

    InputMap getInputMap(int n2) {
        if (n2 == 2) {
            return this.createInputMap(n2);
        }
        return null;
    }

    InputMap createInputMap(int n2) {
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])UIManager.get("InternalFrame.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.frame, objectArray);
        }
        return null;
    }

    protected void uninstallDefaults() {
        Icon icon = this.frame.getFrameIcon();
        if (icon instanceof UIResource) {
            this.frame.setFrameIcon(null);
        }
        this.internalFrameLayout = null;
        this.frame.setLayout(null);
        LookAndFeel.uninstallBorder(this.frame);
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this.titlePane = null;
    }

    protected void uninstallListeners() {
        if (this.frame.getParent() != null && this.componentListenerAdded) {
            this.frame.getParent().removeComponentListener(this.componentListener);
            this.componentListenerAdded = false;
        }
        this.componentListener = null;
        this.frame.getGlassPane().removeMouseListener(this.glassPaneDispatcher);
        this.frame.getGlassPane().removeMouseMotionListener(this.glassPaneDispatcher);
        this.glassPaneDispatcher = null;
        this.deinstallMouseHandlers(this.frame);
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.borderListener = null;
    }

    protected void uninstallKeyboardActions() {
        if (this.internalFrameListener != null) {
            this.frame.removeInternalFrameListener(this.internalFrameListener);
        }
        SwingUtilities.replaceUIInputMap(this.frame, 2, null);
        SwingUtilities.replaceUIActionMap(this.frame, null);
    }

    protected LayoutManager createLayoutManager() {
        return new InternalFrameLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new InternalFramePropertyChangeListener();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.frame == jComponent) {
            return this.frame.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.frame == jComponent) {
            return this.frame.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this.frame.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.frame.add(jComponent2);
            this.installMouseHandlers(jComponent2);
        }
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
        jComponent.removeMouseListener(this.borderListener);
        jComponent.removeMouseMotionListener(this.borderListener);
    }

    protected void installMouseHandlers(JComponent jComponent) {
        jComponent.addMouseListener(this.borderListener);
        jComponent.addMouseMotionListener(this.borderListener);
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new BasicInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    protected JComponent createSouthPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createWestPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createEastPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected MouseInputAdapter createBorderListener(JInternalFrame jInternalFrame) {
        return new BorderListener();
    }

    private InternalFrameListener getInternalFrameListener() {
        return this.internalFrameListener;
    }

    protected void createInternalFrameListener() {
        this.internalFrameListener = new BasicInternalFrameListener();
    }

    protected final boolean isKeyBindingRegistered() {
        return this.keyBindingRegistered;
    }

    protected final void setKeyBindingRegistered(boolean bl2) {
        this.keyBindingRegistered = bl2;
    }

    public final boolean isKeyBindingActive() {
        return this.keyBindingActive;
    }

    protected final void setKeyBindingActive(boolean bl2) {
        this.keyBindingActive = bl2;
    }

    protected void setupMenuOpenKey() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.frame, 2, inputMap);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public void setNorthPane(JComponent jComponent) {
        if (this.northPane != null && this.northPane instanceof BasicInternalFrameTitlePane) {
            ((BasicInternalFrameTitlePane)this.northPane).uninstallListeners();
        }
        this.replacePane(this.northPane, jComponent);
        this.northPane = jComponent;
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public void setSouthPane(JComponent jComponent) {
        this.southPane = jComponent;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    public void setWestPane(JComponent jComponent) {
        this.westPane = jComponent;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public void setEastPane(JComponent jComponent) {
        this.eastPane = jComponent;
    }

    protected DesktopManager getDesktopManager() {
        if (this.frame.getDesktopPane() != null && this.frame.getDesktopPane().getDesktopManager() != null) {
            return this.frame.getDesktopPane().getDesktopManager();
        }
        if (sharedDesktopManager == null) {
            sharedDesktopManager = this.createDesktopManager();
        }
        return sharedDesktopManager;
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    protected void closeFrame(JInternalFrame jInternalFrame) {
        this.fireAudioAction("InternalFrame.closeSound");
        this.getDesktopManager().closeFrame(jInternalFrame);
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        this.fireAudioAction("InternalFrame.maximizeSound");
        this.getDesktopManager().maximizeFrame(jInternalFrame);
    }

    protected void minimizeFrame(JInternalFrame jInternalFrame) {
        if (!jInternalFrame.isIcon()) {
            this.fireAudioAction("InternalFrame.restoreDownSound");
        }
        this.getDesktopManager().minimizeFrame(jInternalFrame);
    }

    protected void iconifyFrame(JInternalFrame jInternalFrame) {
        this.fireAudioAction("InternalFrame.minimizeSound");
        this.getDesktopManager().iconifyFrame(jInternalFrame);
    }

    protected void deiconifyFrame(JInternalFrame jInternalFrame) {
        if (!jInternalFrame.isMaximum()) {
            this.fireAudioAction("InternalFrame.restoreUpSound");
        }
        this.getDesktopManager().deiconifyFrame(jInternalFrame);
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().activateFrame(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deactivateFrame(jInternalFrame);
    }

    private void fireAudioAction(String string) {
        Action action;
        ActionMap actionMap = this.frame.getActionMap();
        if (actionMap != null && (action = actionMap.get(string)) != null) {
            BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
            basicLookAndFeel.playSound(action);
        }
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return new GlassPaneDispatcher();
    }

    protected class BasicInternalFrameListener
    implements InternalFrameListener {
        protected BasicInternalFrameListener() {
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            BasicInternalFrameUI.this.frame.removeInternalFrameListener(BasicInternalFrameUI.this.internalFrameListener);
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            if (!BasicInternalFrameUI.this.isKeyBindingRegistered()) {
                BasicInternalFrameUI.this.setKeyBindingRegistered(true);
                BasicInternalFrameUI.this.setupMenuOpenKey();
                BasicInternalFrameUI.this.setupMenuCloseKey();
            }
            if (BasicInternalFrameUI.this.isKeyBindingRegistered()) {
                BasicInternalFrameUI.this.setKeyBindingActive(true);
            }
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            BasicInternalFrameUI.this.setKeyBindingActive(false);
        }
    }

    protected class GlassPaneDispatcher
    implements MouseInputListener {
        private Component mouseEventTarget = null;

        protected GlassPaneDispatcher() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicInternalFrameUI.this.borderListener != null) {
                BasicInternalFrameUI.this.borderListener.mousePressed(mouseEvent);
            }
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        private void forwardMouseEvent(MouseEvent mouseEvent) {
            Component component = this.findComponentAt(BasicInternalFrameUI.this.frame.getRootPane().getLayeredPane(), mouseEvent.getX(), mouseEvent.getY());
            if (component != this.mouseEventTarget) {
                this.setMouseTarget(component, mouseEvent);
            } else {
                this.retargetMouseEvent(mouseEvent.getID(), mouseEvent);
            }
        }

        private Component findComponentAt(Container container, int n2, int n3) {
            if (!container.contains(n2, n3)) {
                return container;
            }
            int n4 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            int n5 = 0;
            while (n5 < n4) {
                Component component = componentArray[n5];
                Point point = component.getLocation();
                if (component != null && component.contains(n2 - point.x, n3 - point.y) && component.getPeer() instanceof LightweightPeer && component.isVisible()) {
                    if (component instanceof Container) {
                        Container container2 = (Container)component;
                        Point point2 = container2.getLocation();
                        Component component2 = this.findComponentAt(container2, n2 - point2.x, n3 - point2.y);
                        if (component2 != null) {
                            return component2;
                        }
                    } else {
                        return component;
                    }
                }
                ++n5;
            }
            return container;
        }

        private void setMouseTarget(Component component, MouseEvent mouseEvent) {
            if (this.mouseEventTarget != null) {
                this.retargetMouseEvent(505, mouseEvent);
            }
            this.mouseEventTarget = component;
            if (this.mouseEventTarget != null) {
                this.retargetMouseEvent(504, mouseEvent);
            }
        }

        void retargetMouseEvent(int n2, MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint(BasicInternalFrameUI.this.frame.getLayeredPane(), mouseEvent.getX(), mouseEvent.getY(), this.mouseEventTarget);
            MouseEvent mouseEvent2 = new MouseEvent(this.mouseEventTarget, n2, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            this.mouseEventTarget.dispatchEvent(mouseEvent2);
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        protected ComponentHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Rectangle rectangle = ((Component)componentEvent.getSource()).getBounds();
            Component component = null;
            if (BasicInternalFrameUI.this.frame != null) {
                component = BasicInternalFrameUI.this.frame.getDesktopIcon();
                if (BasicInternalFrameUI.this.frame.isMaximum()) {
                    BasicInternalFrameUI.this.frame.setBounds(0, 0, rectangle.width, rectangle.height);
                }
            }
            if (component != null) {
                Rectangle rectangle2 = component.getBounds();
                int n2 = rectangle2.y + (rectangle.height - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height);
                component.setBounds(rectangle2.x, n2, rectangle2.width, rectangle2.height);
            }
            if (!BasicInternalFrameUI.this.parentBounds.equals(rectangle)) {
                BasicInternalFrameUI.this.parentBounds = rectangle;
            }
            if (BasicInternalFrameUI.this.frame != null) {
                BasicInternalFrameUI.this.frame.validate();
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;
        int resizeDir;
        protected final int RESIZE_NONE = 0;
        private boolean discardRelease = false;
        int resizeCornerSize = 16;

        protected BorderListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1 && mouseEvent.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                if (BasicInternalFrameUI.this.frame.isIconifiable() && BasicInternalFrameUI.this.frame.isIcon()) {
                    try {
                        BasicInternalFrameUI.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (BasicInternalFrameUI.this.frame.isMaximizable()) {
                    if (!BasicInternalFrameUI.this.frame.isMaximum()) {
                        try {
                            BasicInternalFrameUI.this.frame.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            BasicInternalFrameUI.this.frame.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.discardRelease) {
                this.discardRelease = false;
                return;
            }
            if (this.resizeDir == 0) {
                BasicInternalFrameUI.this.getDesktopManager().endDraggingFrame(BasicInternalFrameUI.this.frame);
            } else {
                Container container = BasicInternalFrameUI.this.frame.getTopLevelAncestor();
                if (container instanceof JFrame) {
                    ((JFrame)BasicInternalFrameUI.this.frame.getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JFrame)BasicInternalFrameUI.this.frame.getTopLevelAncestor()).getGlassPane().setVisible(false);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JApplet)container).getGlassPane().setVisible(false);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JWindow)container).getGlassPane().setVisible(false);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JDialog)container).getGlassPane().setVisible(false);
                }
                BasicInternalFrameUI.this.getDesktopManager().endResizingFrame(BasicInternalFrameUI.this.frame);
            }
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            this.resizeDir = 0;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = BasicInternalFrameUI.this.frame.getBounds();
            this.resizeDir = 0;
            if (!BasicInternalFrameUI.this.frame.isSelected()) {
                try {
                    BasicInternalFrameUI.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                BasicInternalFrameUI.this.getDesktopManager().beginDraggingFrame(BasicInternalFrameUI.this.frame);
                return;
            }
            if (!BasicInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.frame) {
                Insets insets = BasicInternalFrameUI.this.frame.getInsets();
                if (mouseEvent.getX() <= insets.left) {
                    this.resizeDir = mouseEvent.getY() < this.resizeCornerSize + insets.top ? 8 : (mouseEvent.getY() > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom ? 6 : 7);
                } else if (mouseEvent.getX() >= BasicInternalFrameUI.this.frame.getWidth() - insets.right) {
                    this.resizeDir = mouseEvent.getY() < this.resizeCornerSize + insets.top ? 2 : (mouseEvent.getY() > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom ? 4 : 3);
                } else if (mouseEvent.getY() <= insets.top) {
                    this.resizeDir = mouseEvent.getX() < this.resizeCornerSize + insets.left ? 8 : (mouseEvent.getX() > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right ? 2 : 1);
                } else if (mouseEvent.getY() >= BasicInternalFrameUI.this.frame.getHeight() - insets.bottom) {
                    this.resizeDir = mouseEvent.getX() < this.resizeCornerSize + insets.left ? 6 : (mouseEvent.getX() > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right ? 4 : 5);
                } else {
                    this.discardRelease = true;
                    return;
                }
                Cursor cursor = Cursor.getPredefinedCursor(0);
                switch (this.resizeDir) {
                    case 5: {
                        cursor = Cursor.getPredefinedCursor(9);
                        break;
                    }
                    case 1: {
                        cursor = Cursor.getPredefinedCursor(8);
                        break;
                    }
                    case 7: {
                        cursor = Cursor.getPredefinedCursor(10);
                        break;
                    }
                    case 3: {
                        cursor = Cursor.getPredefinedCursor(11);
                        break;
                    }
                    case 4: {
                        cursor = Cursor.getPredefinedCursor(5);
                        break;
                    }
                    case 6: {
                        cursor = Cursor.getPredefinedCursor(4);
                        break;
                    }
                    case 8: {
                        cursor = Cursor.getPredefinedCursor(6);
                        break;
                    }
                    case 2: {
                        cursor = Cursor.getPredefinedCursor(7);
                    }
                }
                Container container = BasicInternalFrameUI.this.frame.getTopLevelAncestor();
                if (container instanceof JFrame) {
                    ((JFrame)container).getGlassPane().setVisible(true);
                    ((JFrame)container).getGlassPane().setCursor(cursor);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setVisible(true);
                    ((JApplet)container).getGlassPane().setCursor(cursor);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setVisible(true);
                    ((JWindow)container).getGlassPane().setCursor(cursor);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setVisible(true);
                    ((JDialog)container).getGlassPane().setCursor(cursor);
                }
                BasicInternalFrameUI.this.getDesktopManager().beginResizingFrame(BasicInternalFrameUI.this.frame, this.resizeDir);
                return;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.startingBounds == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            int n2 = this._x - point.x;
            int n3 = this._y - point.y;
            Dimension dimension = BasicInternalFrameUI.this.frame.getMinimumSize();
            Dimension dimension2 = BasicInternalFrameUI.this.frame.getMaximumSize();
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                if (BasicInternalFrameUI.this.frame.isMaximum() || (mouseEvent.getModifiers() & 0x10) != 16) {
                    return;
                }
                Insets insets = BasicInternalFrameUI.this.frame.getInsets();
                Dimension dimension3 = BasicInternalFrameUI.this.frame.getParent().getSize();
                int n4 = dimension3.width;
                int n5 = dimension3.height;
                int n6 = this.startingBounds.x - n2;
                int n7 = this.startingBounds.y - n3;
                if (n6 + insets.left <= -this.__x) {
                    n6 = -this.__x - insets.left;
                }
                if (n7 + insets.top <= -this.__y) {
                    n7 = -this.__y - insets.top;
                }
                if (n6 + this.__x + insets.right > n4) {
                    n6 = n4 - this.__x - insets.right;
                }
                if (n7 + this.__y + insets.bottom > n5) {
                    n7 = n5 - this.__y - insets.bottom;
                }
                BasicInternalFrameUI.this.getDesktopManager().dragFrame(BasicInternalFrameUI.this.frame, n6, n7);
                return;
            }
            if (!BasicInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            int n8 = BasicInternalFrameUI.this.frame.getX();
            int n9 = BasicInternalFrameUI.this.frame.getY();
            int n10 = BasicInternalFrameUI.this.frame.getWidth();
            int n11 = BasicInternalFrameUI.this.frame.getHeight();
            BasicInternalFrameUI.this.parentBounds = BasicInternalFrameUI.this.frame.getParent().getBounds();
            switch (this.resizeDir) {
                case 0: {
                    return;
                }
                case 1: {
                    if (this.startingBounds.height + n3 < dimension.height) {
                        n3 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n3 > dimension2.height) {
                        n3 = dimension2.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - n3 < 0) {
                        n3 = this.startingBounds.y;
                    }
                    n8 = this.startingBounds.x;
                    n9 = this.startingBounds.y - n3;
                    n10 = this.startingBounds.width;
                    n11 = this.startingBounds.height + n3;
                    break;
                }
                case 2: {
                    if (this.startingBounds.height + n3 < dimension.height) {
                        n3 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n3 > dimension2.height) {
                        n3 = dimension2.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - n3 < 0) {
                        n3 = this.startingBounds.y;
                    }
                    if (this.startingBounds.width - n2 < dimension.width) {
                        n2 = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n2 > dimension2.width) {
                        n2 = -(dimension2.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - n2 > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width) {
                        n2 = this.startingBounds.x + this.startingBounds.width - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width;
                    }
                    n8 = this.startingBounds.x;
                    n9 = this.startingBounds.y - n3;
                    n10 = this.startingBounds.width - n2;
                    n11 = this.startingBounds.height + n3;
                    break;
                }
                case 3: {
                    if (this.startingBounds.width - n2 < dimension.width) {
                        n2 = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n2 > dimension2.width) {
                        n2 = -(dimension2.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - n2 > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width) {
                        n2 = this.startingBounds.x + this.startingBounds.width - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width;
                    }
                    n10 = this.startingBounds.width - n2;
                    n11 = this.startingBounds.height;
                    break;
                }
                case 4: {
                    if (this.startingBounds.width - n2 < dimension.width) {
                        n2 = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n2 > dimension2.width) {
                        n2 = -(dimension2.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - n2 > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width) {
                        n2 = this.startingBounds.x + this.startingBounds.width - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width;
                    }
                    if (this.startingBounds.height - n3 < dimension.height) {
                        n3 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n3 > dimension2.height) {
                        n3 = -(dimension2.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - n3 > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height) {
                        n3 = this.startingBounds.y + this.startingBounds.height - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height;
                    }
                    n10 = this.startingBounds.width - n2;
                    n11 = this.startingBounds.height - n3;
                    break;
                }
                case 5: {
                    if (this.startingBounds.height - n3 < dimension.height) {
                        n3 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n3 > dimension2.height) {
                        n3 = -(dimension2.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - n3 > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height) {
                        n3 = this.startingBounds.y + this.startingBounds.height - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height;
                    }
                    n10 = this.startingBounds.width;
                    n11 = this.startingBounds.height - n3;
                    break;
                }
                case 6: {
                    if (this.startingBounds.height - n3 < dimension.height) {
                        n3 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n3 > dimension2.height) {
                        n3 = -(dimension2.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - n3 > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height) {
                        n3 = this.startingBounds.y + this.startingBounds.height - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height;
                    }
                    if (this.startingBounds.width + n2 < dimension.width) {
                        n2 = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n2 > dimension2.width) {
                        n2 = dimension2.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - n2 < 0) {
                        n2 = this.startingBounds.x;
                    }
                    n8 = this.startingBounds.x - n2;
                    n9 = this.startingBounds.y;
                    n10 = this.startingBounds.width + n2;
                    n11 = this.startingBounds.height - n3;
                    break;
                }
                case 7: {
                    if (this.startingBounds.width + n2 < dimension.width) {
                        n2 = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n2 > dimension2.width) {
                        n2 = dimension2.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - n2 < 0) {
                        n2 = this.startingBounds.x;
                    }
                    n8 = this.startingBounds.x - n2;
                    n9 = this.startingBounds.y;
                    n10 = this.startingBounds.width + n2;
                    n11 = this.startingBounds.height;
                    break;
                }
                case 8: {
                    if (this.startingBounds.width + n2 < dimension.width) {
                        n2 = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n2 > dimension2.width) {
                        n2 = dimension2.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - n2 < 0) {
                        n2 = this.startingBounds.x;
                    }
                    if (this.startingBounds.height + n3 < dimension.height) {
                        n3 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n3 > dimension2.height) {
                        n3 = dimension2.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - n3 < 0) {
                        n3 = this.startingBounds.y;
                    }
                    n8 = this.startingBounds.x - n2;
                    n9 = this.startingBounds.y - n3;
                    n10 = this.startingBounds.width + n2;
                    n11 = this.startingBounds.height + n3;
                    break;
                }
                default: {
                    return;
                }
            }
            BasicInternalFrameUI.this.getDesktopManager().resizeFrame(BasicInternalFrameUI.this.frame, n8, n9, n10, n11);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!BasicInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.frame) {
                Insets insets = BasicInternalFrameUI.this.frame.getInsets();
                if (mouseEvent.getX() <= insets.left) {
                    if (mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (mouseEvent.getY() > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(10));
                    }
                } else if (mouseEvent.getX() >= BasicInternalFrameUI.this.frame.getWidth() - insets.right) {
                    if (mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else if (mouseEvent.getY() > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (mouseEvent.getY() <= insets.top) {
                    if (mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (mouseEvent.getX() > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(8));
                    }
                } else if (mouseEvent.getY() >= BasicInternalFrameUI.this.frame.getHeight() - insets.bottom) {
                    if (mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else if (mouseEvent.getX() > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
            BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public class InternalFrameLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            Dimension dimension2 = new Dimension(BasicInternalFrameUI.this.frame.getRootPane().getPreferredSize());
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            if (BasicInternalFrameUI.this.getNorthPane() != null) {
                dimension = BasicInternalFrameUI.this.getNorthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (BasicInternalFrameUI.this.getSouthPane() != null) {
                dimension = BasicInternalFrameUI.this.getSouthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (BasicInternalFrameUI.this.getEastPane() != null) {
                dimension = BasicInternalFrameUI.this.getEastPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            if (BasicInternalFrameUI.this.getWestPane() != null) {
                dimension = BasicInternalFrameUI.this.getWestPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension2;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            if (BasicInternalFrameUI.this.getNorthPane() != null && BasicInternalFrameUI.this.getNorthPane() instanceof BasicInternalFrameTitlePane) {
                dimension = new Dimension(BasicInternalFrameUI.this.getNorthPane().getMinimumSize());
            }
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = BasicInternalFrameUI.this.frame.getWidth() - insets.left - insets.right;
            int n5 = BasicInternalFrameUI.this.frame.getHeight() - insets.top - insets.bottom;
            if (BasicInternalFrameUI.this.getNorthPane() != null) {
                dimension = BasicInternalFrameUI.this.getNorthPane().getPreferredSize();
                BasicInternalFrameUI.this.getNorthPane().setBounds(n2, n3, n4, dimension.height);
                n3 += dimension.height;
                n5 -= dimension.height;
            }
            if (BasicInternalFrameUI.this.getSouthPane() != null) {
                dimension = BasicInternalFrameUI.this.getSouthPane().getPreferredSize();
                BasicInternalFrameUI.this.getSouthPane().setBounds(n2, BasicInternalFrameUI.this.frame.getHeight() - insets.bottom - dimension.height, n4, dimension.height);
                n5 -= dimension.height;
            }
            if (BasicInternalFrameUI.this.getWestPane() != null) {
                dimension = BasicInternalFrameUI.this.getWestPane().getPreferredSize();
                BasicInternalFrameUI.this.getWestPane().setBounds(n2, n3, dimension.width, n5);
                n4 -= dimension.width;
                n2 += dimension.width;
            }
            if (BasicInternalFrameUI.this.getEastPane() != null) {
                dimension = BasicInternalFrameUI.this.getEastPane().getPreferredSize();
                BasicInternalFrameUI.this.getEastPane().setBounds(n4 - dimension.width, n3, dimension.width, n5);
                n4 -= dimension.width;
            }
            if (BasicInternalFrameUI.this.frame.getRootPane() != null) {
                BasicInternalFrameUI.this.frame.getRootPane().setBounds(n2, n3, n4, n5);
            }
        }
    }

    public class InternalFramePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if ("closed".equals(string)) {
                if (object == Boolean.TRUE) {
                    if (BasicInternalFrameUI.this.frame.getParent() != null && BasicInternalFrameUI.this.componentListenerAdded) {
                        BasicInternalFrameUI.this.frame.getParent().removeComponentListener(BasicInternalFrameUI.this.componentListener);
                    }
                    BasicInternalFrameUI.this.closeFrame(jInternalFrame);
                }
            } else if ("maximum".equals(string)) {
                if (object == Boolean.TRUE) {
                    BasicInternalFrameUI.this.maximizeFrame(jInternalFrame);
                } else {
                    BasicInternalFrameUI.this.minimizeFrame(jInternalFrame);
                }
            } else if ("icon".equals(string)) {
                if (object == Boolean.TRUE) {
                    BasicInternalFrameUI.this.iconifyFrame(jInternalFrame);
                } else {
                    BasicInternalFrameUI.this.deiconifyFrame(jInternalFrame);
                }
            } else if ("selected".equals(string)) {
                Component component = jInternalFrame.getGlassPane();
                if (object == Boolean.TRUE && object2 == Boolean.FALSE) {
                    BasicInternalFrameUI.this.activateFrame(jInternalFrame);
                    component.setVisible(false);
                } else if (object == Boolean.FALSE && object2 == Boolean.TRUE) {
                    BasicInternalFrameUI.this.deactivateFrame(jInternalFrame);
                    component.setVisible(true);
                }
            } else if (string.equals("ancestor")) {
                if (BasicInternalFrameUI.this.frame.getParent() != null) {
                    BasicInternalFrameUI.this.parentBounds = jInternalFrame.getParent().getBounds();
                } else {
                    BasicInternalFrameUI.this.parentBounds = null;
                }
                if (BasicInternalFrameUI.this.frame.getParent() != null && !BasicInternalFrameUI.this.componentListenerAdded) {
                    jInternalFrame.getParent().addComponentListener(BasicInternalFrameUI.this.componentListener);
                    BasicInternalFrameUI.this.componentListenerAdded = true;
                } else if (object == null && BasicInternalFrameUI.this.componentListenerAdded) {
                    if (jInternalFrame.getParent() != null) {
                        jInternalFrame.getParent().removeComponentListener(BasicInternalFrameUI.this.componentListener);
                    }
                    BasicInternalFrameUI.this.componentListenerAdded = false;
                }
            } else if ("title".equals(string) || string.equals("closable") || string.equals("iconable") || string.equals("maximizable")) {
                Dimension dimension = BasicInternalFrameUI.this.frame.getMinimumSize();
                Dimension dimension2 = BasicInternalFrameUI.this.frame.getSize();
                if (dimension.width > dimension2.width) {
                    BasicInternalFrameUI.this.frame.setSize(dimension.width, dimension2.height);
                }
            }
        }
    }
}

