/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;

public class AudioInputStream
extends InputStream {
    private PushbackInputStream stream;
    private boolean markSupported;
    protected AudioFormat format;
    protected long frameLength;
    protected int frameSize;
    protected long framePos;
    private long markpos;

    public AudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l2) {
        this.format = audioFormat;
        this.frameLength = l2;
        this.frameSize = audioFormat.getFrameSize();
        if (this.frameSize == -1) {
            this.frameSize = 1;
        }
        this.stream = this.frameSize > 1 ? new PushbackInputStream(inputStream, this.frameSize - 1) : new PushbackInputStream(inputStream, 1);
        this.framePos = 0L;
        this.markpos = 0L;
        this.markSupported = inputStream.markSupported();
    }

    public AudioInputStream(TargetDataLine targetDataLine) {
        TargetDataLineInputStream targetDataLineInputStream = new TargetDataLineInputStream(targetDataLine);
        this.format = targetDataLine.getFormat();
        this.frameLength = -1L;
        this.frameSize = this.format.getFrameSize();
        if (this.frameSize == -1) {
            this.frameSize = 1;
        }
        this.stream = this.frameSize > 1 ? new PushbackInputStream(targetDataLineInputStream, this.frameSize - 1) : new PushbackInputStream(targetDataLineInputStream, 1);
        this.framePos = 0L;
        this.markpos = 0L;
        this.markSupported = this.stream.markSupported();
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("cannot read a single byte if frame size != 1");
        }
        if (this.frameLength != -1L && this.framePos >= this.frameLength) {
            return -1;
        }
        int n2 = this.stream.read();
        if (n2 >= 0) {
            ++this.framePos;
        }
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        if (n3 % this.frameSize != 0) {
            n3 -= n3 % this.frameSize;
        }
        if (this.frameLength != -1L) {
            if (this.framePos >= this.frameLength) {
                return -1;
            }
            if ((long)(n3 / this.frameSize) > this.frameLength - this.framePos) {
                n3 = (int)(this.frameLength - this.framePos) * this.frameSize;
            }
        }
        if ((n5 = this.stream.read(byArray, n2, n3)) > 0 && (n4 = n5 % this.frameSize) > 0) {
            this.stream.unread(byArray, n2 + n5 - n4, n4);
            n5 -= n4;
        }
        this.framePos += (long)(n5 / this.frameSize);
        return n5;
    }

    public long skip(long l2) throws IOException {
        long l3;
        if (l2 % (long)this.frameSize != 0L) {
            l2 -= l2 % (long)this.frameSize;
        }
        if (this.frameLength != -1L && l2 / (long)this.frameSize > this.frameLength - this.framePos) {
            l2 = (this.frameLength - this.framePos) * (long)this.frameSize;
        }
        if ((l3 = this.stream.skip(l2)) % (long)this.frameSize != 0L) {
            throw new IOException("Could not skip an integer number of frames.");
        }
        if (l3 >= 0L) {
            this.framePos += l3 / (long)this.frameSize;
        }
        return l3;
    }

    public int available() throws IOException {
        int n2 = this.stream.available();
        if (this.frameLength != -1L && (long)(n2 / this.frameSize) > this.frameLength - this.framePos) {
            return (int)(this.frameLength - this.framePos) * this.frameSize;
        }
        return n2;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void mark(int n2) {
        this.stream.mark(n2);
        if (this.markSupported()) {
            this.markpos = this.framePos;
        }
    }

    public void reset() throws IOException {
        this.stream.reset();
        this.framePos = this.markpos;
    }

    public boolean markSupported() {
        return this.markSupported;
    }

    private class TargetDataLineInputStream
    extends InputStream {
        TargetDataLine line;

        TargetDataLineInputStream(TargetDataLine targetDataLine) {
            this.line = targetDataLine;
        }

        public int available() throws IOException {
            return this.line.available();
        }

        public void close() throws IOException {
            if (this.line.isActive()) {
                this.line.flush();
                this.line.stop();
            }
            this.line.close();
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n2 = this.read(byArray, 0, 1);
            if (n2 == -1) {
                return -1;
            }
            n2 = byArray[0];
            if (this.line.getFormat().getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                n2 += 128;
            }
            return n2;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            try {
                return this.line.read(byArray, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        }
    }
}

