/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.x500;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import sun.security.util.DerValue;
import sun.security.util.ResourcesMgr;
import sun.security.x509.X500Name;

public final class X500Principal
implements Principal,
Serializable {
    public static final String RFC1779 = "RFC1779";
    public static final String RFC2253 = "RFC2253";
    public static final String CANONICAL = "CANONICAL";
    private transient String name;
    private transient X500Name thisX500Name;
    private transient byte[] encByte = null;

    public X500Principal(String string) {
        if (string == null) {
            throw new NullPointerException(ResourcesMgr.getString("provided null name"));
        }
        try {
            this.thisX500Name = new X500Name(string);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input name: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        this.name = string;
    }

    public X500Principal(byte[] byArray) {
        try {
            this.thisX500Name = new X500Name(byArray);
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input name");
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
    }

    public X500Principal(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("provided null input stream");
        }
        try {
            if (inputStream.markSupported()) {
                inputStream.mark(inputStream.available() + 1);
            }
            DerValue derValue = new DerValue(inputStream);
            this.thisX500Name = new X500Name(derValue.data);
        }
        catch (IOException iOException) {
            if (inputStream.markSupported()) {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException2) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input stream and unable to reset input stream");
                    illegalArgumentException.initCause(iOException);
                    throw illegalArgumentException;
                }
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input stream");
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
    }

    public String getName() {
        return this.getName(RFC2253);
    }

    public String getName(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase(RFC1779)) {
                return this.thisX500Name.getRFC1779Name();
            }
            if (string.equalsIgnoreCase(RFC2253)) {
                return this.thisX500Name.getRFC2253Name();
            }
            if (string.equalsIgnoreCase(CANONICAL)) {
                return this.thisX500Name.getRFC2253CanonicalName();
            }
        }
        throw new IllegalArgumentException("invalid format specified");
    }

    public byte[] getEncoded() {
        if (this.encByte == null) {
            try {
                this.encByte = this.thisX500Name.getEncoded();
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException("unable to get encoding");
                runtimeException.initCause(iOException);
                throw runtimeException;
            }
        }
        return (byte[])this.encByte.clone();
    }

    public String toString() {
        return this.thisX500Name.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof X500Principal) {
            X500Principal x500Principal = (X500Principal)object;
            return this.getName(CANONICAL).equals(x500Principal.getName(CANONICAL));
        }
        return false;
    }

    public int hashCode() {
        return this.getName(CANONICAL).hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, NotActiveException, ClassNotFoundException {
        this.thisX500Name = new X500Name((byte[])objectInputStream.readObject());
    }
}

