/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    public abstract void write(int var1) throws IOException;

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public void writeBoolean(boolean bl2) throws IOException {
        this.write(bl2 ? 1 : 0);
    }

    public void writeByte(int n2) throws IOException {
        this.write(n2);
    }

    public void writeShort(int n2) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.write(n2 >>> 8 & 0xFF);
            this.write(n2 >>> 0 & 0xFF);
        } else {
            this.write(n2 >>> 0 & 0xFF);
            this.write(n2 >>> 8 & 0xFF);
        }
    }

    public void writeChar(int n2) throws IOException {
        this.writeShort(n2);
    }

    public void writeInt(int n2) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.write(n2 >>> 24 & 0xFF);
            this.write(n2 >>> 16 & 0xFF);
            this.write(n2 >>> 8 & 0xFF);
            this.write(n2 >>> 0 & 0xFF);
        } else {
            this.write(n2 >>> 0 & 0xFF);
            this.write(n2 >>> 8 & 0xFF);
            this.write(n2 >>> 16 & 0xFF);
            this.write(n2 >>> 24 & 0xFF);
        }
    }

    public void writeLong(long l2) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.write((int)(l2 >>> 56) & 0xFF);
            this.write((int)(l2 >>> 48) & 0xFF);
            this.write((int)(l2 >>> 40) & 0xFF);
            this.write((int)(l2 >>> 32) & 0xFF);
            this.write((int)(l2 >>> 24) & 0xFF);
            this.write((int)(l2 >>> 16) & 0xFF);
            this.write((int)(l2 >>> 8) & 0xFF);
            this.write((int)(l2 >>> 0) & 0xFF);
        } else {
            this.write((int)(l2 >>> 0) & 0xFF);
            this.write((int)(l2 >>> 8) & 0xFF);
            this.write((int)(l2 >>> 16) & 0xFF);
            this.write((int)(l2 >>> 24) & 0xFF);
            this.write((int)(l2 >>> 32) & 0xFF);
            this.write((int)(l2 >>> 40) & 0xFF);
            this.write((int)(l2 >>> 48) & 0xFF);
            this.write((int)(l2 >>> 56) & 0xFF);
        }
    }

    public void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeBytes(String string) throws IOException {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            this.write((byte)string.charAt(n3));
            ++n3;
        }
    }

    public void writeChars(String string) throws IOException {
        int n2 = string.length();
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n4 = 0;
            while (n4 < n2) {
                char c2 = string.charAt(n4);
                byArray[n3++] = (byte)(c2 >>> 8);
                byArray[n3++] = (byte)(c2 >>> 0);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                char c3 = string.charAt(n5);
                byArray[n3++] = (byte)(c3 >>> 0);
                byArray[n3++] = (byte)(c3 >>> 8);
                ++n5;
            }
        }
        this.write(byArray, 0, n2 * 2);
    }

    public void writeUTF(String string) throws IOException {
        char c2;
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[n2];
        int n4 = 0;
        string.getChars(0, n2, cArray, 0);
        int n5 = 0;
        while (n5 < n2) {
            c2 = cArray[n5];
            n3 = c2 >= '\u0001' && c2 <= '\u007f' ? ++n3 : (c2 > '\u07ff' ? (n3 += 3) : (n3 += 2));
            ++n5;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException("utflen > 65536!");
        }
        byte[] byArray = new byte[n3 + 2];
        byArray[n4++] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n4++] = (byte)(n3 >>> 0 & 0xFF);
        int n6 = 0;
        while (n6 < n2) {
            c2 = cArray[n6];
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                byArray[n4++] = (byte)c2;
            } else if (c2 > '\u07ff') {
                byArray[n4++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            } else {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            }
            ++n6;
        }
        this.write(byArray, 0, n3 + 2);
    }

    public void writeShorts(short[] sArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > sArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        byte[] byArray = new byte[n3 * 2];
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n5 = 0;
            while (n5 < n3) {
                short s2 = sArray[n2 + n5];
                byArray[n4++] = (byte)(s2 >>> 8);
                byArray[n4++] = (byte)(s2 >>> 0);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n3) {
                short s3 = sArray[n2 + n6];
                byArray[n4++] = (byte)(s3 >>> 0);
                byArray[n4++] = (byte)(s3 >>> 8);
                ++n6;
            }
        }
        this.write(byArray, 0, n3 * 2);
    }

    public void writeChars(char[] cArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
        }
        byte[] byArray = new byte[n3 * 2];
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n5 = 0;
            while (n5 < n3) {
                char c2 = cArray[n2 + n5];
                byArray[n4++] = (byte)(c2 >>> 8);
                byArray[n4++] = (byte)(c2 >>> 0);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n3) {
                char c3 = cArray[n2 + n6];
                byArray[n4++] = (byte)(c3 >>> 0);
                byArray[n4++] = (byte)(c3 >>> 8);
                ++n6;
            }
        }
        this.write(byArray, 0, n3 * 2);
    }

    public void writeInts(int[] nArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > nArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] byArray = new byte[n3 * 4];
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n5 = 0;
            while (n5 < n3) {
                int n6 = nArray[n2 + n5];
                byArray[n4++] = (byte)(n6 >>> 24);
                byArray[n4++] = (byte)(n6 >>> 16);
                byArray[n4++] = (byte)(n6 >>> 8);
                byArray[n4++] = (byte)(n6 >>> 0);
                ++n5;
            }
        } else {
            int n7 = 0;
            while (n7 < n3) {
                int n8 = nArray[n2 + n7];
                byArray[n4++] = (byte)(n8 >>> 0);
                byArray[n4++] = (byte)(n8 >>> 8);
                byArray[n4++] = (byte)(n8 >>> 16);
                byArray[n4++] = (byte)(n8 >>> 24);
                ++n7;
            }
        }
        this.write(byArray, 0, n3 * 4);
    }

    public void writeLongs(long[] lArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > lArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
        }
        byte[] byArray = new byte[n3 * 8];
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n5 = 0;
            while (n5 < n3) {
                long l2 = lArray[n2 + n5];
                byArray[n4++] = (byte)(l2 >>> 56);
                byArray[n4++] = (byte)(l2 >>> 48);
                byArray[n4++] = (byte)(l2 >>> 40);
                byArray[n4++] = (byte)(l2 >>> 32);
                byArray[n4++] = (byte)(l2 >>> 24);
                byArray[n4++] = (byte)(l2 >>> 16);
                byArray[n4++] = (byte)(l2 >>> 8);
                byArray[n4++] = (byte)(l2 >>> 0);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n3) {
                long l3 = lArray[n2 + n6];
                byArray[n4++] = (byte)(l3 >>> 0);
                byArray[n4++] = (byte)(l3 >>> 8);
                byArray[n4++] = (byte)(l3 >>> 16);
                byArray[n4++] = (byte)(l3 >>> 24);
                byArray[n4++] = (byte)(l3 >>> 32);
                byArray[n4++] = (byte)(l3 >>> 40);
                byArray[n4++] = (byte)(l3 >>> 48);
                byArray[n4++] = (byte)(l3 >>> 56);
                ++n6;
            }
        }
        this.write(byArray, 0, n3 * 8);
    }

    public void writeFloats(float[] fArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > fArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
        }
        byte[] byArray = new byte[n3 * 4];
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n5 = 0;
            while (n5 < n3) {
                int n6 = Float.floatToIntBits(fArray[n2 + n5]);
                byArray[n4++] = (byte)(n6 >>> 24);
                byArray[n4++] = (byte)(n6 >>> 16);
                byArray[n4++] = (byte)(n6 >>> 8);
                byArray[n4++] = (byte)(n6 >>> 0);
                ++n5;
            }
        } else {
            int n7 = 0;
            while (n7 < n3) {
                int n8 = Float.floatToIntBits(fArray[n2 + n7]);
                byArray[n4++] = (byte)(n8 >>> 0);
                byArray[n4++] = (byte)(n8 >>> 8);
                byArray[n4++] = (byte)(n8 >>> 16);
                byArray[n4++] = (byte)(n8 >>> 24);
                ++n7;
            }
        }
        this.write(byArray, 0, n3 * 4);
    }

    public void writeDoubles(double[] dArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > dArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
        }
        byte[] byArray = new byte[n3 * 8];
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n5 = 0;
            while (n5 < n3) {
                long l2 = Double.doubleToLongBits(dArray[n2 + n5]);
                byArray[n4++] = (byte)(l2 >>> 56);
                byArray[n4++] = (byte)(l2 >>> 48);
                byArray[n4++] = (byte)(l2 >>> 40);
                byArray[n4++] = (byte)(l2 >>> 32);
                byArray[n4++] = (byte)(l2 >>> 24);
                byArray[n4++] = (byte)(l2 >>> 16);
                byArray[n4++] = (byte)(l2 >>> 8);
                byArray[n4++] = (byte)(l2 >>> 0);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n3) {
                long l3 = Double.doubleToLongBits(dArray[n2 + n6]);
                byArray[n4++] = (byte)(l3 >>> 0);
                byArray[n4++] = (byte)(l3 >>> 8);
                byArray[n4++] = (byte)(l3 >>> 16);
                byArray[n4++] = (byte)(l3 >>> 24);
                byArray[n4++] = (byte)(l3 >>> 32);
                byArray[n4++] = (byte)(l3 >>> 40);
                byArray[n4++] = (byte)(l3 >>> 48);
                byArray[n4++] = (byte)(l3 >>> 56);
                ++n6;
            }
        }
        this.write(byArray, 0, n3 * 8);
    }

    public void writeBit(int n2) throws IOException {
        this.writeBits(1L & (long)n2, 1);
    }

    public void writeBits(long l2, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        this.checkClosed();
        if (n2 < 0 || n2 > 64) {
            throw new IllegalArgumentException("Bad value for numBits!");
        }
        if (n2 == 0) {
            return;
        }
        long l3 = this.getStreamPosition();
        if (l3 > 0L && this.bitOffset != 0) {
            n6 = this.bitOffset;
            n5 = this.read();
            this.seek(l3 - 1L);
            if (n2 + n6 < 8) {
                n4 = 8 - (n6 + n2);
                n3 = -1 >>> 32 - n2;
                n5 &= ~(n3 << n4);
                n5 = (int)((long)n5 | (l2 & (long)n3) << n4);
                this.write(n5);
                this.seek(this.getStreamPosition() - 1L);
                this.bitOffset = n6 + n2;
                n2 = 0;
            } else {
                n4 = 8 - n6;
                n3 = -1 >>> 32 - n4;
                n5 &= ~n3;
                n5 = (int)((long)n5 | l2 >> n2 - n4 & (long)n3);
                this.write(n5);
                n2 -= n4;
            }
        }
        if (n2 > 7) {
            n6 = n2 % 8;
            n5 = n2 / 8;
            while (n5 > 0) {
                n4 = (n5 - 1) * 8 + n6;
                n3 = (int)(n4 == 0 ? l2 & 0xFFL : l2 >> n4 & 0xFFL);
                this.write(n3);
                --n5;
            }
            n2 = n6;
        }
        if (n2 != 0) {
            n6 = 0;
            n6 = this.read();
            if (n6 != -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                n6 = 0;
            }
            n5 = 8 - n2;
            n4 = -1 >>> 32 - n2;
            n6 &= ~(n4 << n5);
            n6 = (int)((long)n6 | (l2 & (long)n4) << n5);
            this.write(n6);
            this.seek(this.getStreamPosition() - 1L);
            this.bitOffset = n2;
        }
    }

    protected final void flushBits() throws IOException {
        this.checkClosed();
        if (this.bitOffset != 0) {
            int n2 = this.bitOffset;
            int n3 = this.read();
            if (n3 < 0) {
                n3 = 0;
                this.bitOffset = 0;
            } else {
                this.seek(this.getStreamPosition() - 1L);
                n3 &= -1 << 8 - n2;
            }
            this.write(n3);
        }
    }
}

