/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();
    private static final int GZIP_MAGIC = 35615;

    public GZIPOutputStream(OutputStream outputStream, int n2) throws IOException {
        super(outputStream, new Deflater(-1, true), n2);
        this.writeHeader();
        this.crc.reset();
    }

    public GZIPOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 512);
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        super.write(byArray, n2, n3);
        this.crc.update(byArray, n2, n3);
    }

    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.writeTrailer();
        }
    }

    private void writeHeader() throws IOException {
        this.writeShort(35615);
        this.out.write(8);
        this.out.write(0);
        this.writeInt(0);
        this.out.write(0);
        this.out.write(0);
    }

    private void writeTrailer() throws IOException {
        this.writeInt((int)this.crc.getValue());
        this.writeInt(this.def.getTotalIn());
    }

    private void writeInt(int n2) throws IOException {
        this.writeShort(n2 & 0xFFFF);
        this.writeShort(n2 >> 16 & 0xFFFF);
    }

    private void writeShort(int n2) throws IOException {
        this.out.write(n2 & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
    }
}

