/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XmlSupport {
    private static final String PREFS_DTD_URI = "http://java.sun.com/dtd/preferences.dtd";
    private static final String PREFS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for preferences --><!ELEMENT preferences (root) ><!ATTLIST preferences EXTERNAL_XML_VERSION CDATA \"0.0\"  ><!ELEMENT root (map, node*) ><!ATTLIST root          type (system|user) #REQUIRED ><!ELEMENT node (map, node*) ><!ATTLIST node          name CDATA #REQUIRED ><!ELEMENT map (entry*) ><!ATTLIST map  MAP_XML_VERSION CDATA \"0.0\"  ><!ELEMENT entry EMPTY ><!ATTLIST entry          key CDATA #REQUIRED          value CDATA #REQUIRED >";
    private static final String EXTERNAL_XML_VERSION = "1.0";
    private static final String MAP_XML_VERSION = "1.0";

    XmlSupport() {
    }

    static void export(OutputStream outputStream, Preferences preferences, boolean bl2) throws IOException, BackingStoreException {
        if (((AbstractPreferences)preferences).isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(null, PREFS_DTD_URI, null);
        Element element = (Element)xmlDocument.appendChild(xmlDocument.createElement("preferences"));
        element.setAttribute("EXTERNAL_XML_VERSION", "1.0");
        Element element2 = (Element)element.appendChild(xmlDocument.createElement("root"));
        element2.setAttribute("type", preferences.isUserNode() ? "user" : "system");
        ArrayList arrayList = new ArrayList();
        Preferences preferences2 = preferences;
        Preferences preferences3 = preferences2.parent();
        while (preferences3 != null) {
            arrayList.add(preferences2);
            preferences2 = preferences3;
            preferences3 = preferences2.parent();
        }
        Element element3 = element2;
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            element3.appendChild(xmlDocument.createElement("map"));
            element3 = (Element)element3.appendChild(xmlDocument.createElement("node"));
            element3.setAttribute("name", ((Preferences)arrayList.get(n2)).name());
            --n2;
        }
        XmlSupport.putPreferencesInXml(element3, xmlDocument, preferences, bl2);
        xmlDocument.write(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putPreferencesInXml(Element element, Document document, Preferences preferences, boolean bl2) throws BackingStoreException {
        Element element2;
        Preferences[] preferencesArray = null;
        String[] stringArray = null;
        Object object = ((AbstractPreferences)preferences).lock;
        synchronized (object) {
            if (((AbstractPreferences)preferences).isRemoved()) {
                element.getParentNode().removeChild(element);
                return;
            }
            String[] stringArray2 = preferences.keys();
            element2 = (Element)element.appendChild(document.createElement("map"));
            int n2 = 0;
            while (n2 < stringArray2.length) {
                Element element3 = (Element)element2.appendChild(document.createElement("entry"));
                element3.setAttribute("key", stringArray2[n2]);
                element3.setAttribute("value", preferences.get(stringArray2[n2], null));
                ++n2;
            }
            if (bl2) {
                stringArray = preferences.childrenNames();
                preferencesArray = new Preferences[stringArray.length];
                int n3 = 0;
                while (n3 < stringArray.length) {
                    preferencesArray[n3] = preferences.node(stringArray[n3]);
                    ++n3;
                }
            }
        }
        if (bl2) {
            int n4 = 0;
            while (n4 < stringArray.length) {
                element2 = (Element)element.appendChild(document.createElement("node"));
                element2.setAttribute("name", stringArray[n4]);
                XmlSupport.putPreferencesInXml(element2, document, preferencesArray[n4], bl2);
                ++n4;
            }
        }
    }

    static void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        try {
            Document document = XmlSupport.load(inputStream);
            String string = ((Element)document.getChildNodes().item(1)).getAttribute("EXTERNAL_XML_VERSION");
            if (string.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Exported preferences file format version " + string + " is not supported. This java installation can read" + " versions " + "1.0" + " or older. You may need" + " to install a newer version of JDK.");
            }
            Element element = (Element)document.getChildNodes().item(1).getChildNodes().item(0);
            Preferences preferences = element.getAttribute("type").equals("user") ? Preferences.userRoot() : Preferences.systemRoot();
            XmlSupport.ImportSubtree(preferences, element);
        }
        catch (SAXException sAXException) {
            throw new InvalidPreferencesFormatException(sAXException);
        }
    }

    private static Document load(InputStream inputStream) throws SAXException, IOException {
        Resolver resolver = new Resolver();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new Resolver());
            documentBuilder.setErrorHandler(new EH());
            return documentBuilder.parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Error(parserConfigurationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ImportSubtree(Preferences preferences, Element element) {
        Preferences[] preferencesArray;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        Object object = ((AbstractPreferences)preferences).lock;
        synchronized (object) {
            if (((AbstractPreferences)preferences).isRemoved()) {
                return;
            }
            Element element2 = (Element)nodeList.item(0);
            XmlSupport.ImportPrefs(preferences, element2);
            preferencesArray = new Preferences[n2 - 1];
            int n3 = 1;
            while (n3 < n2) {
                Element element3 = (Element)nodeList.item(n3);
                preferencesArray[n3 - 1] = preferences.node(element3.getAttribute("name"));
                ++n3;
            }
        }
        int n4 = 1;
        while (n4 < n2) {
            XmlSupport.ImportSubtree(preferencesArray[n4 - 1], (Element)nodeList.item(n4));
            ++n4;
        }
    }

    private static void ImportPrefs(Preferences preferences, Element element) {
        NodeList nodeList = element.getChildNodes();
        int n2 = 0;
        int n3 = nodeList.getLength();
        while (n2 < n3) {
            Element element2 = (Element)nodeList.item(n2);
            preferences.put(element2.getAttribute("key"), element2.getAttribute("value"));
            ++n2;
        }
    }

    static void exportMap(OutputStream outputStream, Map map) throws IOException {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(null, PREFS_DTD_URI, null);
        Element element = (Element)xmlDocument.appendChild(xmlDocument.createElement("map"));
        element.setAttribute("MAP_XML_VERSION", "1.0");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Element element2 = (Element)element.appendChild(xmlDocument.createElement("entry"));
            element2.setAttribute("key", (String)entry.getKey());
            element2.setAttribute("value", (String)entry.getValue());
        }
        xmlDocument.write(outputStream);
    }

    static void importMap(InputStream inputStream, Map map) throws IOException, InvalidPreferencesFormatException {
        try {
            Document document = XmlSupport.load(inputStream);
            Element element = (Element)document.getChildNodes().item(1);
            String string = element.getAttribute("MAP_XML_VERSION");
            if (string.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Preferences map file format version " + string + " is not supported. This java installation can read" + " versions " + "1.0" + " or older. You may need" + " to install a newer version of JDK.");
            }
            NodeList nodeList = element.getChildNodes();
            int n2 = 0;
            int n3 = nodeList.getLength();
            while (n2 < n3) {
                Element element2 = (Element)nodeList.item(n2);
                map.put(element2.getAttribute("key"), element2.getAttribute("value"));
                ++n2;
            }
        }
        catch (SAXException sAXException) {
            throw new InvalidPreferencesFormatException(sAXException);
        }
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (string2.equals(XmlSupport.PREFS_DTD_URI)) {
                InputSource inputSource = new InputSource(new StringReader(XmlSupport.PREFS_DTD));
                inputSource.setSystemId(XmlSupport.PREFS_DTD_URI);
                return inputSource;
            }
            throw new SAXException("Invalid system identifier: " + string2);
        }
    }
}

