/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public abstract class AbstractSelectableChannel
extends SelectableChannel {
    private final SelectorProvider provider;
    private SelectionKey[] keys = null;
    private int keyCount = 0;
    private final Object keyLock = new Object();
    private final Object regLock = new Object();
    boolean blocking = true;

    protected AbstractSelectableChannel(SelectorProvider selectorProvider) {
        this.provider = selectorProvider;
    }

    public final SelectorProvider provider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKey(SelectionKey selectionKey) {
        Object object = this.keyLock;
        synchronized (object) {
            int n2 = 0;
            if (this.keys != null && this.keyCount < this.keys.length) {
                n2 = 0;
                while (n2 < this.keys.length) {
                    if (this.keys[n2] != null) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else if (this.keys == null) {
                this.keys = new SelectionKey[3];
            } else {
                int n3 = this.keys.length * 2;
                SelectionKey[] selectionKeyArray = new SelectionKey[n3];
                n2 = 0;
                while (n2 < this.keys.length) {
                    selectionKeyArray[n2] = this.keys[n2];
                    ++n2;
                }
                this.keys = selectionKeyArray;
                n2 = this.keyCount;
            }
            this.keys[n2] = selectionKey;
            ++this.keyCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SelectionKey findKey(Selector selector) {
        Object object = this.keyLock;
        synchronized (object) {
            if (this.keys == null) {
                return null;
            }
            int n2 = 0;
            while (n2 < this.keys.length) {
                if (this.keys[n2] != null && this.keys[n2].selector() == selector) {
                    return this.keys[n2];
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKey(SelectionKey selectionKey) {
        Object object = this.keyLock;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.keys.length) {
                if (this.keys[n2] == selectionKey) {
                    this.keys[n2] = null;
                    --this.keyCount;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean haveValidKeys() {
        Object object = this.keyLock;
        synchronized (object) {
            if (this.keyCount == 0) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.keys.length) {
                if (this.keys[n2] != null && this.keys[n2].isValid()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRegistered() {
        Object object = this.keyLock;
        synchronized (object) {
            boolean bl2 = this.keyCount != 0;
            return bl2;
        }
    }

    public final SelectionKey keyFor(Selector selector) {
        return this.findKey(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SelectionKey register(Selector selector, int n2, Object object) throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((n2 & ~this.validOps()) != 0) {
            throw new IllegalArgumentException();
        }
        Object object2 = this.regLock;
        synchronized (object2) {
            if (this.blocking) {
                throw new IllegalBlockingModeException();
            }
            SelectionKey selectionKey = this.findKey(selector);
            if (selectionKey != null) {
                selectionKey.interestOps(n2);
                selectionKey.attach(object);
            }
            if (selectionKey == null) {
                selectionKey = ((AbstractSelector)selector).register(this, n2, object);
                this.addKey(selectionKey);
            }
            SelectionKey selectionKey2 = selectionKey;
            return selectionKey2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void implCloseChannel() throws IOException {
        this.implCloseSelectableChannel();
        Object object = this.keyLock;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.keyCount) {
                SelectionKey selectionKey = this.keys[n2];
                if (selectionKey != null) {
                    selectionKey.cancel();
                }
                ++n2;
            }
        }
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBlocking() {
        Object object = this.regLock;
        synchronized (object) {
            boolean bl2 = this.blocking;
            return bl2;
        }
    }

    public final Object blockingLock() {
        return this.regLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SelectableChannel configureBlocking(boolean bl2) throws IOException {
        Object object = this.regLock;
        synchronized (object) {
            block5: {
                if (this.blocking != bl2) break block5;
                AbstractSelectableChannel abstractSelectableChannel = this;
                return abstractSelectableChannel;
            }
            if (bl2 && this.haveValidKeys()) {
                throw new IllegalBlockingModeException();
            }
            this.implConfigureBlocking(bl2);
            this.blocking = bl2;
        }
        return this;
    }

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;
}

