/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Printer;
import com.sun.media.sound.Toolkit;

class CircularBuffer {
    boolean convertSign = false;
    boolean convertByteOrder = false;
    private byte[] array;
    private long bytesWritten = 0L;
    private long bytesRead = 0L;
    private long end = -1L;

    CircularBuffer(int n2, boolean bl2, boolean bl3) {
        this.array = new byte[n2];
        this.convertSign = bl2;
        this.convertByteOrder = bl3;
    }

    synchronized int write(byte[] byArray, int n2, int n3) {
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: write: b: " + byArray + " off: " + n2 + " len: " + n3);
        }
        if (this.end >= 0L || n3 == 0) {
            return 0;
        }
        int n4 = Math.min(n3, this.bytesAvailableToWrite());
        if (this.convertSign) {
            Toolkit.getUnsigned8(byArray, n2, n4);
        } else if (this.convertByteOrder) {
            n4 -= n4 % 2;
            Toolkit.getByteSwapped(byArray, n2, n4);
        }
        int n5 = n4;
        while (n5 > 0) {
            int n6 = n5;
            n6 = Math.min(n6, this.array.length - this.getWriteIndex());
            System.arraycopy(byArray, n2, this.array, this.getWriteIndex(), n6);
            this.bytesWritten += (long)n6;
            n5 -= n6;
            n2 += n6;
        }
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: write: returning: " + n4);
        }
        return n4;
    }

    synchronized int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: read: b: " + byArray + " off: " + n2 + " len: " + n3);
        }
        if (this.end >= 0L && this.bytesRead >= this.bytesWritten) {
            return -1;
        }
        int n5 = n4 = Math.min(n3, this.bytesAvailableToRead());
        while (n5 > 0) {
            int n6 = n5;
            n6 = Math.min(n6, this.array.length - this.getReadIndex());
            System.arraycopy(this.array, this.getReadIndex(), byArray, n2, n6);
            this.bytesRead += (long)n6;
            n5 -= n6;
            n2 += n6;
        }
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: read: returning: " + n4);
        }
        return n4;
    }

    synchronized int writeover(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getByteLength();
        if (n3 > n5) {
            n4 = n3 - n5;
            n2 += n4;
            n3 = n5;
            this.flush();
        } else if (n3 > this.bytesAvailableToWrite()) {
            n4 = n3 - this.bytesAvailableToWrite();
            this.skip(n4);
        }
        this.write(byArray, n2, n3);
        return n4;
    }

    synchronized void flush() {
        this.bytesRead = this.bytesWritten;
    }

    void drain() {
        long l2 = this.bytesWritten;
        if (Printer.debug) {
            Printer.debug("CircularBuffer.drain(): bytesWritten=" + this.bytesWritten + " bytesRead=" + this.bytesRead + " bytesAvailableToRead()=" + this.bytesAvailableToRead() + " getByteLength()=" + this.getByteLength());
        }
        int n2 = 400;
        while (this.bytesRead < l2 && n2-- > 0) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    synchronized int skip(int n2) {
        int n3 = Math.min(n2, this.bytesAvailableToRead());
        this.bytesRead += (long)n3;
        return n3;
    }

    synchronized void markEnd() {
        this.end = this.bytesWritten;
    }

    int bytesAvailableToRead() {
        return (int)(this.bytesWritten - this.bytesRead);
    }

    int bytesAvailableToWrite() {
        return this.end >= 0L ? 0 : this.array.length - this.bytesAvailableToRead();
    }

    int getByteLength() {
        return this.array.length;
    }

    private int getReadIndex() {
        return (int)(this.bytesRead % (long)this.array.length);
    }

    private int getWriteIndex() {
        return (int)(this.bytesWritten % (long)this.array.length);
    }
}

