/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.NameNode;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.Vector;

class ZoneNode
extends NameNode {
    private SoftReference contentsRef = null;
    private long serialNumber = -1L;
    private Date expiration = null;

    ZoneNode(String string) {
        super(string);
    }

    protected NameNode newNameNode(String string) {
        return new ZoneNode(string);
    }

    boolean isPopulated() {
        return this.getContents() != null;
    }

    synchronized NameNode getContents() {
        return this.contentsRef != null ? (NameNode)this.contentsRef.get() : null;
    }

    synchronized boolean isExpired() {
        return this.expiration != null && this.expiration.before(new Date());
    }

    ZoneNode getDeepestPopulated(String[] stringArray) {
        ZoneNode zoneNode = this;
        ZoneNode zoneNode2 = this.isPopulated() ? this : null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if ((zoneNode = (ZoneNode)zoneNode.get(stringArray[n2])) == null) break;
            if (zoneNode.isPopulated()) {
                zoneNode2 = zoneNode;
            }
            ++n2;
        }
        return zoneNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NameNode populate(String[] stringArray, ResourceRecords resourceRecords) {
        NameNode nameNode;
        String[] stringArray2;
        ResourceRecord resourceRecord;
        NameNode nameNode2 = new NameNode(null);
        int n2 = 0;
        while (n2 < resourceRecords.answer.size()) {
            resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(n2);
            stringArray2 = ZoneNode.getRrLabels(resourceRecord);
            if (stringArray2.length > this.depth() && ZoneNode.isPrefix(stringArray, stringArray2)) {
                nameNode = nameNode2.add(stringArray2, this.depth());
                if (resourceRecord.getType() == 2) {
                    nameNode.setZoneCut(true);
                }
            }
            ++n2;
        }
        resourceRecord = (ResourceRecord)resourceRecords.answer.firstElement();
        stringArray2 = this;
        synchronized (stringArray2) {
            this.contentsRef = new SoftReference(nameNode2);
            this.serialNumber = ZoneNode.getSerialNumber(resourceRecord);
            super.setExpiration(ZoneNode.getMinimumTtl(resourceRecord));
            nameNode = nameNode2;
            return nameNode;
        }
    }

    private void setExpiration(long l2) {
        this.expiration = new Date(System.currentTimeMillis() + 1000L * l2);
    }

    private static long getMinimumTtl(ResourceRecord resourceRecord) {
        String string = (String)resourceRecord.getRdata();
        int n2 = string.lastIndexOf(32) + 1;
        return Long.parseLong(string.substring(n2));
    }

    private static long getSerialNumber(ResourceRecord resourceRecord) {
        String string = (String)resourceRecord.getRdata();
        int n2 = string.length();
        int n3 = -1;
        int n4 = 0;
        while (n4 < 5) {
            n3 = n2;
            n2 = string.lastIndexOf(32, n3 - 1);
            ++n4;
        }
        return Long.parseLong(string.substring(n2 + 1, n3));
    }

    private static boolean isPrefix(String[] stringArray, String[] stringArray2) {
        if (stringArray.length > stringArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].equalsIgnoreCase(stringArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String[] getRrLabels(ResourceRecord resourceRecord) {
        Vector vector = resourceRecord.getLabels();
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = stringArray.length - 1 - n2;
            stringArray[n2] = (String)vector.elementAt(n3);
            ++n2;
        }
        return stringArray;
    }
}

