/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.orbutil.FastCacheTable;

public class CacheTable {
    private static final int kGrowthRate = 10;
    private static final int kMaxCacheSize = 30;
    private static final int kKeysPos = 0;
    private static final int kValsPos = 1;
    private static final Object[][] cache = new Object[31][2];
    private static int cacheIndex = -1;
    private Object[] keys = null;
    private int[] vals = null;
    private int index = 0;
    private int lastFoundIndex = 0;
    private FastCacheTable hashedTable = null;

    private CacheTable() {
    }

    public CacheTable(boolean bl2) {
        if (bl2) {
            this.hashedTable = new FastCacheTable();
        }
    }

    public final void put(Object object, int n2) {
        if (this.hashedTable != null) {
            this.hashedTable.put(object, n2);
            return;
        }
        if (object == null) {
            return;
        }
        if (!this.containsKey(object)) {
            this.checkForGrowth();
            this.keys[this.index] = object;
            this.vals[this.index] = n2;
            ++this.index;
        }
    }

    public final boolean containsKey(Object object) {
        if (this.hashedTable != null) {
            return this.hashedTable.containsKey(object);
        }
        int n2 = this.lastFoundIndex;
        while (n2 < this.index) {
            if (this.keys[n2] == object) {
                this.lastFoundIndex = n2;
                return true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.lastFoundIndex) {
            if (this.keys[n3] == object) {
                this.lastFoundIndex = n3;
                return true;
            }
            ++n3;
        }
        return false;
    }

    public final int getVal(Object object) {
        if (this.hashedTable != null) {
            return this.hashedTable.getVal(object);
        }
        int n2 = this.lastFoundIndex;
        while (n2 < this.index) {
            if (this.keys[n2] == object) {
                this.lastFoundIndex = n2;
                return this.vals[n2];
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.lastFoundIndex) {
            if (this.keys[n3] == object) {
                this.lastFoundIndex = n3;
                return this.vals[n3];
            }
            ++n3;
        }
        return -1;
    }

    public final boolean containsVal(int n2) {
        int n3 = this.lastFoundIndex;
        while (n3 < this.index) {
            if (this.vals[n3] == n2) {
                this.lastFoundIndex = n3;
                return true;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.lastFoundIndex) {
            if (this.vals[n4] == n2) {
                this.lastFoundIndex = n4;
                return true;
            }
            ++n4;
        }
        return false;
    }

    public final boolean containsOrderedVal(int n2) {
        int n3 = 0;
        int n4 = this.index;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            int n6 = this.vals[n5];
            if (n6 < n2) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n2) {
                n4 = n5 - 1;
                continue;
            }
            this.lastFoundIndex = n5;
            return true;
        }
        return false;
    }

    public final Object getKey(int n2) {
        int n3 = this.lastFoundIndex;
        while (n3 < this.index) {
            if (this.vals[n3] == n2) {
                this.lastFoundIndex = n3;
                return this.keys[n3];
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.lastFoundIndex) {
            if (this.vals[n4] == n2) {
                this.lastFoundIndex = n4;
                return this.keys[n4];
            }
            ++n4;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        if (this.hashedTable != null) {
            this.hashedTable.done();
            return;
        }
        Object[][] objectArray = cache;
        synchronized (objectArray) {
            if (cacheIndex < 30) {
                CacheTable.cache[++CacheTable.cacheIndex][0] = this.keys;
                CacheTable.cache[CacheTable.cacheIndex][1] = this.vals;
            }
        }
        this.keys = null;
        this.vals = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkForGrowth() {
        if (this.keys == null) {
            Object[][] objectArray = cache;
            synchronized (objectArray) {
                if (cacheIndex > -1) {
                    this.keys = (Object[])cache[cacheIndex][0];
                    this.vals = (int[])cache[cacheIndex][1];
                    --cacheIndex;
                    return;
                }
            }
            this.keys = new Object[10];
            this.vals = new int[10];
        } else if (this.keys.length == this.index) {
            Object[] objectArray = new Object[this.index + 10];
            int[] nArray = new int[this.index + 10];
            System.arraycopy(this.keys, 0, objectArray, 0, this.index);
            System.arraycopy(this.vals, 0, nArray, 0, this.index);
            Object[][] objectArray2 = cache;
            synchronized (objectArray2) {
                if (cacheIndex < 30) {
                    CacheTable.cache[++CacheTable.cacheIndex][0] = this.keys;
                    CacheTable.cache[CacheTable.cacheIndex][1] = this.vals;
                }
            }
            this.keys = objectArray;
            this.vals = nArray;
        }
    }
}

