/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.ConstraintsChecker;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.PKIXMasterCertPathValidator;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.util.Debug;

public class PKIXCertPathValidator
extends CertPathValidatorSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private Date testDate;
    private List userCheckers;
    private String sigProvider;
    private BasicChecker basicChecker;

    /*
     * Unable to fully structure code
     */
    public CertPathValidatorResult engineValidate(CertPath var1_1, CertPathParameters var2_2) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        if (PKIXCertPathValidator.debug != null) {
            PKIXCertPathValidator.debug.println("PKIXCertPathValidator.engineValidate()...");
        }
        if (!(var2_2 instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("inappropriate parameters, must be an instance of PKIXParameters");
        }
        if (!var1_1.getType().equals("X.509") && !var1_1.getType().equals("X509")) {
            throw new InvalidAlgorithmParameterException("inappropriate certification path type specified, must be X.509 or X509");
        }
        var3_3 = (PKIXParameters)var2_2;
        var4_4 = var3_3.getTrustAnchors().iterator();
        if (var4_4.hasNext()) ** GOTO lbl15
        throw new InvalidAlgorithmParameterException("must specify at least one trust anchor");
lbl-1000:
        // 1 sources

        {
            var5_5 = (TrustAnchor)var4_4.next();
            if (var5_5.getNameConstraints() == null) continue;
            var6_6 = "name constraints in trust anchor not supported";
            throw new InvalidAlgorithmParameterException(var6_6);
lbl15:
            // 2 sources

            ** while (var4_4.hasNext())
        }
lbl16:
        // 1 sources

        var5_5 = new ArrayList(var1_1.getCertificates());
        if (var5_5.isEmpty() && PKIXCertPathValidator.debug != null) {
            PKIXCertPathValidator.debug.println("PKIXCertPathValidator.engineValidate() certList is empty");
        }
        if (PKIXCertPathValidator.debug != null) {
            PKIXCertPathValidator.debug.println("PKIXCertPathValidator.engineValidate() reversing certpath...");
        }
        Collections.reverse((List)var5_5);
        this.populateVariables(var3_3);
        var6_7 = null;
        if (!var5_5.isEmpty()) {
            var6_7 = (X509Certificate)var5_5.get(0);
        }
        var7_8 = null;
        var8_9 = null;
        var9_10 = null;
        var10_11 = null;
        var11_12 = null;
        var4_4 = var3_3.getTrustAnchors().iterator();
        while (var4_4.hasNext()) {
            var11_12 = (TrustAnchor)var4_4.next();
            var7_8 = var11_12.getTrustedCert();
            if (var7_8 != null) {
                if (PKIXCertPathValidator.debug != null) {
                    PKIXCertPathValidator.debug.println("PKIXCertPathValidator.engineValidate() anchor.getTrustedCert() != null");
                }
                if (var4_4.hasNext() && !this.isWorthTrying(var7_8, var6_7)) continue;
                var8_9 = var7_8.getPublicKey();
                var9_10 = var7_8.getSubjectX500Principal();
                if (PKIXCertPathValidator.debug != null) {
                    PKIXCertPathValidator.debug.println("anchor.getTrustedCert().getSubjectDN() = " + var9_10);
                }
            } else {
                if (PKIXCertPathValidator.debug != null) {
                    PKIXCertPathValidator.debug.println("PKIXCertPathValidator.engineValidate(): anchor.getTrustedCert() == null");
                }
                var8_9 = var11_12.getCAPublicKey();
                var9_10 = new X500Principal(var11_12.getCAName());
            }
            try {
                var12_14 = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, Collections.singleton("2.5.29.32.0"), false);
                var10_11 = this.doValidate(var8_9, var9_10, var1_1, (List)var5_5, var3_3, var12_14);
                break;
            }
            catch (CertPathValidatorException var12_13) {
                if (var4_4.hasNext()) continue;
                throw var12_13;
            }
        }
        return new PKIXCertPathValidatorResult(var11_12, var10_11, this.basicChecker.getPublicKey());
    }

    private boolean isWorthTrying(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertPathValidatorException {
        if (debug != null) {
            debug.println("PKIXCertPathValidator.isWorthTrying() checking if this trusted cert is worth trying ...");
        }
        if (x509Certificate2 == null) {
            return true;
        }
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            X500Principal x500Principal = x509Certificate2.getIssuerX500Principal();
            x509CertSelector.setSubject(x500Principal.getName("RFC2253"));
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("error parsing issuer DN of trusted certificate", iOException);
        }
        if (x509CertSelector.match(x509Certificate)) {
            if (debug != null) {
                debug.println("YES - try this trustedCert");
            }
            return true;
        }
        if (debug != null) {
            debug.println("NO - don't try this trustedCert");
        }
        return false;
    }

    private void populateVariables(PKIXParameters pKIXParameters) throws CertPathValidatorException {
        this.testDate = pKIXParameters.getDate();
        if (this.testDate == null) {
            this.testDate = new Date(System.currentTimeMillis());
        }
        this.userCheckers = pKIXParameters.getCertPathCheckers();
        this.sigProvider = pKIXParameters.getSigProvider();
    }

    private PolicyNode doValidate(PublicKey publicKey, X500Principal x500Principal, CertPath certPath, List list, PKIXParameters pKIXParameters, PolicyNodeImpl policyNodeImpl) throws CertPathValidatorException {
        Object object;
        ArrayList arrayList = new ArrayList();
        int n2 = list.size();
        this.basicChecker = new BasicChecker(publicKey, x500Principal, this.testDate, this.sigProvider, false);
        KeyChecker keyChecker = new KeyChecker(n2, pKIXParameters.getTargetCertConstraints());
        ConstraintsChecker constraintsChecker = new ConstraintsChecker(n2);
        PolicyChecker policyChecker = new PolicyChecker(pKIXParameters.getInitialPolicies(), n2, pKIXParameters.isExplicitPolicyRequired(), pKIXParameters.isPolicyMappingInhibited(), pKIXParameters.isAnyPolicyInhibited(), pKIXParameters.getPolicyQualifiersRejected(), policyNodeImpl);
        arrayList.add(keyChecker);
        arrayList.add(constraintsChecker);
        arrayList.add(policyChecker);
        arrayList.add(this.basicChecker);
        if (pKIXParameters.isRevocationEnabled()) {
            object = new CrlRevocationChecker(publicKey, pKIXParameters.getCertStores(), this.sigProvider, this.testDate);
            arrayList.add(object);
        }
        arrayList.addAll(this.userCheckers);
        object = new PKIXMasterCertPathValidator(arrayList);
        ((PKIXMasterCertPathValidator)object).validate(certPath, list);
        return policyChecker.getPolicyTree();
    }
}

