/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsRep;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.ServiceName;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.a0;
import sun.security.krb5.internal.bm;
import sun.security.krb5.internal.bo;
import sun.security.krb5.internal.ccache.al;
import sun.security.krb5.internal.ccache.ar;
import sun.security.krb5.internal.ktab.aw;
import sun.security.krb5.internal.m;

public class Credentials {
    Ticket a;
    PrincipalName b;
    PrincipalName c;
    EncryptionKey d;
    TicketFlags e;
    KerberosTime f;
    KerberosTime g;
    KerberosTime h;
    KerberosTime i;
    HostAddresses j;
    EncryptionKey k;
    private static boolean l = bo.ea;
    private static al m;
    private static boolean n;
    private static boolean o;

    private static native Credentials acquireDefaultNativeCreds();

    public Credentials(Ticket ticket, PrincipalName principalName, PrincipalName principalName2, EncryptionKey encryptionKey, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses) {
        this.a = ticket;
        this.b = principalName;
        this.c = principalName2;
        this.d = encryptionKey;
        this.e = ticketFlags;
        this.f = kerberosTime;
        this.g = kerberosTime2;
        this.h = kerberosTime3;
        this.i = kerberosTime4;
        this.j = hostAddresses;
    }

    public Credentials(byte[] byArray, String string, String string2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws KrbException, IOException {
        this(new Ticket(byArray), new PrincipalName(string), new PrincipalName(string2), new EncryptionKey(n2, byArray2), blArray == null ? null : new TicketFlags(blArray), date == null ? null : new KerberosTime(date), date2 == null ? null : new KerberosTime(date2), date3 == null ? null : new KerberosTime(date3), date4 == null ? null : new KerberosTime(date4), null);
    }

    public Credentials(Credentials credentials, PrincipalName principalName) throws KrbException {
    }

    public final PrincipalName getClient() {
        return this.b;
    }

    public final PrincipalName getServer() {
        return this.c;
    }

    public final EncryptionKey getSessionKey() {
        return this.d;
    }

    public final Date getAuthTime() {
        if (this.f != null) {
            return this.f.toDate();
        }
        return null;
    }

    public final Date getStartTime() {
        if (this.g != null) {
            return this.g.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.h != null) {
            return this.h.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.i != null) {
            return this.i.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.e == null) {
            return null;
        }
        return this.e.a();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.j == null) {
            return null;
        }
        return this.j.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                byArray = this.a.asn1Encode();
            }
            catch (Asn1Exception asn1Exception) {
                if (l) {
                    System.out.println(asn1Exception);
                }
            }
            catch (IOException iOException) {
                if (!l) break block4;
                System.out.println(iOException);
            }
        }
        return byArray;
    }

    public boolean isForwardable() {
        return this.e.a(1);
    }

    public boolean isRenewable() {
        return this.e.a(8);
    }

    public Ticket getTicket() {
        return this.a;
    }

    public TicketFlags getTicketFlags() {
        return this.e;
    }

    public boolean checkDelegate() {
        boolean bl2 = false;
        try {
            bl2 = this.e.a(13);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    public Credentials renew() throws KrbException, IOException {
        m m2 = new m();
        m2.a(30, true);
        m2.a(8, true);
        KrbTgsReq krbTgsReq = new KrbTgsReq(m2, this, this.c, null, null, null, null, this.j, null, null, null);
        krbTgsReq.send();
        KrbTgsRep krbTgsRep = krbTgsReq.getReply(this);
        return krbTgsRep.getCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, String string) throws KrbException, IOException {
        Object object;
        if (string == null && ((String)(object = System.getProperty("os.name"))).equalsIgnoreCase("windows 2000")) {
            Credentials credentials = Credentials.acquireDefaultCreds();
            if (credentials == null) {
                System.out.println(">>> Found no TGT's in LSA");
                return null;
            }
            if (principalName != null) {
                if (credentials.getServer().equals(principalName)) {
                    if (l) {
                        System.out.println(">>> Obtained TGT from LSA: " + credentials);
                    }
                    return credentials;
                }
                System.out.println(">>> LSA contains TGT for " + credentials.getServer() + " not " + principalName);
                return null;
            }
            if (l) {
                System.out.println(">>> Obtained TGT from LSA: " + credentials);
            }
            return credentials;
        }
        object = al.a(principalName, string);
        if (object == null) {
            return null;
        }
        ar ar2 = ((al)object).c();
        return ar2.c();
    }

    public static Credentials acquireTGT(PrincipalName principalName, EncryptionKey encryptionKey) throws KrbException, IOException {
        if (principalName == null) {
            throw new IllegalArgumentException("Cannot have null principal to do AS-Exchange");
        }
        if (encryptionKey == null) {
            throw new IllegalArgumentException("Cannot have null secretKey to do AS-Exchange");
        }
        KrbAsReq krbAsReq = new KrbAsReq(principalName, encryptionKey);
        krbAsReq.send();
        KrbAsRep krbAsRep = krbAsReq.getReply(encryptionKey);
        return krbAsRep.getCreds();
    }

    public static Credentials acquireDefaultCreds() {
        Credentials credentials = null;
        if (m == null) {
            m = al.a();
        }
        if (m != null) {
            if (l) {
                System.out.println(">>> KrbCreds found the default ticket granting ticket in credential cache.");
            }
            ar ar2 = m.c();
            credentials = ar2.c();
        } else {
            if (!o) {
                try {
                    Credentials.a();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    o = true;
                }
            }
            if (n && (credentials = Credentials.acquireDefaultNativeCreds()) != null) {
                return credentials;
            }
        }
        return credentials;
    }

    static Credentials a(String string) {
        return Credentials.acquireCreds(string, null);
    }

    public static Credentials acquireCreds(String string, String string2) {
        Credentials credentials = null;
        try {
            PrincipalName principalName = new PrincipalName(string);
            String string3 = string2;
            if (string3 == null) {
                string3 = Config.getInstance().getDefaultRealm();
            }
            if (principalName.getRealm() == null) {
                if (string3 != null) {
                    principalName.setRealm(string3);
                }
            } else if (string3 == null) {
                string3 = principalName.getRealmString();
            }
            if (string3 != null) {
                credentials = Credentials.a(principalName, string3, null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return credentials;
    }

    public static Credentials getServiceCreds(String string, File file) {
        Object object;
        EncryptionKey encryptionKey = null;
        PrincipalName principalName = null;
        Credentials credentials = null;
        try {
            principalName = new PrincipalName(string);
            if (principalName.getRealm() == null) {
                object = Config.getInstance().getDefaultRealm();
                if (object == null) {
                    return null;
                }
                principalName.setRealm((String)object);
            }
        }
        catch (RealmException realmException) {
            return null;
        }
        catch (KrbException krbException) {
            krbException.getMessage();
            return null;
        }
        object = file == null ? aw.a() : aw.a(file);
        if (object != null && ((aw)object).c(principalName)) {
            encryptionKey = ((aw)object).a(principalName);
            credentials = new Credentials(null, principalName, null, null, null, null, null, null, null, null);
            credentials.k = encryptionKey;
        }
        return credentials;
    }

    private static Credentials a(PrincipalName principalName, String string, String string2, bm bm2) {
        Realm realm = null;
        PrincipalName principalName2 = null;
        Credentials credentials = null;
        try {
            if (principalName != null && string != null) {
                ar ar2;
                principalName2 = new PrincipalName("krbtgt/" + string + new Character('@') + string);
                realm = new Realm(string);
                if (m != null && !m.getPrimaryPrincipal().match(principalName)) {
                    m.destroy();
                    m = null;
                }
                if (m == null) {
                    m = string2 == null ? al.a(principalName) : al.a(principalName, string2);
                }
                if (m != null && m.getCredsList() != null && (ar2 = m.a(bm2, principalName2, realm)) != null && ar2.a()) {
                    if (l) {
                        System.out.println(">>> KrbCreds found the valid ticket granting ticket in credential cache.");
                    }
                    credentials = ar2.c();
                }
            }
        }
        catch (Exception exception) {
            credentials = null;
        }
        if (credentials == null) {
            m = null;
        }
        return credentials;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws KrbException, IOException {
        return a0.a(string, credentials);
    }

    private static Credentials a(ServiceName serviceName, Credentials credentials) throws KrbException, IOException {
        KrbTgsReq krbTgsReq = new KrbTgsReq(new m(), credentials, serviceName, null, null, null, null, null, null, null, null);
        krbTgsReq.send();
        KrbTgsRep krbTgsRep = krbTgsReq.getReply(credentials);
        return krbTgsRep.getCreds();
    }

    public al getCache() {
        return m;
    }

    public EncryptionKey getServiceKey() {
        return this.k;
    }

    public static void printDebug(Credentials credentials) {
        System.out.println(">>> DEBUG: ----Credentials----");
        System.out.println("\tclient: " + credentials.b.toString());
        System.out.println("\tserver: " + credentials.c.toString());
        System.out.println("\tticket: realm: " + credentials.a.realm.toString());
        System.out.println("\t        sname: " + credentials.a.sname.toString());
        System.out.println("\tstartTime: " + credentials.g.getTime());
        System.out.println("\tendTime: " + credentials.h.getTime());
        System.out.println("        ----Credentials end----");
    }

    static String b(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector vector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        try {
            Process process = Runtime.getRuntime().exec((String[])objectArray);
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            BufferedReader bufferedReader2 = null;
            try {
                bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream(), "8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String string2 = null;
            string2 = bufferedReader.readLine();
            if (string2 != null) {
                return string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static void a() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("w2k_lsa_auth");
                return null;
            }
        });
        n = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Credentials:");
        stringBuffer.append("\nclient=").append(this.b);
        stringBuffer.append("\nserver=").append(this.c);
        stringBuffer.append("\nauthTime=").append(this.f);
        stringBuffer.append("\nstartTime=").append(this.g);
        stringBuffer.append("\nendTime=").append(this.h);
        stringBuffer.append("\nrenewTill=").append(this.i);
        stringBuffer.append("\nflags: ").append(this.e);
        stringBuffer.append("\nEType (int): ").append(this.d.getEType());
        return stringBuffer.toString();
    }

    static {
        n = false;
        o = false;
    }
}

